/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.tools.gui;

import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import javax.swing.JPanel;

public class SemiRoundedPanel
extends JPanel {
    private transient int curveRadius;
    private transient int alpha;
    private transient Orientation orientation;

    public SemiRoundedPanel() {
        this(Color.BLACK);
    }

    public SemiRoundedPanel(Color background) {
        this((LayoutManager)new BorderLayout(), background);
    }

    public SemiRoundedPanel(LayoutManager layout) {
        this(layout, Color.BLACK);
    }

    public SemiRoundedPanel(LayoutManager layout, Color color) {
        super(layout);
        this.initComponents();
        this.setOpaque(false);
        this.setBackground(color);
        this.setCurveLocation(Orientation.NORTH);
        this.setCurveRadius(10);
        this.setAlpha(0);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        Color old = g2d.getColor();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setColor(this.getBackground());
        int diameter = this.curveRadius + this.curveRadius;
        g2d.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), diameter, diameter);
        Composite save = g2d.getComposite();
        g2d.setComposite(AlphaComposite.Src);
        switch (this.orientation) {
            case NORTH: {
                g2d.fillRect(0, this.curveRadius, this.getWidth(), this.getHeight() - this.curveRadius);
                break;
            }
            case NORTHEAST: {
                g2d.fillRect(0, this.curveRadius, this.getWidth(), this.getHeight() - this.curveRadius);
                g2d.fillRect(0, 0, this.getWidth() - this.curveRadius, this.getHeight());
                break;
            }
            case EAST: {
                g2d.fillRect(0, 0, this.getWidth() - this.curveRadius, this.getHeight());
                break;
            }
            case SOUTHEAST: {
                g2d.fillRect(0, 0, this.getWidth(), this.getHeight() - this.curveRadius);
                g2d.fillRect(0, 0, this.getWidth() - this.curveRadius, this.getHeight());
                break;
            }
            case SOUTH: {
                g2d.fillRect(0, 0, this.getWidth(), this.getHeight() - this.curveRadius);
                break;
            }
            case SOUTHWEST: {
                g2d.fillRect(0, 0, this.getWidth(), this.getHeight() - this.curveRadius);
                g2d.fillRect(this.curveRadius, 0, this.getWidth() - this.curveRadius, this.getHeight());
                break;
            }
            case WEST: {
                g2d.fillRect(this.curveRadius, 0, this.getWidth() - this.curveRadius, this.getHeight());
                break;
            }
            case NORTHWEST: {
                g2d.fillRect(0, this.curveRadius, this.getWidth(), this.getHeight() - this.curveRadius);
                g2d.fillRect(this.curveRadius, 0, this.getWidth() - this.curveRadius, this.getHeight());
                break;
            }
        }
        g2d.setComposite(save);
        g2d.setColor(old);
    }

    public final void setCurveRadius(int curve) {
        this.curveRadius = curve;
    }

    public final int getCurveRadius() {
        return this.curveRadius;
    }

    public final void setCurveLocation(Orientation orientation) {
        this.orientation = orientation;
    }

    public final Orientation getCurveLocation() {
        return this.orientation;
    }

    public final int getAlpha() {
        return this.alpha;
    }

    public final void setAlpha(int alpha) {
        this.alpha = alpha;
        this.setBackground(new Color(this.getBackground().getRed(), this.getBackground().getGreen(), this.getBackground().getBlue(), alpha));
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    public static enum Orientation {
        NORTH,
        NORTHEAST,
        EAST,
        SOUTHEAST,
        SOUTH,
        SOUTHWEST,
        WEST,
        NORTHWEST;

    }
}

