/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.tools.gui;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.cismet.tools.Static2DTools;
import de.cismet.tools.gui.ConfirmationJFileChooser;
import de.cismet.tools.gui.ExtensionAwareFileFilter;
import de.cismet.tools.gui.RestrictedFileSystemView;
import de.cismet.tools.gui.UITweaks;
import de.cismet.tools.gui.VerticalTextIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.autocomplete.AutoCompleteDecorator;
import org.openide.util.NbBundle;

public class StaticSwingTools {
    private static final Logger log = Logger.getLogger(StaticSwingTools.class);

    public static void jTreeExpandAllNodes(JTree tree) {
        for (int row = 0; row < tree.getRowCount(); ++row) {
            tree.expandRow(row);
        }
    }

    public static void jTreeExpandAllNodesAndScroll2Last(JTree tree) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)tree.getModel().getRoot();
        tree.scrollPathToVisible(new TreePath(root.getLastLeaf().getPath()));
    }

    public static void jTreeCollapseAllNodes(JTree tree) {
        TreePath p = tree.getSelectionPath();
        tree.setSelectionPath(p);
        for (int row = tree.getRowCount() - 1; row >= 0; --row) {
            tree.collapseRow(row);
        }
        tree.setSelectionPath(p);
    }

    public static void doClickButtonOnKeyStroke(final JButton button, KeyStroke keyStroke, JRootPane rootPane) {
        rootPane.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                button.doClick();
            }
        }, keyStroke, 2);
    }

    public static <T extends Component> T findSpecificParentComponent(Container c, Class<T> clazz) {
        while (c != null && !clazz.isAssignableFrom(c.getClass())) {
            c = c.getParent();
        }
        return (T)c;
    }

    public static void jTableScrollToVisible(JTable table, int rowIndex, int vColIndex) {
        if (!(table.getParent() instanceof JViewport)) {
            return;
        }
        JViewport viewport = (JViewport)table.getParent();
        Rectangle rect = table.getCellRect(rowIndex, vColIndex, true);
        Point pt = viewport.getViewPosition();
        rect.setLocation(rect.x - pt.x, rect.y - pt.y);
        viewport.scrollRectToVisible(rect);
    }

    public static String getLinkFromDropEvent(DropTargetDropEvent dtde) {
        Object link = null;
        Transferable t = dtde.getTransferable();
        DataFlavor[] flavors = t.getTransferDataFlavors();
        for (int i = 0; i < flavors.length; ++i) {
            DataFlavor flavor = flavors[i];
            try {
                if (flavor.equals(DataFlavor.javaFileListFlavor)) {
                    List l = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                    for (File file : l) {
                        System.out.println(file);
                        try {
                            String can = file.getCanonicalPath();
                            return can;
                        }
                        catch (IOException ex) {
                            log.warn((Object)"Fehler bei file.getCanonicalPath()", (Throwable)ex);
                        }
                    }
                    continue;
                }
                if (!flavor.equals(DataFlavor.stringFlavor)) continue;
                String fileOrURL = (String)t.getTransferData(flavor);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("GOT STRING: " + fileOrURL));
                }
                try {
                    URL url = new URL(fileOrURL);
                    return url.toString();
                }
                catch (MalformedURLException ex) {
                    log.warn((Object)"Illegal URL", (Throwable)ex);
                    return null;
                }
            }
            catch (IOException ex) {
                log.warn((Object)("IOError getting data: " + ex));
                continue;
            }
            catch (UnsupportedFlavorException e) {
                log.warn((Object)"Unsupported Flavor: ", (Throwable)e);
            }
        }
        return null;
    }

    public static void jTabbedPaneWithVerticalTextAddTab(JTabbedPane tabPane, String text, JComponent comp) {
        StaticSwingTools.jTabbedPaneWithVerticalTextAddTab(tabPane, text, null, comp);
    }

    public static void jTabbedPaneWithVerticalTextAddTab(JTabbedPane tabPane, String text, Icon icon, JComponent comp) {
        int tabPlacement = tabPane.getTabPlacement();
        Object textIconGap = UIManager.get("TabbedPane.textIconGap");
        Insets tabInsets = UIManager.getInsets("TabbedPane.tabInsets");
        tabInsets.set(tabInsets.left, tabInsets.top, tabInsets.right, tabInsets.bottom);
        UIManager.put("TabbedPane.textIconGap", new Integer(1));
        UIManager.put("TabbedPane.tabInsets", tabInsets);
        SwingUtilities.updateComponentTreeUI(tabPane);
        switch (tabPlacement) {
            case 2: 
            case 4: {
                Icon newIcon;
                if (icon == null) {
                    tabPane.addTab(null, new VerticalTextIcon(text, tabPlacement == 4), comp);
                    break;
                }
                if (tabPlacement == 4) {
                    Icon[] icons = new Icon[]{new VerticalTextIcon(text, tabPlacement == 4), icon};
                    newIcon = Static2DTools.joinIcons((Icon[])icons, (int)6, (int)Static2DTools.VERTICAL, (int)Static2DTools.CENTER);
                } else {
                    Icon[] icons = new Icon[2];
                    icons[1] = icon;
                    icons[0] = new VerticalTextIcon(text, tabPlacement == 4);
                    newIcon = Static2DTools.joinIcons((Icon[])icons, (int)6, (int)Static2DTools.VERTICAL, (int)Static2DTools.CENTER);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("newIconHeight" + newIcon.getIconHeight()));
                }
                tabPane.addTab(null, newIcon, comp);
                break;
            }
            default: {
                tabPane.addTab(text, null, comp);
            }
        }
        tabInsets.set(tabInsets.left, tabInsets.top, tabInsets.right, tabInsets.bottom);
        UIManager.put("TabbedPane.tabInsets", tabInsets);
    }

    public static void jTabbedPaneWithVerticalTextSetNewText(JTabbedPane tabPane, String text, JComponent comp) {
        StaticSwingTools.jTabbedPaneWithVerticalTextSetNewText(tabPane, text, null, comp);
    }

    public static void jTabbedPaneWithVerticalTextSetNewText(JTabbedPane tabPane, String text, Icon icon, JComponent comp) {
        StaticSwingTools.jTabbedPaneWithVerticalTextSetNewText(tabPane, text, icon, Color.black, comp);
    }

    public static void jTabbedPaneWithVerticalTextSetNewText(JTabbedPane tabPane, String text, Icon icon, Color textColor, JComponent comp) {
        int tabPlacement = tabPane.getTabPlacement();
        switch (tabPlacement) {
            case 2: 
            case 4: {
                if (icon == null) {
                    tabPane.setIconAt(tabPane.indexOfComponent(comp), new VerticalTextIcon(text, tabPlacement == 4, textColor));
                } else {
                    Icon newIcon;
                    if (tabPlacement == 4) {
                        Icon[] icons = new Icon[]{new VerticalTextIcon(text, tabPlacement == 4, textColor), icon};
                        newIcon = Static2DTools.joinIcons((Icon[])icons, (int)6, (int)Static2DTools.VERTICAL, (int)Static2DTools.CENTER);
                    } else {
                        Icon[] icons = new Icon[2];
                        icons[1] = icon;
                        icons[0] = new VerticalTextIcon(text, tabPlacement == 4, textColor);
                        newIcon = Static2DTools.joinIcons((Icon[])icons, (int)6, (int)Static2DTools.VERTICAL, (int)Static2DTools.CENTER);
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("newIconHeight" + newIcon.getIconHeight()));
                    }
                    tabPane.setIconAt(tabPane.indexOfComponent(comp), newIcon);
                }
                return;
            }
        }
        tabPane.setTitleAt(tabPane.indexOfComponent(comp), text);
    }

    public static JTabbedPane jTabbedPaneWithVerticalTextCreator(int tabPlacement) {
        Enumeration keys = UIManager.getDefaults().keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = UIManager.get(key);
            if (key.toString().indexOf("abbed") == -1 || !log.isDebugEnabled()) continue;
            log.debug((Object)(key + "," + value));
        }
        switch (tabPlacement) {
            case 2: 
            case 4: {
                JTabbedPane tabPane = new JTabbedPane(tabPlacement);
                return tabPane;
            }
        }
        return new JTabbedPane(tabPlacement);
    }

    public static JTabbedPane jTabbedPaneWithVerticalTextCreator(int tabPlacement, int tabLayoutPolicy) {
        JTabbedPane jtp = StaticSwingTools.jTabbedPaneWithVerticalTextCreator(tabPlacement);
        return jtp;
    }

    public static void setNiftyScrollBars(JScrollPane sPane) {
        try {
            Dimension d = sPane.getVerticalScrollBar().getPreferredSize();
            sPane.getVerticalScrollBar().getComponent(0).setVisible(false);
            sPane.getVerticalScrollBar().getComponent(1).setVisible(false);
            sPane.getVerticalScrollBar().setPreferredSize(new Dimension(8, d.height));
            d = sPane.getHorizontalScrollBar().getPreferredSize();
            sPane.getHorizontalScrollBar().getComponent(0).setVisible(false);
            sPane.getHorizontalScrollBar().getComponent(1).setVisible(false);
            sPane.getHorizontalScrollBar().setPreferredSize(new Dimension(d.width, 8));
            sPane.setBackground(sPane.getViewport().getBackground());
            sPane.getHorizontalScrollBar().setBackground(sPane.getViewport().getBackground());
            sPane.getVerticalScrollBar().setBackground(sPane.getViewport().getBackground());
        }
        catch (Exception e) {
            log.warn((Object)"Cannot create the nifty scrollbars.", (Throwable)e);
        }
    }

    public static Frame getFirstParentFrame(Component c) {
        return StaticSwingTools.getParentFrame(c, true);
    }

    public static Frame getParentFrame(Component c) {
        return StaticSwingTools.getParentFrame(c, false);
    }

    public static Frame getParentFrame(Component c, boolean first) {
        try {
            Component o = c;
            do {
                o = o.getParent();
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("getParent:" + o));
            } while ((!(o instanceof Frame) || o.getParent() != null) && !first);
            if (log.isDebugEnabled()) {
                log.debug((Object)("getParentFrame returns " + o));
            }
            return (Frame)o;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.warn((Object)"getParentFrame returns null", (Throwable)e);
            }
            return null;
        }
    }

    public static Component getParentFrameIfNotNull(Component c) {
        Frame parent = StaticSwingTools.getParentFrame(c);
        if (parent == null) {
            return c;
        }
        return parent;
    }

    public static Rectangle getComponentsExtent(Component ... components) {
        Rectangle r = new Rectangle();
        Integer maxX = null;
        Integer minX = null;
        Integer maxY = null;
        Integer minY = null;
        for (Component comp : components) {
            if (maxX == null) {
                minX = comp.getX();
                minY = comp.getY();
                maxX = comp.getWidth() + minX;
                maxY = comp.getHeight() + minY;
                continue;
            }
            minX = Math.min(minX, comp.getX());
            minY = Math.min(minY, comp.getY());
            maxX = Math.max(maxX, comp.getX() + comp.getWidth());
            maxY = Math.max(maxY, comp.getY() + comp.getHeight());
        }
        r.setRect(minX.intValue(), minY.intValue(), maxX - minX, maxY - minY);
        return r;
    }

    public static void showDialog(Component parent, JDialog dialog, boolean isRelativeToParentFrame) {
        if (dialog.isVisible()) {
            dialog.toFront();
        } else if (isRelativeToParentFrame && parent != null) {
            Frame parentFrame = StaticSwingTools.getParentFrame(parent);
            dialog.setAlwaysOnTop(true);
            dialog.toFront();
            dialog.requestFocus();
            dialog.setAlwaysOnTop(false);
            if (parentFrame == null) {
                StaticSwingTools.centerWindowOnScreen(dialog);
            } else {
                dialog.setLocationRelativeTo(parentFrame);
                dialog.setVisible(true);
            }
        } else {
            StaticSwingTools.centerWindowOnScreen(dialog);
        }
    }

    public static void centerWindowOnScreen(final Window w) {
        PointerInfo pInfo = MouseInfo.getPointerInfo();
        Point pointerLocation = pInfo.getLocation();
        GraphicsConfiguration[] cfgArr = pInfo.getDevice().getConfigurations();
        Rectangle bounds = null;
        for (int i = 0; i < cfgArr.length; ++i) {
            bounds = cfgArr[i].getBounds();
            if (pointerLocation.x <= bounds.x) break;
        }
        final int x = bounds.x + (bounds.width - w.getWidth()) / 2;
        final int y = bounds.y + (bounds.height - w.getHeight()) / 2;
        if (!EventQueue.isDispatchThread()) {
            try {
                EventQueue.invokeAndWait(new Thread("centerWindowOnScreen"){

                    @Override
                    public void run() {
                        w.setLocation(x, y);
                        w.setVisible(true);
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException ex) {
                log.error((Object)"Error while center window on screen", (Throwable)ex);
            }
        } else {
            w.setLocation(x, y);
            w.setVisible(true);
        }
    }

    public static Rectangle getCenterBoundsForComponent(Component c) {
        PointerInfo pInfo = MouseInfo.getPointerInfo();
        Point pointerLocation = pInfo.getLocation();
        GraphicsConfiguration[] cfgArr = pInfo.getDevice().getConfigurations();
        Rectangle bounds = null;
        for (int i = 0; i < cfgArr.length; ++i) {
            bounds = cfgArr[i].getBounds();
            if (pointerLocation.x <= bounds.x) break;
        }
        int x = bounds.x + (bounds.width - c.getWidth()) / 2;
        int y = bounds.y + (bounds.height - c.getHeight()) / 2;
        return new Rectangle(x, y, c.getWidth(), c.getHeight());
    }

    public static void showDialog(JDialog dialog) {
        StaticSwingTools.showDialog(dialog.getParent(), dialog, true);
    }

    public static void showDialog(JDialog dialog, boolean isRelativeToParentFrame) {
        StaticSwingTools.showDialog(dialog.getParent(), dialog, isRelativeToParentFrame);
    }

    public static void tryPackingMyParentDialog(Component component) {
        Component parent;
        for (parent = component; !(parent instanceof JDialog) && parent != null; parent = parent.getParent()) {
        }
        if (parent instanceof JDialog) {
            ((JDialog)parent).pack();
        }
    }

    public static void enableSliderToolTips(final JSlider slider, final MessageFormat format, final double factor) {
        slider.addChangeListener(new ChangeListener(){
            private boolean adjusting = false;
            private String oldTooltip;

            @Override
            public void stateChanged(ChangeEvent e) {
                if (slider.getModel().getValueIsAdjusting()) {
                    if (!this.adjusting) {
                        this.oldTooltip = slider.getToolTipText();
                        this.adjusting = true;
                    }
                    double value = (double)slider.getValue() * (Double.isNaN(factor) ? 1.0 : factor);
                    slider.setToolTipText(format != null ? format.format(new Object[]{value}) : Double.toString(value));
                    StaticSwingTools.hideToolTip(slider);
                    StaticSwingTools.postToolTip(slider);
                } else {
                    StaticSwingTools.hideToolTip(slider);
                    slider.setToolTipText(this.oldTooltip);
                    this.adjusting = false;
                    this.oldTooltip = null;
                }
            }
        });
    }

    public static void postToolTip(JComponent comp) {
        Action action = comp.getActionMap().get("postTip");
        if (action == null) {
            return;
        }
        ActionEvent actionEvent = new ActionEvent(comp, 1001, "postTip", EventQueue.getMostRecentEventTime(), 0);
        action.actionPerformed(actionEvent);
    }

    public static void hideToolTip(JComponent comp) {
        Action action = comp.getActionMap().get("hideTip");
        if (action == null) {
            return;
        }
        ActionEvent actionEvent = new ActionEvent(comp, 1001, "hideTip", EventQueue.getMostRecentEventTime(), 0);
        action.actionPerformed(actionEvent);
    }

    public static void decorateWithFixedAutoCompleteDecorator(JComboBox cbo) {
        AutoCompleteDecorator.decorate((JComboBox)cbo);
        final JList<Object> pop = ((ComboPopup)((Object)cbo.getUI().getAccessibleChild(cbo, 0))).getList();
        final JTextField txt = (JTextField)cbo.getEditor().getEditorComponent();
        txt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent event) {
                if (event.getKeyCode() == 40 || event.getKeyCode() == 38) {
                    Object selectedValue = pop.getSelectedValue();
                    if (selectedValue != null) {
                        txt.setText(String.valueOf(selectedValue));
                    }
                    txt.selectAll();
                }
            }
        });
    }

    public static void tweakUI() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            UITweaks config = (UITweaks)mapper.readValue(UITweaks.class.getResourceAsStream("/de/cismet/tools/gui/uitweaks.json"), UITweaks.class);
            config.apply();
        }
        catch (Exception e) {
            log.warn((Object)"Problem during TweakingUI", (Throwable)e);
        }
    }

    public static File chooseFile(String currentDirectoryPath, boolean isSaveDialog, final String[] allowedFileExtension, final String fileExtensionDescription, Component parent) {
        int state;
        JFileChooser fc;
        try {
            fc = new ConfirmationJFileChooser(currentDirectoryPath);
        }
        catch (Exception bug) {
            fc = new JFileChooser(currentDirectoryPath, (FileSystemView)new RestrictedFileSystemView());
        }
        FileFilter fileFilter = allowedFileExtension != null && allowedFileExtension.length == 1 ? new ExtensionAwareFileFilter(){

            @Override
            public boolean accept(File f) {
                boolean fileAllowed = f.isDirectory();
                if (!fileAllowed) {
                    String extension;
                    String string = extension = f.getName().contains(".") ? f.getName().substring(f.getName().indexOf(".") + 1) : "";
                    if (extension.equals(allowedFileExtension[0])) {
                        fileAllowed = true;
                    }
                }
                return fileAllowed;
            }

            @Override
            public String getDescription() {
                String description = fileExtensionDescription;
                if (description == null) {
                    description = allowedFileExtension[0];
                }
                return description;
            }

            @Override
            public String getExtension() {
                return allowedFileExtension[0];
            }
        } : new FileFilter(){

            @Override
            public boolean accept(File f) {
                boolean fileAllowed = f.isDirectory();
                if (allowedFileExtension == null) {
                    fileAllowed = true;
                } else if (!fileAllowed) {
                    String extension = f.getName().contains(".") ? f.getName().substring(f.getName().indexOf(".") + 1) : "";
                    for (String allowedExt : allowedFileExtension) {
                        if (!extension.equals(allowedExt)) continue;
                        fileAllowed = true;
                        break;
                    }
                }
                return fileAllowed;
            }

            @Override
            public String getDescription() {
                String description = fileExtensionDescription;
                if (description == null && allowedFileExtension != null) {
                    for (String allowedExt : allowedFileExtension) {
                        description = description == null ? allowedExt : description + ", " + allowedExt;
                    }
                } else {
                    description = description + "";
                }
                return description;
            }
        };
        fc.setAcceptAllFileFilterUsed(false);
        fc.setFileFilter(fileFilter);
        int n = state = isSaveDialog ? fc.showSaveDialog(parent) : fc.showOpenDialog(parent);
        if (log.isDebugEnabled()) {
            log.debug((Object)("state:" + state));
        }
        if (state == 0) {
            File file = fc.getSelectedFile();
            if (!fileFilter.accept(file) && (file = new File(file.getAbsolutePath() + "." + allowedFileExtension[0])).exists() && (allowedFileExtension == null || allowedFileExtension.length != 1)) {
                String title;
                String message = NbBundle.getMessage(ConfirmationJFileChooser.class, (String)"ConfirmationJFileChooser.approveSelection.message");
                int result = JOptionPane.showConfirmDialog(parent, message, title = NbBundle.getMessage(ConfirmationJFileChooser.class, (String)"ConfirmationJFileChooser.approveSelection.title"), 1);
                if (result == 0) {
                    return file;
                }
                return null;
            }
            return file;
        }
        return null;
    }

    public static File chooseFileWithMultipleFilters(String currentDirectoryPath, boolean isSaveDialog, String[] allowedFileExtension, String[] fileExtensionDescription, Component parent) {
        int state;
        JFileChooser fc;
        try {
            fc = new ConfirmationJFileChooser(currentDirectoryPath);
        }
        catch (Exception bug) {
            fc = new JFileChooser(currentDirectoryPath, (FileSystemView)new RestrictedFileSystemView());
        }
        for (int i = 0; i < allowedFileExtension.length; ++i) {
            final String ext = allowedFileExtension[i];
            final String description = fileExtensionDescription != null && i < fileExtensionDescription.length ? fileExtensionDescription[i] : allowedFileExtension[i];
            ExtensionAwareFileFilter fileFilter = new ExtensionAwareFileFilter(){

                @Override
                public boolean accept(File f) {
                    boolean fileAllowed = f.isDirectory();
                    String extension = f.getName().contains(".") ? f.getName().substring(f.getName().indexOf(".") + 1) : "";
                    return fileAllowed || extension.equals(ext);
                }

                @Override
                public String getDescription() {
                    return description;
                }

                @Override
                public String getExtension() {
                    return ext;
                }
            };
            fc.addChoosableFileFilter(fileFilter);
            if (i != 0) continue;
            fc.setFileFilter(fileFilter);
        }
        fc.setAcceptAllFileFilterUsed(false);
        int n = state = isSaveDialog ? fc.showSaveDialog(parent) : fc.showOpenDialog(parent);
        if (log.isDebugEnabled()) {
            log.debug((Object)("state:" + state));
        }
        if (state == 0) {
            File file = fc.getSelectedFile();
            if (!fc.accept(file)) {
                ExtensionAwareFileFilter ff = (ExtensionAwareFileFilter)fc.getFileFilter();
                file = new File(file.getAbsolutePath() + "." + ff.getExtension());
            }
            return file;
        }
        return null;
    }
}

