/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.tools.gui;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.awt.Color;
import java.util.HashMap;
import javax.swing.UIManager;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.log4j.Logger;

@XmlRootElement
public class UITweaks {
    private static final Logger LOG = Logger.getLogger(UITweaks.class);
    private HashMap<String, String> colors;
    private HashMap<String, Boolean> booleans;

    public void apply() {
        if (this.colors != null) {
            for (String key : this.colors.keySet()) {
                try {
                    UIManager.put(key, Color.decode(this.colors.get(key)));
                }
                catch (Exception exception) {
                    LOG.warn((Object)("cannot put" + key + " to UIManager with " + this.colors.get(key)), (Throwable)exception);
                }
            }
        }
        if (this.booleans != null) {
            for (String key : this.booleans.keySet()) {
                try {
                    UIManager.put(key, this.booleans.get(key));
                }
                catch (Exception exception) {
                    LOG.warn((Object)("cannot put" + key + " to UIManager with " + this.booleans.get(key)), (Throwable)exception);
                }
            }
        }
    }

    public HashMap<String, String> getColors() {
        return this.colors;
    }

    public void setColors(HashMap<String, String> colors) {
        this.colors = colors;
    }

    public HashMap<String, Boolean> getBooleans() {
        return this.booleans;
    }

    public void setBooleans(HashMap<String, Boolean> booleans) {
        this.booleans = booleans;
    }

    public static void main(String[] args) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        HashMap<String, String> colors = new HashMap<String, String>();
        colors.put("Table.selectionBackground", "#c3d4e8");
        colors.put("Tree.selectionBackground", "#c3d4e8");
        colors.put("Table.selectionForeground", "#000000");
        colors.put("Tree.selectionForeground", "#000000");
        UITweaks uit = new UITweaks();
        uit.setColors(colors);
        System.out.println(mapper.writeValueAsString((Object)uit));
    }
}

