/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.tools.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import javax.swing.Icon;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class VerticalTextIcon
implements Icon,
SwingConstants {
    private Font font = UIManager.getFont("Label.font");
    private FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(this.font);
    private String text;
    private int width;
    private int height;
    private boolean clockwize;
    private Color color;

    public VerticalTextIcon(String text, boolean clockwize) {
        this(text, clockwize, Color.black);
    }

    public VerticalTextIcon(String text, boolean clockwize, Color color) {
        this.text = text;
        this.width = SwingUtilities.computeStringWidth(this.fm, text) + 2;
        this.height = this.fm.getHeight();
        this.clockwize = clockwize;
        this.color = color;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2 = (Graphics2D)g;
        Font oldFont = g.getFont();
        Color oldColor = g.getColor();
        AffineTransform oldTransform = g2.getTransform();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setFont(this.font);
        g.setColor(this.color);
        if (this.clockwize) {
            g2.translate(x + this.getIconWidth(), y);
            g2.rotate(1.5707963267948966);
        } else {
            g2.translate(x, y + this.getIconHeight());
            g2.rotate(-1.5707963267948966);
        }
        g.drawString(this.text, 0, this.fm.getLeading() + this.fm.getAscent());
        g.setFont(oldFont);
        g.setColor(oldColor);
        g2.setTransform(oldTransform);
    }

    @Override
    public int getIconWidth() {
        return this.height;
    }

    @Override
    public int getIconHeight() {
        return this.width;
    }
}

