/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.tools.gui.autocomplete;

import de.cismet.tools.gui.autocomplete.AbstractCompleterFilter;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import javax.swing.text.PlainDocument;

public class ComboCompleterFilter
extends AbstractCompleterFilter {
    private final JComboBox combo;
    private String nullRespresentation = "null";

    public ComboCompleterFilter(JComboBox combo) {
        this.combo = combo;
    }

    public String getNullRespresentation() {
        return this.nullRespresentation;
    }

    public void setNullRespresentation(String nullRespresentation) {
        this.nullRespresentation = nullRespresentation != null ? nullRespresentation : "null";
    }

    @Override
    public int getCompleterListSize() {
        return this.combo.getModel().getSize();
    }

    @Override
    public Object getCompleterObjectAt(int i) {
        return this.combo.getItemAt(i);
    }

    @Override
    public JTextField getTextField() {
        return (JTextField)this.combo.getEditor().getEditorComponent();
    }

    public static ComboCompleterFilter addCompletionMechanism(JComboBox combo) {
        combo.setEditable(true);
        if (!(combo.getEditor().getEditorComponent() instanceof JTextField)) {
            return null;
        }
        JTextField tf = (JTextField)combo.getEditor().getEditorComponent();
        PlainDocument pd = new PlainDocument();
        ComboCompleterFilter filter = new ComboCompleterFilter(combo);
        pd.setDocumentFilter(filter);
        tf.setDocument(pd);
        return filter;
    }

    @Override
    public void replace(DocumentFilter.FilterBypass filterBypass, int offset, int length, String string, AttributeSet attributeSet) throws BadLocationException {
        if (this.combo.isFocusOwner() || this.getTextField().isFocusOwner() || this.getTextField().getText().length() < 1) {
            super.replace(filterBypass, offset, length, string, attributeSet);
            if (this.firstSelectedIndex != -1) {
                JTextField tf = this.getTextField();
                int preTextLen = this.preText.length();
                String text = tf.getText();
                this.combo.setSelectedIndex(this.firstSelectedIndex);
                filterBypass.replace(0, tf.getDocument().getLength(), text, attributeSet);
                this.getTextField().select(preTextLen, tf.getDocument().getLength());
            }
        }
    }

    @Override
    public void remove(DocumentFilter.FilterBypass filterBypass, int offset, int length) throws BadLocationException {
        super.remove(filterBypass, offset, length);
        if (this.strict || this.firstSelectedIndex > -1) {
            this.combo.setSelectedIndex(this.firstSelectedIndex);
        }
    }

    @Override
    public void setStrict(boolean strict) {
        super.setStrict(strict);
        if (!strict) {
            this.combo.setSelectedIndex(-1);
        }
    }
}

