/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.tools.gui.autocomplete;

import de.cismet.tools.gui.autocomplete.CompleterFilter;
import de.cismet.tools.gui.autocomplete.CompleterFilterWithWindow;
import javax.swing.JTextField;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class CompleterTextField
extends JTextField {
    private CompleterFilter filter;

    public CompleterTextField(Object[] completeMatches) {
        this.initWindow(completeMatches);
    }

    public CompleterTextField(Object[] completeMatches, boolean useWindow) {
        if (useWindow) {
            this.initWindow(completeMatches);
        } else {
            this.initWindowless(completeMatches);
        }
    }

    private void initWindow(Object[] completeMatches) {
        PlainDocument pd = new PlainDocument();
        this.filter = new CompleterFilterWithWindow(completeMatches, this);
        pd.setDocumentFilter(this.filter);
        this.setDocument(pd);
    }

    private void initWindowless(Object[] completeMatches) {
        PlainDocument pd = new PlainDocument();
        this.filter = new CompleterFilter(completeMatches, this);
        pd.setDocumentFilter(this.filter);
        this.setDocument(pd);
    }

    @Override
    public void setDocument(Document doc) {
        super.setDocument(doc);
        if (doc instanceof AbstractDocument) {
            ((AbstractDocument)doc).setDocumentFilter(this.filter);
        }
    }

    public boolean isCaseSensitive() {
        return this.filter.isCaseSensitive();
    }

    public boolean isCorrectingCase() {
        return this.filter.isCorrectingCase();
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.filter.setCaseSensitive(caseSensitive);
    }

    public void setCorrectCase(boolean correctCase) {
        this.filter.setCorrectCase(correctCase);
    }

    public void setCompleterMatches(Object[] completeMatches) {
        this.filter.setCompleterMatches(completeMatches);
    }
}

