/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.tools.gui.autocomplete;

import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.AbstractListModel;

public class FilterListModel
extends AbstractListModel {
    private Object[] fullList;
    private ArrayList<Object> filteredList;
    private String filter;
    private boolean caseSensitive = false;

    public FilterListModel(Object[] unfilteredList) {
        this.fullList = unfilteredList;
        this.filteredList = new ArrayList<Object>(Arrays.asList(unfilteredList));
    }

    @Override
    public int getSize() {
        return this.filteredList.size();
    }

    @Override
    public Object getElementAt(int index) {
        return this.filteredList.get(index);
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filteredList.clear();
        for (Object obj : this.fullList) {
            if (obj.toString().length() < filter.length()) continue;
            if (this.caseSensitive) {
                if (!obj.toString().startsWith(filter)) continue;
                this.filteredList.add(obj);
                continue;
            }
            if (obj.toString().substring(0, filter.length()).compareToIgnoreCase(filter) != 0) continue;
            this.filteredList.add(obj);
        }
        this.fireContentsChanged(this, 0, this.filteredList.size());
    }

    public void clearFilter() {
        this.filter = null;
        this.filteredList = new ArrayList<Object>(Arrays.asList(this.fullList));
    }

    public boolean getCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
        this.clearFilter();
    }

    public void setCompleterMatches(Object[] objectsToMatch) {
        this.fullList = objectsToMatch;
        this.clearFilter();
    }
}

