/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.tools.gui.breadcrumb;

import de.cismet.tools.gui.breadcrumb.BreadCrumb;
import de.cismet.tools.gui.breadcrumb.BreadCrumbEvent;
import de.cismet.tools.gui.breadcrumb.BreadCrumbModel;
import de.cismet.tools.gui.breadcrumb.BreadCrumbModelListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class DefaultBreadCrumbModel
implements BreadCrumbModel {
    private final transient Set<BreadCrumbModelListener> listeners = new HashSet<BreadCrumbModelListener>();
    private final transient List<BreadCrumb> data = new ArrayList<BreadCrumb>();

    @Override
    public void appendCrumb(BreadCrumb bc) {
        this.appendCrumbSilently(bc);
        this.fireBreadCrumbAdded(new BreadCrumbEvent(this, bc));
    }

    private void appendCrumbSilently(final BreadCrumb bc) {
        this.data.add(bc);
        bc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BreadCrumbEvent bce = new BreadCrumbEvent(DefaultBreadCrumbModel.this, bc);
                DefaultBreadCrumbModel.this.fireBreadCrumbActionPerformed(bce);
            }
        });
    }

    @Override
    public List<BreadCrumb> getAllCrumbs() {
        return new ArrayList<BreadCrumb>(this.data);
    }

    @Override
    public BreadCrumb getCrumbAt(int position) {
        return this.data.get(position);
    }

    @Override
    public int getPositionOf(BreadCrumb bc) {
        return this.data.indexOf(bc);
    }

    @Override
    public int getSize() {
        return this.data.size();
    }

    @Override
    public BreadCrumb getLastCrumb() {
        if (this.data.isEmpty()) {
            return null;
        }
        return this.data.get(this.data.size() - 1);
    }

    @Override
    public BreadCrumb getFirstCrumb() {
        if (this.data.isEmpty()) {
            return null;
        }
        return this.data.get(0);
    }

    @Override
    public void clear() {
        this.data.clear();
        this.fireBreadCrumbModelChanged(new BreadCrumbEvent(this));
    }

    @Override
    public void removeTill(BreadCrumb bc) {
        int lastIndex = this.data.lastIndexOf(bc);
        if (lastIndex != -1) {
            for (int i = this.data.size() - 1; i > lastIndex; --i) {
                this.data.remove(i);
            }
        }
        this.fireBreadCrumbModelChanged(new BreadCrumbEvent(this));
    }

    @Override
    public void startWithNewCrumb(BreadCrumb bc) {
        this.data.clear();
        this.appendCrumbSilently(bc);
        this.fireBreadCrumbModelChanged(new BreadCrumbEvent(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBreadCrumbModelListener(BreadCrumbModelListener bcListener) {
        Set<BreadCrumbModelListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(bcListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeBreadCrumbModelListener(BreadCrumbModelListener bcListener) {
        Set<BreadCrumbModelListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(bcListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireBreadCrumbModelChanged(BreadCrumbEvent bce) {
        Iterator<BreadCrumbModelListener> it;
        Set<BreadCrumbModelListener> set = this.listeners;
        synchronized (set) {
            it = new HashSet<BreadCrumbModelListener>(this.listeners).iterator();
        }
        while (it.hasNext()) {
            it.next().breadCrumbModelChanged(bce);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireBreadCrumbAdded(BreadCrumbEvent bce) {
        Iterator<BreadCrumbModelListener> it;
        Set<BreadCrumbModelListener> set = this.listeners;
        synchronized (set) {
            it = new HashSet<BreadCrumbModelListener>(this.listeners).iterator();
        }
        while (it.hasNext()) {
            it.next().breadCrumbAdded(bce);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireBreadCrumbActionPerformed(BreadCrumbEvent bce) {
        Iterator<BreadCrumbModelListener> it;
        Set<BreadCrumbModelListener> set = this.listeners;
        synchronized (set) {
            it = new HashSet<BreadCrumbModelListener>(this.listeners).iterator();
        }
        while (it.hasNext()) {
            it.next().breadCrumbActionPerformed(bce);
        }
    }
}

