/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.tools.gui.downloadmanager;

import de.cismet.tools.BrowserLauncher;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.downloadmanager.Download;
import de.cismet.tools.gui.downloadmanager.DownloadListChangedEvent;
import de.cismet.tools.gui.downloadmanager.DownloadListChangedListener;
import de.cismet.tools.gui.downloadmanager.DownloadManager;
import de.cismet.tools.gui.downloadmanager.DownloadManagerPanel;
import de.cismet.tools.gui.downloadmanager.DownloadPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.error.ErrorInfo;
import org.openide.util.NbBundle;

public class DownloadManagerDialog
extends JDialog
implements DownloadListChangedListener {
    private static final Logger LOG = Logger.getLogger(DownloadManagerDialog.class);
    private static DownloadManagerDialog INSTANCE;
    private boolean askForJobNameEnabled = false;
    private boolean openAutomaticallyEnabled = true;
    private boolean closeAutomaticallyEnabled = true;
    private boolean closeMainDialogAfterClosingSubDialog = false;
    private String jobName = "";
    private boolean jobNameConfirmed = true;
    private final Collection<Download> downloadsToOpen = new LinkedList<Download>();
    private JButton btnCancel;
    private JButton btnClearList;
    private JButton btnClose;
    private JButton btnOK;
    private JDialog dlgExceptionDialog;
    private JDialog dlgJobname;
    private Box.Filler filler1;
    private JLabel lblDestinationDirectory;
    private JLabel lblDownloadsTotalKey;
    private JLabel lblDownloadsTotalValue;
    private JLabel lblJobname;
    private JLabel lblUserDirectory;
    private JLabel lblUserDirectoryLabel;
    private JPanel pnlControls;
    private DownloadManagerPanel pnlDownloadManagerPanel;
    private JPanel pnlExceptionDialogContainer;
    private JPanel pnlJobnameControls;
    private JScrollPane scpDownloadManagerPanel;
    private JSeparator sepControls;
    private JSeparator sepExceptionDialogControls;
    private JSeparator sepJobnameControls;
    private JTextField txtJobname;
    private BindingGroup bindingGroup;

    private DownloadManagerDialog() {
        super((Frame)null, false);
        this.initComponents();
        this.bindingGroup.unbind();
        if (this.txtJobname.getDocument() instanceof AbstractDocument) {
            ((AbstractDocument)this.txtJobname.getDocument()).setDocumentFilter(new UserDirectoryFilter());
        }
        this.bindingGroup.bind();
        DownloadManager.instance().addDownloadListChangedListener(this.pnlDownloadManagerPanel);
        LinkedList<Download> reversedDownloads = new LinkedList<Download>();
        for (Download download : DownloadManager.instance().getDownloads()) {
            reversedDownloads.add(0, download);
        }
        this.pnlDownloadManagerPanel.add(reversedDownloads);
        int countDownloadsErroneous = DownloadManager.instance().getCountDownloadsErroneous();
        int countDownloadsCompleted = DownloadManager.instance().getCountDownloadsCompleted();
        int countDownlaodCancelled = DownloadManager.instance().getCountDownloadsCancelled();
        int countDownloadsTotal = DownloadManager.instance().getCountDownloadsTotal();
        this.lblDownloadsTotalValue.setText(String.valueOf(countDownloadsTotal));
        this.btnClearList.setEnabled(countDownloadsCompleted + countDownloadsErroneous + countDownlaodCancelled > 0);
    }

    public static DownloadManagerDialog getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DownloadManagerDialog();
            INSTANCE.pack();
            DownloadManager.instance().addDownloadListChangedListener(INSTANCE);
        }
        return INSTANCE;
    }

    public static DownloadManagerDialog instance(Frame parent) {
        return DownloadManagerDialog.getInstance();
    }

    public static DownloadManagerDialog instance(Component parent) {
        return DownloadManagerDialog.getInstance();
    }

    public static void show(Component parent) {
        DownloadManagerDialog dialog = DownloadManagerDialog.getInstance();
        StaticSwingTools.showDialog(parent, dialog, true);
    }

    public static boolean showAskingForUserTitle(Frame parent) {
        return DownloadManagerDialog.getInstance().showAskingForUserTitleDialog(parent);
    }

    public boolean showAskingForUserTitleDialog(Component parent) {
        Frame parentFrame = parent instanceof Frame ? (Frame)parent : StaticSwingTools.getParentFrame(parent);
        boolean close = !this.isVisible();
        DownloadManagerDialog.show(parentFrame);
        boolean result = this.isJobNameConfirmed();
        if (this.isAskForJobNameEnabled()) {
            this.txtJobname.setText(this.getJobName());
            this.txtJobname.setCaretPosition(this.getJobName().length());
            if (this.dlgJobname.getOwner() != null && parentFrame != null && parentFrame.getIconImage() != null) {
                this.dlgJobname.getOwner().setIconImage(parentFrame.getIconImage());
            }
            this.dlgJobname.setPreferredSize(this.dlgJobname.getMinimumSize());
            this.dlgJobname.pack();
            StaticSwingTools.showDialog(this.dlgJobname);
            result = this.isJobNameConfirmed();
            if (!this.isJobNameConfirmed() && close) {
                this.closeWindow();
            }
        }
        return result;
    }

    public static boolean showAskingForUserTitle(Component parent) {
        return DownloadManagerDialog.getInstance().showAskingForUserTitleDialog(parent);
    }

    public static void showExceptionDialog(Download download) {
        DownloadManagerDialog.getInstance().showTheExceptionDialog(download);
    }

    public void showTheExceptionDialog(Download download) {
        JPanel exceptionPanel;
        if (download.getCaughtException() == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"There is no exception to visualize.");
            }
            return;
        }
        Frame parent = StaticSwingTools.getParentFrame(this);
        if (this.dlgExceptionDialog.getOwner() != null && parent != null && parent.getIconImage() != null) {
            this.dlgJobname.getOwner().setIconImage(parent.getIconImage());
        }
        if ((exceptionPanel = download.getExceptionPanel(download.getCaughtException())) != null) {
            this.pnlExceptionDialogContainer.removeAll();
            this.pnlExceptionDialogContainer.add((Component)exceptionPanel, "Center");
            this.dlgExceptionDialog.invalidate();
            this.dlgExceptionDialog.pack();
            StaticSwingTools.showDialog(this.dlgExceptionDialog);
        } else {
            Exception ex = download.getCaughtException();
            ErrorInfo ei = new ErrorInfo(NbBundle.getMessage(DownloadPanel.class, (String)"DownloadManagerDialog.showExceptionDialog(Download).error.title"), ex.getMessage(), null, null, (Throwable)ex, Level.ALL, null);
            JXErrorPane.showDialog((Component)StaticSwingTools.getParentFrameIfNotNull(this), (ErrorInfo)ei);
        }
    }

    public static void close() {
        DownloadManagerDialog.getInstance().closeWindow();
    }

    public void closeWindow() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DownloadManagerDialog.this.closeWindow();
                }
            });
        } else if (this.dlgJobname.isVisible() || this.dlgExceptionDialog.isVisible()) {
            this.closeMainDialogAfterClosingSubDialog = true;
        } else {
            this.setVisible(false);
        }
    }

    public static String getJobname() {
        return DownloadManagerDialog.getInstance().getJobName();
    }

    public static void setJobname(String jobname) {
        DownloadManagerDialog.getInstance().setJobName(jobname);
    }

    public static boolean isAskForJobname() {
        return DownloadManagerDialog.getInstance().isAskForJobNameEnabled();
    }

    public static void setAskForJobname(boolean askForJobname) {
        DownloadManagerDialog.getInstance().setAskForJobNameEnabled(askForJobname);
    }

    public static boolean isOpenAutomatically() {
        return DownloadManagerDialog.getInstance().isOpenAutomaticallyEnabled();
    }

    public static void setOpenAutomatically(boolean openAutomatically) {
        DownloadManagerDialog.getInstance().setOpenAutomaticallyEnabled(openAutomatically);
    }

    public static boolean isCloseAutomatically() {
        return DownloadManagerDialog.getInstance().isCloseAutomaticallyEnabled();
    }

    public static void setCloseAutomatically(boolean closeAutomatically) {
        DownloadManagerDialog.getInstance().setCloseAutomaticallyEnabled(closeAutomatically);
    }

    public static boolean isJobnameConfirmed() {
        return DownloadManagerDialog.getInstance().isJobNameConfirmed();
    }

    public static void setJobnameConfirmed(boolean isJobNameConfirmed) {
        DownloadManagerDialog.getInstance().setJobNameConfirmed(isJobNameConfirmed);
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.dlgJobname = new JDialog(this);
        this.lblJobname = new JLabel();
        this.txtJobname = new JTextField();
        this.pnlJobnameControls = new JPanel();
        this.btnOK = new JButton();
        this.btnCancel = new JButton();
        this.sepJobnameControls = new JSeparator();
        this.lblDestinationDirectory = new JLabel();
        this.lblUserDirectory = new JLabel();
        this.lblUserDirectoryLabel = new JLabel();
        this.dlgExceptionDialog = new JDialog(this);
        this.sepExceptionDialogControls = new JSeparator();
        this.pnlExceptionDialogContainer = new JPanel();
        this.btnClose = new JButton();
        this.scpDownloadManagerPanel = new JScrollPane();
        this.pnlDownloadManagerPanel = new DownloadManagerPanel();
        this.sepControls = new JSeparator();
        this.pnlControls = new JPanel();
        this.btnClearList = new JButton();
        this.lblDownloadsTotalKey = new JLabel();
        this.lblDownloadsTotalValue = new JLabel();
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.dlgJobname.setTitle(NbBundle.getMessage(DownloadManagerDialog.class, (String)"DownloadManagerDialog.dlgJobname.title"));
        this.dlgJobname.setMinimumSize(new Dimension(400, 180));
        this.dlgJobname.setModal(true);
        this.dlgJobname.getContentPane().setLayout(new GridBagLayout());
        this.lblJobname.setText(NbBundle.getMessage(DownloadManagerDialog.class, (String)"DownloadManagerDialog.lblJobname.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.dlgJobname.getContentPane().add((Component)this.lblJobname, gridBagConstraints);
        this.txtJobname.setText(NbBundle.getMessage(DownloadManagerDialog.class, (String)"DownloadManagerDialog.txtJobname.text"));
        this.txtJobname.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DownloadManagerDialog.this.txtJobnameActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.dlgJobname.getContentPane().add((Component)this.txtJobname, gridBagConstraints);
        this.pnlJobnameControls.setLayout(new FlowLayout(4));
        this.btnOK.setText(NbBundle.getMessage(DownloadManagerDialog.class, (String)"DownloadManagerDialog.btnOK.text"));
        this.btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DownloadManagerDialog.this.btnOKActionPerformed(evt);
            }
        });
        this.pnlJobnameControls.add(this.btnOK);
        this.btnCancel.setText(NbBundle.getMessage(DownloadManagerDialog.class, (String)"DownloadManagerDialog.btnCancel.text"));
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DownloadManagerDialog.this.btnCancelActionPerformed(evt);
            }
        });
        this.pnlJobnameControls.add(this.btnCancel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 20;
        gridBagConstraints.weightx = 1.0;
        this.dlgJobname.getContentPane().add((Component)this.pnlJobnameControls, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 20;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.dlgJobname.getContentPane().add((Component)this.sepJobnameControls, gridBagConstraints);
        this.lblDestinationDirectory.setText(DownloadManager.instance().getDestinationDirectory().getAbsolutePath() + File.separator);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        this.dlgJobname.getContentPane().add((Component)this.lblDestinationDirectory, gridBagConstraints);
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.txtJobname, (Property)ELProperty.create((String)"${text}"), (Object)this.lblUserDirectory, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"Nothing entered");
        binding.setSourceUnreadableValue((Object)"Unreadable");
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 5, 5);
        this.dlgJobname.getContentPane().add((Component)this.lblUserDirectory, gridBagConstraints);
        this.lblUserDirectoryLabel.setText(NbBundle.getMessage(DownloadManagerDialog.class, (String)"DownloadManagerDialog.lblUserDirectoryLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.dlgJobname.getContentPane().add((Component)this.lblUserDirectoryLabel, gridBagConstraints);
        this.dlgExceptionDialog.setTitle(NbBundle.getMessage(DownloadManagerDialog.class, (String)"DownloadManagerDialog.dlgExceptionDialog.title"));
        this.dlgExceptionDialog.setModal(true);
        this.dlgExceptionDialog.getContentPane().setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.1;
        this.dlgExceptionDialog.getContentPane().add((Component)this.sepExceptionDialogControls, gridBagConstraints);
        this.pnlExceptionDialogContainer.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.pnlExceptionDialogContainer.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        this.dlgExceptionDialog.getContentPane().add((Component)this.pnlExceptionDialogContainer, gridBagConstraints);
        this.btnClose.setText(NbBundle.getMessage(DownloadManagerDialog.class, (String)"DownloadManagerDialog.btnClose.text"));
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DownloadManagerDialog.this.btnCloseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 26;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        this.dlgExceptionDialog.getContentPane().add((Component)this.btnClose, gridBagConstraints);
        this.setTitle(NbBundle.getMessage(DownloadManagerDialog.class, (String)"DownloadManagerDialog.title"));
        this.setMinimumSize(new Dimension(423, 300));
        this.getContentPane().setLayout(new GridBagLayout());
        this.scpDownloadManagerPanel.setBorder(null);
        this.scpDownloadManagerPanel.setVerticalScrollBarPolicy(22);
        this.scpDownloadManagerPanel.setViewportView(this.pnlDownloadManagerPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.scpDownloadManagerPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.sepControls, gridBagConstraints);
        this.pnlControls.setLayout(new GridBagLayout());
        this.btnClearList.setMnemonic(NbBundle.getMessage(DownloadManagerDialog.class, (String)"DownloadManagerDialog.btnClearList.mnemonic").charAt(0));
        this.btnClearList.setText(NbBundle.getMessage(DownloadManagerDialog.class, (String)"DownloadManagerDialog.btnClearList.text"));
        this.btnClearList.setEnabled(false);
        this.btnClearList.setFocusPainted(false);
        this.btnClearList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DownloadManagerDialog.this.btnClearListActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlControls.add((Component)this.btnClearList, gridBagConstraints);
        this.lblDownloadsTotalKey.setText(NbBundle.getMessage(DownloadManagerDialog.class, (String)"DownloadManagerDialog.lblDownloadsTotalKey.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlControls.add((Component)this.lblDownloadsTotalKey, gridBagConstraints);
        this.lblDownloadsTotalValue.setHorizontalAlignment(11);
        this.lblDownloadsTotalValue.setText(NbBundle.getMessage(DownloadManagerDialog.class, (String)"DownloadManagerDialog.lblDownloadsTotalValue.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.ipadx = 20;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlControls.add((Component)this.lblDownloadsTotalValue, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.pnlControls.add((Component)this.filler1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        this.getContentPane().add((Component)this.pnlControls, gridBagConstraints);
        this.bindingGroup.bind();
        this.pack();
    }

    private void btnClearListActionPerformed(ActionEvent evt) {
        DownloadManager.instance().removeObsoleteDownloads();
    }

    private void btnOKActionPerformed(ActionEvent evt) {
        this.setJobName(this.txtJobname.getText());
        this.setJobNameConfirmed(true);
        this.dlgJobname.toFront();
        this.dlgJobname.setVisible(false);
        if (this.closeMainDialogAfterClosingSubDialog) {
            this.closeWindow();
        }
    }

    private void txtJobnameActionPerformed(ActionEvent evt) {
        this.setJobName(this.txtJobname.getText());
        this.setJobNameConfirmed(true);
        this.dlgJobname.setVisible(false);
        if (this.closeMainDialogAfterClosingSubDialog) {
            this.closeWindow();
        }
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.setJobNameConfirmed(false);
        this.dlgJobname.setVisible(false);
        if (this.closeMainDialogAfterClosingSubDialog) {
            this.closeWindow();
        }
    }

    private void btnCloseActionPerformed(ActionEvent evt) {
        this.dlgExceptionDialog.setVisible(false);
        if (this.closeMainDialogAfterClosingSubDialog) {
            this.closeWindow();
        }
    }

    public void destinationDirectoryChanged() {
        this.lblDestinationDirectory.setText(DownloadManager.instance().getDestinationDirectory().getAbsolutePath() + File.separator);
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public boolean isAskForJobNameEnabled() {
        return this.askForJobNameEnabled;
    }

    public void setAskForJobNameEnabled(boolean askForJobNameEnabled) {
        this.askForJobNameEnabled = askForJobNameEnabled;
    }

    public boolean isOpenAutomaticallyEnabled() {
        return this.openAutomaticallyEnabled;
    }

    public void setOpenAutomaticallyEnabled(boolean openAutomaticallyEnabled) {
        this.openAutomaticallyEnabled = openAutomaticallyEnabled;
    }

    public boolean isCloseAutomaticallyEnabled() {
        return this.closeAutomaticallyEnabled;
    }

    public void setCloseAutomaticallyEnabled(boolean closeAutomaticallyEnabled) {
        this.closeAutomaticallyEnabled = closeAutomaticallyEnabled;
    }

    public boolean isJobNameConfirmed() {
        return this.jobNameConfirmed;
    }

    public void setJobNameConfirmed(boolean jobNameConfirmed) {
        this.jobNameConfirmed = jobNameConfirmed;
    }

    @Override
    public void downloadListChanged(DownloadListChangedEvent event) {
        if (event == null) {
            return;
        }
        switch (event.getAction()) {
            case ADDED: {
                Collection<Download> downloads = event.getDownloads();
                if (this.openAutomaticallyEnabled) {
                    this.downloadsToOpen.addAll(downloads);
                }
            }
            case CHANGED_COUNTERS: {
                int countDownloadsErraneous = DownloadManager.instance().getCountDownloadsErroneous();
                int countDownloadsCompleted = DownloadManager.instance().getCountDownloadsCompleted();
                int countDownloadsCancelled = DownloadManager.instance().getCountDownloadsCancelled();
                int countDownloadsTotal = DownloadManager.instance().getCountDownloadsTotal();
                this.lblDownloadsTotalValue.setText(String.valueOf(countDownloadsTotal));
                this.btnClearList.setEnabled(countDownloadsCompleted + countDownloadsErraneous + countDownloadsCancelled > 0);
                if (this.openAutomaticallyEnabled) {
                    Iterator<Download> downloadToOpenIter = this.downloadsToOpen.iterator();
                    while (downloadToOpenIter.hasNext()) {
                        Download downloadToOpen = downloadToOpenIter.next();
                        if (downloadToOpen == null || downloadToOpen.getFileToSaveTo() == null || downloadToOpen.getStatus() != Download.State.COMPLETED) continue;
                        try {
                            BrowserLauncher.openURLorFile((String)downloadToOpen.getFileToSaveTo().getAbsolutePath());
                            downloadToOpenIter.remove();
                        }
                        catch (RuntimeException e) {
                            downloadToOpenIter.remove();
                            LOG.warn((Object)"Cannot open download");
                        }
                    }
                }
                if (!this.closeAutomaticallyEnabled || countDownloadsTotal <= 0 || countDownloadsTotal != countDownloadsCompleted) break;
                this.closeWindow();
            }
        }
    }

    private class UserDirectoryFilter
    extends DocumentFilter {
        private static final String FILTER = "[^\u0000\\\\/:*?\"<>|]*";

        private UserDirectoryFilter() {
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
            if (string != null && string.length() > 0 && !string.matches(FILTER)) {
                return;
            }
            super.insertString(fb, offset, string, attr);
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            if (text != null && text.length() > 0 && !text.matches(FILTER)) {
                return;
            }
            super.replace(fb, offset, length, text, attrs);
        }
    }
}

