/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.tools.gui.downloadmanager;

import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.downloadmanager.Download;
import de.cismet.tools.gui.downloadmanager.DownloadDesktopNotification;
import de.cismet.tools.gui.downloadmanager.DownloadListChangedEvent;
import de.cismet.tools.gui.downloadmanager.DownloadListChangedListener;
import de.cismet.tools.gui.downloadmanager.DownloadManager;
import de.cismet.tools.gui.downloadmanager.DownloadManagerDialog;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class DownloadManagerStatusPanel
extends JPanel
implements DownloadListChangedListener {
    private static final Logger log = Logger.getLogger(DownloadManagerStatusPanel.class);
    int completedDownlaods = 0;
    int erroneousDownloads = 0;
    Timer animationTimer;
    private JLabel jLabel1;
    private JLabel lblRunning;
    private JLabel lblRunningCounter;
    private JLabel lblTotal;
    private JLabel lblTotalCounter;

    public DownloadManagerStatusPanel() {
        this.initComponents();
        DownloadManager.instance().addDownloadListChangedListener(this);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (me.getClickCount() == 2) {
                    DownloadManagerDialog downloadManager = DownloadManagerDialog.getInstance();
                    downloadManager.pack();
                    StaticSwingTools.showDialog(downloadManager);
                }
            }
        });
        this.updateLabels();
    }

    private void initComponents() {
        this.lblRunning = new JLabel();
        this.lblRunningCounter = new JLabel();
        this.lblTotal = new JLabel();
        this.lblTotalCounter = new JLabel();
        this.jLabel1 = new JLabel();
        this.setLayout(new GridBagLayout());
        this.lblRunning.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/tools/gui/downloadmanager/res/downloadmanager.png")));
        this.lblRunning.setText(NbBundle.getMessage(DownloadManagerStatusPanel.class, (String)"DownloadManagerStatusPanel.lblRunning.text"));
        this.lblRunning.setVerticalAlignment(3);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.add((Component)this.lblRunning, gridBagConstraints);
        this.lblRunningCounter.setText(NbBundle.getMessage(DownloadManagerStatusPanel.class, (String)"DownloadManagerStatusPanel.lblRunningCounter.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.add((Component)this.lblRunningCounter, gridBagConstraints);
        this.lblTotal.setText(NbBundle.getMessage(DownloadManagerStatusPanel.class, (String)"DownloadManagerStatusPanel.lblTotal.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.lblTotal, gridBagConstraints);
        this.lblTotalCounter.setText(NbBundle.getMessage(DownloadManagerStatusPanel.class, (String)"DownloadManagerStatusPanel.lblTotalCounter.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 10);
        this.add((Component)this.lblTotalCounter, gridBagConstraints);
        this.jLabel1.setText(NbBundle.getMessage(DownloadManagerStatusPanel.class, (String)"DownloadManagerStatusPanel.jLabel1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.jLabel1, gridBagConstraints);
    }

    @Override
    public void downloadListChanged(DownloadListChangedEvent event) {
        if (event.getAction() == DownloadListChangedEvent.Action.CHANGED_COUNTERS) {
            Collection<Download> downloads = event.getDownloads();
            if (downloads.size() > 1) {
                log.warn((Object)"It should not happend that a DownlaodListChangedEvent.Changed_Counters concerns more than one Download.");
            }
            Download[] downloadArr = downloads.toArray(new Download[downloads.size()]);
            int tmpComplDownloads = DownloadManager.instance().getCountDownloadsCompleted();
            int tmpErrDownloads = DownloadManager.instance().getCountDownloadsErroneous();
            if (!DownloadManagerDialog.getInstance().isShowing()) {
                if (this.completedDownlaods < tmpComplDownloads) {
                    this.showNotification(downloadArr[0].getTitle(), false);
                } else if (this.erroneousDownloads < tmpErrDownloads) {
                    this.showNotification(downloadArr[0].getTitle(), true);
                }
            }
            this.completedDownlaods = tmpComplDownloads;
            this.erroneousDownloads = tmpErrDownloads;
        }
        this.updateLabels();
    }

    private void updateLabels() {
        int done = DownloadManager.instance().getCountDownloadsCompleted() + DownloadManager.instance().getCountDownloadsErroneous() + DownloadManager.instance().getCountDownloadsCancelled();
        this.lblTotalCounter.setText("" + DownloadManager.instance().getCountDownloadsTotal());
        this.lblRunningCounter.setText("" + done);
    }

    private void showNotification(final String downloadName, final boolean isErroneous) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DownloadManagerStatusPanel.this.showNotification(downloadName, isErroneous);
                }
            });
        } else {
            final DownloadDesktopNotification notification = new DownloadDesktopNotification(StaticSwingTools.getParentFrame(this), downloadName, isErroneous);
            notification.floatInFromLowerFrameBound();
            Timer t = new Timer(DownloadManager.instance().getNotificationDisplayTime() * 1000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                notification.dispose();
                            }
                            catch (Exception ex) {
                                log.warn((Object)ex, (Throwable)ex);
                            }
                        }
                    });
                }
            });
            t.start();
        }
    }
}

