/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.tools.gui.downloadmanager;

import de.cismet.commons.security.WebDavClient;
import de.cismet.tools.gui.downloadmanager.AbstractCancellableDownload;
import de.cismet.tools.gui.downloadmanager.Download;
import java.io.FileOutputStream;
import java.io.InputStream;

@Deprecated
public class WebDavDownload
extends AbstractCancellableDownload {
    private static final int MAX_BUFFER_SIZE = 1024;
    private WebDavClient client;
    private String path;
    private String filename;
    private String extension;

    public WebDavDownload(WebDavClient client, String path, String directory, String title, String filename, String extension) {
        this.client = client;
        this.path = path;
        this.directory = directory;
        this.title = title;
        this.filename = filename;
        this.extension = extension;
        this.status = Download.State.WAITING;
        this.determineDestinationFile(filename, extension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.status != Download.State.WAITING) {
            return;
        }
        this.status = Download.State.RUNNING;
        FileOutputStream out = null;
        InputStream resp = null;
        this.stateChanged();
        try {
            resp = this.client.getInputStream(this.path);
            out = new FileOutputStream(this.fileToSaveTo);
            boolean downloading = true;
            while (downloading) {
                if (Thread.interrupted()) {
                    log.info((Object)"Download was interuppted");
                    out.close();
                    resp.close();
                    this.deleteFile();
                    return;
                }
                byte[] buffer = new byte[1024];
                int read = resp.read(buffer);
                if (read == -1) {
                    downloading = false;
                    continue;
                }
                out.write(buffer, 0, read);
            }
        }
        catch (Exception ex) {
            this.error(ex);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {
                    log.warn((Object)"Exception occured while closing file.", (Throwable)e);
                }
            }
            if (resp != null) {
                try {
                    resp.close();
                }
                catch (Exception e) {
                    log.warn((Object)"Exception occured while closing response stream.", (Throwable)e);
                }
            }
        }
        if (this.status == Download.State.RUNNING) {
            this.status = Download.State.COMPLETED;
            this.stateChanged();
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof WebDavDownload)) {
            return false;
        }
        WebDavDownload other = (WebDavDownload)obj;
        boolean result = true;
        if (!(this.path == other.path || this.path != null && this.path.equals(other.path))) {
            result &= false;
        }
        if (this.fileToSaveTo == null ? other.fileToSaveTo != null : !this.fileToSaveTo.equals(other.fileToSaveTo)) {
            result &= false;
        }
        return result;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 43 * hash + (this.path != null ? this.path.hashCode() : 0);
        hash = 43 * hash + (this.fileToSaveTo != null ? this.fileToSaveTo.hashCode() : 0);
        return hash;
    }

    private void deleteFile() {
        if (this.fileToSaveTo.exists() && this.fileToSaveTo.isFile()) {
            this.fileToSaveTo.delete();
        }
    }
}

