/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.tools.gui.historybutton;

import de.cismet.tools.gui.JPopupMenuButton;
import de.cismet.tools.gui.historybutton.HistoryModel;
import de.cismet.tools.gui.historybutton.HistoryModelListener;
import de.cismet.tools.gui.historybutton.JHistoryMenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;

public class JHistoryButton
extends JPopupMenuButton
implements ActionListener,
HistoryModelListener {
    public static final int DIRECTION_FORWARD = 1;
    public static final int DIRECTION_BACKWARD = 2;
    public static final int ICON_SIZE_16 = 4;
    public static final int ICON_SIZE_22 = 8;
    public static final int ICON_SIZE_32 = 16;
    public static final int ICON_SIZE_64 = 32;
    public static final int ICON_SIZE_128 = 64;
    private int maxHistoryMenuLength = 10;
    private JPopupMenu popupMenu = new JPopupMenu();
    private int direction = 1;
    private boolean localEnabled = true;
    private HistoryModel historyModel = null;

    public JHistoryButton() {
        this(true);
    }

    public JHistoryButton(boolean showPopupMenu) {
        super(showPopupMenu);
        super.setEnabled(false);
        this.setPopupMenu(this.popupMenu);
        this.addActionListener(this);
    }

    public static JHistoryButton getDefaultJHistoryButton(int direction, int iconSize, HistoryModel model) {
        JHistoryButton ret = new JHistoryButton();
        ret.setDirection(direction);
        ret.setHistoryModel(model);
        String ressourcePath = "/de/cismet/tools/gui/historybutton/res/";
        String forward = "forward";
        String back = "back";
        String filetype = ".png";
        String name = direction == 1 ? "forward" : "back";
        switch (iconSize) {
            case 4: {
                ret.setIcon(new ImageIcon(ret.getClass().getResource("/de/cismet/tools/gui/historybutton/res/" + name + "16" + ".png")));
                break;
            }
            case 8: {
                ret.setIcon(new ImageIcon(ret.getClass().getResource("/de/cismet/tools/gui/historybutton/res/" + name + "22" + ".png")));
                break;
            }
            case 16: {
                ret.setIcon(new ImageIcon(ret.getClass().getResource("/de/cismet/tools/gui/historybutton/res/" + name + "32" + ".png")));
                break;
            }
            case 32: {
                ret.setIcon(new ImageIcon(ret.getClass().getResource("/de/cismet/tools/gui/historybutton/res/" + name + "64" + ".png")));
                break;
            }
            case 64: {
                ret.setIcon(new ImageIcon(ret.getClass().getResource("/de/cismet/tools/gui/historybutton/res/" + name + "128" + ".png")));
            }
        }
        return ret;
    }

    public HistoryModel getHistoryModel() {
        return this.historyModel;
    }

    public void setHistoryModel(HistoryModel historyModel) {
        this.historyModel = historyModel;
        historyModel.addHistoryModelListener(this);
        this.setEnabled(this.localEnabled);
        if (this.localEnabled && this.direction == 1) {
            this.forwardStatusChanged();
        } else {
            this.backStatusChanged();
        }
    }

    @Override
    public void historyChanged() {
    }

    @Override
    public void forwardStatusChanged() {
        if (this.localEnabled && this.direction == 1) {
            if (this.getHistoryModel().isForwardPossible()) {
                this.setEnabled(true);
                Vector poss = this.getHistoryModel().getForwardPossibilities();
                this.refreshPopup(poss);
            } else {
                super.setEnabled(false);
            }
        }
    }

    @Override
    public void backStatusChanged() {
        if (this.localEnabled && this.direction == 2) {
            if (this.getHistoryModel().isBackPossible()) {
                this.setEnabled(true);
                Vector poss = this.getHistoryModel().getBackPossibilities();
                this.refreshPopup(poss);
            } else {
                super.setEnabled(false);
                this.refreshPopup(null);
            }
        }
    }

    private void refreshPopup(Vector possibilities) {
        if (this.showPopupMenu) {
            if (possibilities == null) {
                possibilities = new Vector();
            }
            this.popupMenu.removeAll();
            int tooMuch = possibilities.size() - this.maxHistoryMenuLength;
            for (int i = possibilities.size() - 1; i >= Math.max(tooMuch, 0); --i) {
                Object o = possibilities.get(i);
                JHistoryMenuItem item = new JHistoryMenuItem(o, possibilities.size() - i);
                this.popupMenu.add(item);
                item.addActionListener(this);
            }
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.localEnabled = enabled;
        if (this.getHistoryModel() != null) {
            super.setEnabled(this.localEnabled);
        } else {
            super.setEnabled(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e != null && e.getSource() instanceof JHistoryMenuItem) {
            JHistoryMenuItem source = (JHistoryMenuItem)e.getSource();
            for (int i = 0; i < source.getPosition() - 1; ++i) {
                if (this.direction == 2) {
                    this.getHistoryModel().back(false);
                    continue;
                }
                if (this.direction != 1) continue;
                this.getHistoryModel().forward(false);
            }
            this.fireActionPerformed(new ActionEvent(this, 0, "JHistoryButtonMenuActionPerformed"));
        } else if (e != null && e.getSource() instanceof JHistoryButton) {
            Object o = null;
            if (this.direction == 2) {
                o = this.getHistoryModel().back(true);
            } else if (this.direction == 1) {
                Object object = this.getHistoryModel().forward(true);
            }
        }
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        this.direction = direction;
    }

    public JLabel getJHistoryLabel() {
        return new JHistoryLabel();
    }

    @Override
    public void historyActionPerformed() {
    }

    private class JHistoryLabel
    extends JLabel
    implements HistoryModelListener {
        String text;

        public JHistoryLabel() {
            JHistoryButton.this.getHistoryModel().addHistoryModelListener(this);
        }

        @Override
        public void historyChanged() {
            this.text = JHistoryButton.this.getHistoryModel().getCurrentElement().toString();
            this.setText(this.text);
        }

        @Override
        public void forwardStatusChanged() {
        }

        @Override
        public void backStatusChanged() {
        }

        @Override
        public String getText() {
            if (this.text != null && this.text.length() > 0) {
                return this.text;
            }
            this.historyChanged();
            return this.text;
        }

        @Override
        public void historyActionPerformed() {
        }
    }
}

