/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.tools.gui.imagetooltip;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import javax.swing.plaf.metal.MetalToolTipUI;

public class ImageToolTip
extends JToolTip {
    public ImageToolTip(Image image) {
        this.setUI(new ImageToolTipUI(image));
    }

    public class ImageToolTipUI
    extends MetalToolTipUI {
        private Image m_image;

        public ImageToolTipUI(Image image) {
            this.m_image = image;
        }

        @Override
        public void paint(Graphics g, JComponent c) {
            FontMetrics metrics = c.getFontMetrics(g.getFont());
            g.setColor(c.getForeground());
            g.drawString(((JToolTip)c).getTipText(), 3, 15);
            g.drawImage(this.m_image, 3, metrics.getHeight() + 3, c);
        }

        @Override
        public Dimension getPreferredSize(JComponent c) {
            FontMetrics metrics = c.getFontMetrics(c.getFont());
            String tipText = ((JToolTip)c).getTipText();
            if (tipText == null) {
                tipText = "";
            }
            int width = SwingUtilities.computeStringWidth(metrics, tipText);
            int height = metrics.getHeight() + this.m_image.getHeight(c) + 6;
            if (width < this.m_image.getWidth(c)) {
                width = this.m_image.getWidth(c);
            }
            return new Dimension(width, height);
        }
    }
}

