/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.tools.gui.jbands;

import de.cismet.tools.gui.jbands.interfaces.Band;
import de.cismet.tools.gui.jbands.interfaces.BandMember;
import java.util.ArrayList;

public class PlainBand
implements Band {
    protected ArrayList<BandMember> members = new ArrayList();
    private Double min = null;
    private Double max = null;
    private boolean enabled = true;

    @Override
    public BandMember getMember(int i) {
        assert (i > 0);
        assert (i < this.members.size());
        return this.members.get(i);
    }

    @Override
    public int getNumberOfMembers() {
        return this.members.size();
    }

    public void addMember(BandMember m) {
        assert (m != null);
        this.members.add(m);
        this.min = null;
        this.max = null;
    }

    public void removeAllMember() {
        this.members.clear();
        this.min = null;
        this.max = null;
    }

    @Override
    public double getMax() {
        if (this.max == null) {
            this.max = 0.0;
            for (BandMember bm : this.members) {
                this.max = this.max < bm.getMax() ? bm.getMax() : this.max.doubleValue();
            }
        }
        return this.max;
    }

    @Override
    public double getMin() {
        if (this.min == null) {
            this.min = Double.MAX_VALUE;
            for (BandMember bm : this.members) {
                this.min = this.min > bm.getMin() ? bm.getMin() : this.min.doubleValue();
            }
        }
        return this.min;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

