/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.tools.gui.jbands;

import de.cismet.tools.gui.jbands.BandMemberEvent;
import de.cismet.tools.gui.jbands.JBandCursorManager;
import de.cismet.tools.gui.jbands.SimpleModifiableBand;
import de.cismet.tools.gui.jbands.interfaces.BandMember;
import de.cismet.tools.gui.jbands.interfaces.BandMemberListener;
import de.cismet.tools.gui.jbands.interfaces.BandMemberSelectable;
import de.cismet.tools.gui.jbands.interfaces.ModifiableBandMember;
import de.cismet.tools.gui.jbands.interfaces.Section;
import de.cismet.tools.gui.jbands.interfaces.StationaryBandMemberMouseListeningComponent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.painter.CompoundPainter;
import org.jdesktop.swingx.painter.MattePainter;
import org.jdesktop.swingx.painter.Painter;
import org.jdesktop.swingx.painter.RectanglePainter;

public class SimpleModifiableBandMember
extends JXPanel
implements ModifiableBandMember,
Section,
StationaryBandMemberMouseListeningComponent,
BandMemberSelectable,
ActionListener,
PopupMenuListener {
    protected static final Logger LOG = Logger.getLogger(SimpleModifiableBandMember.class);
    protected Painter unselectedBackgroundPainter = null;
    protected Painter selectedBackgroundPainter = null;
    protected boolean isSelected = false;
    protected JPopupMenu popup = new JPopupMenu();
    protected int mouseClickedXPosition = 0;
    protected String lineFieldName = "linie";
    double von = 0.0;
    double bis = 0.0;
    private boolean dragStart = false;
    private int dragSide = 0;
    private JMenuItem deleteItem = new JMenuItem("l\u00f6schen");
    private SimpleModifiableBand parent;
    private List<BandMemberListener> listenerList = new ArrayList<BandMemberListener>();
    private boolean readOnly;
    private JLabel labText;

    public SimpleModifiableBandMember(SimpleModifiableBand parent) {
        this(parent, false, 0.0, 0.0);
    }

    public SimpleModifiableBandMember(SimpleModifiableBand parent, boolean readOnly, double from, double to) {
        this.readOnly = readOnly;
        this.initComponents();
        this.setAlpha(0.8f);
        this.parent = parent;
        this.von = from;
        this.bis = to;
        this.popup.addPopupMenuListener(this);
        this.initMember();
    }

    private void initMember() {
        this.determineBackgroundColour();
        this.configurePopupMenu();
    }

    @Override
    public JComponent getBandMemberComponent() {
        return this;
    }

    @Override
    public double getMax() {
        return this.von < this.bis ? this.bis : this.von;
    }

    @Override
    public double getMin() {
        return this.von < this.bis ? this.von : this.bis;
    }

    @Override
    public double getFrom() {
        return this.von;
    }

    @Override
    public double getTo() {
        return this.bis;
    }

    public void setFrom(Double from) {
        this.von = from;
    }

    public void setTo(Double to) {
        this.bis = to;
    }

    public void setText(String text) {
        this.labText.setText(text);
    }

    protected void setDefaultBackground() {
        this.unselectedBackgroundPainter = new MattePainter((Paint)new Color(229, 0, 0));
        this.selectedBackgroundPainter = new CompoundPainter(new Painter[]{this.unselectedBackgroundPainter, new RectanglePainter(3, 3, 3, 3, 3, 3, true, (Paint)new Color(100, 100, 100, 100), 2.0f, (Paint)new Color(50, 50, 50, 100))});
        if (this.isSelected) {
            this.setBackgroundPainter(this.selectedBackgroundPainter);
        } else {
            this.setBackgroundPainter(this.unselectedBackgroundPainter);
        }
    }

    protected void configurePopupMenu() {
        this.deleteItem.addActionListener(this);
        this.popup.add(this.deleteItem);
    }

    protected void determineBackgroundColour() {
        this.setDefaultBackground();
    }

    private void initComponents() {
        this.labText = new JLabel();
        this.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.setLayout(new GridBagLayout());
        this.labText.setHorizontalAlignment(0);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add(this.labText, gridBagConstraints);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (JBandCursorManager.getInstance().isLocked()) {
            JBandCursorManager.getInstance().setCursor((JComponent)((Object)this));
        }
        this.setAlpha(1.0f);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.setAlpha(0.8f);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger() && this.isSelected) {
            this.showPopupMenu(e.getX(), e.getY());
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.dragStart) {
            this.dragStart = false;
            JBandCursorManager.getInstance().setLocked(false);
        }
        if (e.isPopupTrigger() && this.isSelected) {
            this.showPopupMenu(e.getX(), e.getY());
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (JBandCursorManager.getInstance().isLocked()) {
            JBandCursorManager.getInstance().setCursor((JComponent)((Object)this));
        }
    }

    @Override
    public void mouseDragged(MouseEvent e, double station) {
        if (JBandCursorManager.getInstance().isLocked()) {
            JBandCursorManager.getInstance().setCursor((JComponent)((Object)this));
        }
        if (!this.dragStart) {
            if (JBandCursorManager.getInstance().getCursor().equals(Cursor.getPredefinedCursor(10))) {
                this.dragSide = 1;
                this.dragStart = true;
                JBandCursorManager.getInstance().setCursor(Cursor.getPredefinedCursor(10));
                JBandCursorManager.getInstance().setLocked(true);
                JBandCursorManager.getInstance().setCursor((JComponent)((Object)this));
            } else if (JBandCursorManager.getInstance().getCursor().equals(Cursor.getPredefinedCursor(11))) {
                this.dragSide = 2;
                this.dragStart = true;
                JBandCursorManager.getInstance().setCursor(Cursor.getPredefinedCursor(11));
                JBandCursorManager.getInstance().setLocked(true);
                JBandCursorManager.getInstance().setCursor((JComponent)((Object)this));
            }
        } else {
            if (this.dragSide == 1) {
                this.von = Math.floor(station);
            } else {
                this.bis = Math.floor(station);
            }
            this.fireBandMemberChanged(false);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (!JBandCursorManager.getInstance().isLocked()) {
            if (this.isSelected && !this.isReadOnly()) {
                if (e.getX() < 5) {
                    JBandCursorManager.getInstance().setCursor(Cursor.getPredefinedCursor(10));
                    JBandCursorManager.getInstance().setCursor((JComponent)((Object)this));
                } else if (e.getX() > this.getWidth() - 5) {
                    JBandCursorManager.getInstance().setCursor(Cursor.getPredefinedCursor(11));
                    JBandCursorManager.getInstance().setCursor((JComponent)((Object)this));
                } else {
                    JBandCursorManager.getInstance().setCursor(Cursor.getPredefinedCursor(12));
                    JBandCursorManager.getInstance().setCursor((JComponent)((Object)this));
                }
            } else {
                JBandCursorManager.getInstance().setCursor(Cursor.getPredefinedCursor(12));
                JBandCursorManager.getInstance().setCursor((JComponent)((Object)this));
            }
        } else {
            JBandCursorManager.getInstance().setCursor((JComponent)((Object)this));
        }
    }

    @Override
    public boolean isSelectable() {
        return true;
    }

    @Override
    public boolean isSelected() {
        return this.isSelected;
    }

    @Override
    public void setSelected(boolean selection) {
        this.isSelected = selection;
        if (!this.isSelected) {
            this.setBackgroundPainter(this.unselectedBackgroundPainter);
        } else {
            this.setBackgroundPainter(this.selectedBackgroundPainter);
        }
    }

    @Override
    public BandMember getBandMember() {
        return this;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.deleteItem) {
            this.deleteMember();
        }
    }

    private void deleteMember() {
        this.parent.deleteMember(this);
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    @Override
    public void addBandMemberListener(BandMemberListener listener) {
        this.listenerList.add(listener);
    }

    @Override
    public void removeBandMemberListener(BandMemberListener listener) {
        this.listenerList.remove(listener);
    }

    public void fireBandMemberChanged(boolean modelChanged) {
        for (BandMemberListener l : this.listenerList) {
            l.bandMemberChanged(new BandMemberEvent(modelChanged));
        }
    }

    public void fireBandMemberChanged(BandMemberEvent e) {
        for (BandMemberListener l : this.listenerList) {
            l.bandMemberChanged(e);
        }
    }

    private void showPopupMenu(int x, int y) {
        this.mouseClickedXPosition = x;
        this.popup.show((Component)((Object)this), x, y);
    }

    public SimpleModifiableBand getParentBand() {
        return this.parent;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }
}

