/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.tools.gui.jtextcompoonent.undoredo;

import de.cismet.tools.gui.jtextcompoonent.undoredo.UndoableTableModel;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.TableModel;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.undo.UndoManager;

public class UndoRedoSupport {
    private UndoRedoSupport() {
    }

    public static void decorate(JTextComponent c) {
        Document doc = c.getDocument();
        UndoManager undo = new UndoManager();
        doc.addUndoableEditListener(undo);
        UndoRedoSupport.addCommandsToComponent(c, undo);
    }

    @Deprecated
    public static void decorate(JTable c) {
        TableModel mo = c.getModel();
        UndoableTableModel umo = new UndoableTableModel(mo);
        UndoManager undo = new UndoManager();
        umo.addUndoableEditListener(undo);
        c.setModel(umo);
        UndoRedoSupport.addCommandsToComponent(c, undo);
    }

    private static void addCommandsToComponent(JComponent c, UndoManager undo) {
        InputMap im = c.getInputMap(1);
        UndoAction ua = new UndoAction(undo);
        KeyStroke controlZ = KeyStroke.getKeyStroke(90, 2);
        im.put(controlZ, "control z");
        c.getActionMap().put("control z", ua);
        RedoAction ra = new RedoAction(undo);
        KeyStroke controlY = KeyStroke.getKeyStroke(89, 2);
        im.put(controlY, "control y");
        c.getActionMap().put("control y", ra);
    }

    public static final void discardAllEdits(JTextComponent c) {
        Action aa = c.getActionMap().get("control z");
        if (aa != null && aa instanceof ManagerAction) {
            ((ManagerAction)aa).discardAllEdits();
        }
        if ((aa = c.getActionMap().get("control y")) != null && aa instanceof ManagerAction) {
            ((ManagerAction)aa).discardAllEdits();
        }
    }

    private static class RedoAction
    extends ManagerAction {
        public RedoAction(UndoManager undo) {
            super(undo);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.getUndo().canRedo()) {
                this.getUndo().redo();
            }
        }
    }

    private static class UndoAction
    extends ManagerAction {
        public UndoAction(UndoManager undo) {
            super(undo);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.getUndo().canUndo()) {
                this.getUndo().undo();
            }
        }
    }

    private static abstract class ManagerAction
    extends AbstractAction {
        private final UndoManager undo;

        public ManagerAction(UndoManager undo) {
            if (undo == null) {
                throw new IllegalArgumentException("UndoManager can not be null for ManagerAction construction!");
            }
            this.undo = undo;
        }

        public void discardAllEdits() {
            this.getUndo().discardAllEdits();
        }

        public UndoManager getUndo() {
            return this.undo;
        }
    }
}

