/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.tools.gui.slideabletree;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import javax.swing.JTree;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class SlideableSubTree
extends JTree {
    private boolean specialSelection = false;
    private boolean hasDragGestureRecognizer = false;

    SlideableSubTree(TreeNode node, boolean useSpecialSelection) {
        super(node);
        this.specialSelection = useSpecialSelection;
        if (this.specialSelection) {
            this.setUI(new SpecialSelectionUI(this));
        }
    }

    @Override
    public void setExpandedState(TreePath path, boolean state) {
        super.setExpandedState(path, state);
    }

    @Override
    public boolean removeDescendantSelectedPaths(TreePath path, boolean includePath) {
        return super.removeDescendantSelectedPaths(path, includePath);
    }

    @Override
    public void removeDescendantToggledPaths(Enumeration<TreePath> toRemove) {
        super.removeDescendantToggledPaths(toRemove);
    }

    @Override
    public Enumeration<TreePath> getDescendantToggledPaths(TreePath parent) {
        return super.getDescendantToggledPaths(parent);
    }

    @Override
    public void clearToggledPaths() {
        super.clearToggledPaths();
    }

    @Override
    public void setUI(TreeUI ui) {
        if (this.specialSelection) {
            super.setUI(new SpecialSelectionUI(this));
        } else {
            super.setUI(ui);
        }
    }

    public boolean hasDragGestureRecognizer() {
        return this.hasDragGestureRecognizer;
    }

    public void setHasDragGestureRecognizer(boolean hasDragGestureRecognizer) {
        this.hasDragGestureRecognizer = hasDragGestureRecognizer;
    }

    @Override
    public void setEditable(boolean flag) {
        super.setEditable(false);
    }

    public boolean isPathValid(TreePath path) {
        if (path != null) {
            TreeModel model = this.getModel();
            if (path.getPathCount() == 0) {
                return model.getRoot().equals(path.getPathComponent(0));
            }
            for (int i = 1; i < path.getPathCount(); ++i) {
                int childIndex = model.getIndexOfChild(path.getPathComponent(i - 1), path.getPathComponent(i - 1));
                if (childIndex != -1) continue;
                return false;
            }
        }
        return true;
    }

    protected class SpecialSelectionUI
    extends BasicTreeUI {
        protected JTree tree;
        private boolean releasedAction;

        public SpecialSelectionUI(JTree t) {
            this.tree = t;
        }

        @Override
        protected MouseListener createMouseListener() {
            return new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    int selCount = SpecialSelectionUI.this.tree.getSelectionCount();
                    TreePath clickPath = SpecialSelectionUI.this.tree.getPathForLocation(e.getX(), e.getY());
                    if (selCount > 1 && SpecialSelectionUI.this.tree.getSelectionModel().isPathSelected(clickPath)) {
                        SpecialSelectionUI.this.releasedAction = true;
                        return;
                    }
                    SpecialSelectionUI.super.createMouseListener().mousePressed(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    TreePath clickPath = SpecialSelectionUI.this.tree.getPathForLocation(e.getX(), e.getY());
                    if (SpecialSelectionUI.this.releasedAction && SpecialSelectionUI.this.tree.getSelectionModel().isPathSelected(clickPath)) {
                        SpecialSelectionUI.this.releasedAction = false;
                        SpecialSelectionUI.super.createMouseListener().mousePressed(e);
                    }
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    SpecialSelectionUI.super.createMouseListener().mouseEntered(e);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    SpecialSelectionUI.super.createMouseListener().mouseExited(e);
                }
            };
        }
    }
}

