/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.tools.gui.xhtmlrenderer;

import de.cismet.security.WebAccessManager;
import de.cismet.security.exceptions.AccessMethodIsNotSupportedException;
import de.cismet.security.exceptions.MissingArgumentException;
import de.cismet.security.exceptions.NoHandlerForURLException;
import de.cismet.security.exceptions.RequestFailedException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.xhtmlrenderer.resource.XMLResource;
import org.xhtmlrenderer.swing.NaiveUserAgent;

public class WebAccessManagerUserAgent
extends NaiveUserAgent {
    private static final Logger LOG = Logger.getLogger(WebAccessManagerUserAgent.class);
    private Pattern encodingPattern = Pattern.compile("(encoding|charset)=\"?(.*?)[;\" ]");
    private Pattern windowsEncodingPattern = Pattern.compile("windows-(\\d{4})");

    protected InputStream resolveAndOpenStream(String uri) {
        InputStream result = null;
        if (uri != null && uri.trim().length() > 0) {
            if (uri.startsWith("jar") || uri.startsWith("file")) {
                try {
                    result = new URL(uri).openStream();
                }
                catch (MalformedURLException ex) {
                    LOG.error((Object)("Can't load from URI '" + uri + "' since the resulting URL is malformed."), (Throwable)ex);
                }
                catch (IOException ex) {
                    LOG.error((Object)("Can't load from URI '" + uri + "'."), (Throwable)ex);
                }
            } else {
                try {
                    result = WebAccessManager.getInstance().doRequest(new URL(uri));
                }
                catch (URISyntaxException ex) {
                    LOG.error((Object)("Can't load from URI '" + uri + "' since its syntax is broken."), (Throwable)ex);
                }
                catch (MissingArgumentException ex) {
                    LOG.error((Object)("Can't load from URI '" + uri + "' since it couldn't be converted to a URL."), (Throwable)ex);
                }
                catch (AccessMethodIsNotSupportedException ex) {
                    LOG.error((Object)("Can't load from URI '" + uri + "' since the access method isn't supported."), (Throwable)ex);
                }
                catch (RequestFailedException ex) {
                    LOG.error((Object)("The request to load URI '" + uri + "' failed."), (Throwable)ex);
                }
                catch (NoHandlerForURLException ex) {
                    LOG.error((Object)("Can't load from URI '" + uri + "' since there is no matching handler."), (Throwable)ex);
                }
                catch (Exception ex) {
                    LOG.error((Object)("Can't load from URI '" + uri + "' since an unexcpected exception occurred."), (Throwable)ex);
                }
            }
        }
        return result;
    }

    public XMLResource getXMLResource(String uri) {
        Reader reader = this.resolveAndOpenEncodedStream(uri);
        XMLResource xmlResource = XMLResource.load((Reader)reader);
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException e) {
                LOG.warn((Object)"Couldn't close reader.", (Throwable)e);
            }
        }
        return xmlResource;
    }

    private Reader resolveAndOpenEncodedStream(String uri) {
        InputStreamReader result = null;
        String encoding = null;
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.resolveAndOpenStream(uri)));
        Matcher matcher = null;
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                matcher = this.encodingPattern.matcher(line);
                if (!matcher.find()) continue;
                encoding = matcher.group(2);
                break;
            }
        }
        catch (IOException ex) {
            LOG.warn((Object)("Couldn't determine encoding of resource: '" + uri + "'."), (Throwable)ex);
        }
        matcher = this.windowsEncodingPattern.matcher(encoding);
        if (matcher.find()) {
            encoding = "Cp" + matcher.group(1);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Encoding resource '" + uri + "' in '" + encoding + "'."));
        }
        try {
            result = new InputStreamReader(this.resolveAndOpenStream(uri), encoding);
        }
        catch (UnsupportedEncodingException ex) {
            LOG.error((Object)("Error opening a reader on URI '" + uri + "' with unsupported encoding '" + encoding + "'."), (Throwable)ex);
        }
        return result;
    }
}

