/*
 * Decompiled with CFR 0.152.
 */
package net.environmatics.acs.accessor.methods;

import net.environmatics.acs.accessor.interfaces.AuthenticationMethod;
import net.environmatics.acs.accessor.utils.DOMHelper;
import org.apache.commons.httpclient.NameValuePair;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.QName;

public class AnonymousAuthenticationMethod
implements AuthenticationMethod {
    public static final String METHOD_URN = "urn:x-gdi-nrw:authnMethod:1.0:anonymous";

    @Override
    public NameValuePair[] asNameValue() {
        NameValuePair[] data = new NameValuePair[]{new NameValuePair("AUTHMETHOD", METHOD_URN), new NameValuePair("CREDENTIALS", "")};
        return data;
    }

    @Override
    public String asText() {
        return "Authentication Method: Anonymous - Method URN: urn:x-gdi-nrw:authnMethod:1.0:anonymous";
    }

    @Override
    public Element asDOM4jElement() {
        DocumentFactory docFactory = DOMHelper.getDocumentFactory();
        Element authnData = docFactory.createElement(new QName("AuthenticationData", DOMHelper.NAMESPACE_AUTHEN));
        Element authnMethod = docFactory.createElement(new QName("AuthenticationMethod", DOMHelper.NAMESPACE_AUTHEN));
        authnMethod.addAttribute("id", METHOD_URN);
        Element authnCredentials = docFactory.createElement(new QName("Credentials", DOMHelper.NAMESPACE_AUTHEN));
        authnCredentials.addText("");
        authnData.add(authnMethod);
        authnData.add(authnCredentials);
        return authnData;
    }

    public String toString() {
        return METHOD_URN;
    }
}

