/*
 * Decompiled with CFR 0.152.
 */
package net.environmatics.acs.accessor.methods;

import net.environmatics.acs.accessor.interfaces.AuthenticationMethod;
import net.environmatics.acs.accessor.interfaces.SessionInformation;
import net.environmatics.acs.accessor.utils.DOMHelper;
import org.apache.commons.httpclient.NameValuePair;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.QName;

public class SessionAuthenticationMethod
implements AuthenticationMethod {
    public static final String METHOD_URN = "urn:x-gdi-nrw:authnMethod:1.0:session";
    private String sessionID;

    public SessionAuthenticationMethod(String credentials) {
        this.sessionID = credentials;
    }

    public SessionAuthenticationMethod(SessionInformation sessionInfo) {
        this.sessionID = sessionInfo.getSessionID();
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public void setSessionID(String sessionID) {
        this.sessionID = sessionID;
    }

    @Override
    public NameValuePair[] asNameValue() {
        NameValuePair[] data = new NameValuePair[]{new NameValuePair("AUTHMETHOD", METHOD_URN), new NameValuePair("CREDENTIALS", this.sessionID)};
        return data;
    }

    @Override
    public String asText() {
        return "Authentication Method: Session - Method URN: urn:x-gdi-nrw:authnMethod:1.0:session";
    }

    @Override
    public Element asDOM4jElement() {
        DocumentFactory docFactory = DOMHelper.getDocumentFactory();
        Element authnData = docFactory.createElement(new QName("AuthenticationData", DOMHelper.NAMESPACE_AUTHEN));
        Element authnMethod = docFactory.createElement(new QName("AuthenticationMethod", DOMHelper.NAMESPACE_AUTHEN));
        authnMethod.addAttribute("id", METHOD_URN);
        Element authnCredentials = docFactory.createElement(new QName("Credentials", DOMHelper.NAMESPACE_AUTHEN));
        authnCredentials.addText(this.sessionID);
        authnData.add(authnMethod);
        authnData.add(authnCredentials);
        return authnData;
    }

    public String toString() {
        return METHOD_URN;
    }
}

