/*
 * Decompiled with CFR 0.152.
 */
package net.environmatics.acs.accessor.utils;

import java.util.HashMap;
import net.environmatics.acs.accessor.interfaces.AuthenticationMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class DOMHelper {
    public static final Namespace NAMESPACE_OWS = new Namespace("ows", "http://www.opengis.net/ows");
    public static final Namespace NAMESPACE_AUTHEN = new Namespace("authn", "http://www.gdi-nrw.org/authentication");
    public static final Namespace NAMESPACE_WAS = new Namespace("was", "http://www.gdi-nrw.org/was");
    public static final Namespace NAMESPACE_WSS = new Namespace("wss", "http://www.gdi-nrw.org/wss");
    public static final Namespace NAMESPACE_XSI = new Namespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
    private static DocumentFactory documentFactory = DocumentFactory.getInstance();

    private DOMHelper() {
    }

    public static DocumentFactory getDocumentFactory() {
        return documentFactory;
    }

    public static Document generateDoService(String dcp_type, String request, AuthenticationMethod authMethod, NameValuePair[] requestParams, String facadeURL) {
        if (!dcp_type.equals("HTTP_POST") && !dcp_type.equals("HTTP_GET")) {
            throw new IllegalArgumentException(dcp_type + " not supported!");
        }
        DocumentFactory docFactory = DOMHelper.getDocumentFactory();
        Element elServiceRequest = docFactory.createElement(new QName("ServiceRequest", NAMESPACE_WSS));
        elServiceRequest.add(docFactory.createAttribute(elServiceRequest, "DCP", dcp_type));
        for (NameValuePair nvp : requestParams) {
            Element elRequestParameter = docFactory.createElement(new QName("RequestParameter", NAMESPACE_WSS));
            elRequestParameter.add(docFactory.createAttribute(elRequestParameter, "id", nvp.getName()));
            elRequestParameter.addText(nvp.getValue());
            elServiceRequest.add(elRequestParameter);
        }
        Element elPayload = docFactory.createElement(new QName("Payload", NAMESPACE_WSS));
        if (dcp_type.equals("HTTP_GET")) {
            elPayload.addText(request);
        } else {
            elPayload.addCDATA(request);
        }
        elServiceRequest.add(elPayload);
        Element elFacadeURL = docFactory.createElement(new QName("FacadeURL", NAMESPACE_WSS));
        elFacadeURL.addText(facadeURL);
        Element elDoService = docFactory.createElement(new QName("DoService"));
        elDoService.add(NAMESPACE_AUTHEN);
        elDoService.add(NAMESPACE_WSS);
        elDoService.add(NAMESPACE_OWS);
        elDoService.add(NAMESPACE_XSI);
        elDoService.addAttribute("service", "WSS");
        elDoService.addAttribute("version", "1.0");
        elDoService.add(authMethod.asDOM4jElement());
        elDoService.add(elServiceRequest);
        elDoService.add(elFacadeURL);
        Document requestDoc = docFactory.createDocument();
        requestDoc.add(elDoService);
        return requestDoc;
    }

    static {
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put(NAMESPACE_OWS.getPrefix(), NAMESPACE_OWS.getURI());
        namespaces.put(NAMESPACE_AUTHEN.getPrefix(), NAMESPACE_AUTHEN.getURI());
        namespaces.put(NAMESPACE_WAS.getPrefix(), NAMESPACE_WAS.getURI());
        namespaces.put(NAMESPACE_WSS.getPrefix(), NAMESPACE_WSS.getURI());
        namespaces.put(NAMESPACE_XSI.getPrefix(), NAMESPACE_XSI.getURI());
        documentFactory.setXPathNamespaceURIs(namespaces);
    }
}

