/*
 * Decompiled with CFR 0.152.
 */
package net.environmatics.acs.accessor;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.environmatics.acs.accessor.Payload;
import net.environmatics.acs.accessor.SessionInformationDeegree;
import net.environmatics.acs.accessor.interfaces.AuthenticationMethod;
import net.environmatics.acs.accessor.interfaces.SessionInformation;
import net.environmatics.acs.accessor.interfaces.WSSAccessor;
import net.environmatics.acs.accessor.methods.AnonymousAuthenticationMethod;
import net.environmatics.acs.accessor.methods.SessionAuthenticationMethod;
import net.environmatics.acs.accessor.utils.DOMHelper;
import net.environmatics.acs.exceptions.AuthenticationFailedException;
import net.environmatics.acs.exceptions.ServiceException;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.auth.CredentialsProvider;
import org.apache.commons.httpclient.contrib.ssl.EasySSLProtocolSocketFactory;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class WSSAccessorDeegree
implements WSSAccessor {
    private static Logger logger = Logger.getLogger(WSSAccessorDeegree.class);
    ReadWriteLock lock = new ReentrantReadWriteLock();
    private String wss_url;
    private HttpClient client;
    private SessionInformation sessionInfo;
    private AuthenticationMethod authnMethod;
    private String[] supportedAuthnMethods;
    private Document wssCapabilities;
    private boolean isCredentialProviderAvailable = false;
    private SessionAuthenticationMethod currentAuth = null;
    private boolean lastDoServiceFailed = false;

    public WSSAccessorDeegree() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"WSS AccessorDeegree()");
        }
        this.client = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
        this.wss_url = null;
        this.supportedAuthnMethods = null;
        this.sessionInfo = null;
        this.authnMethod = new AnonymousAuthenticationMethod();
    }

    public WSSAccessorDeegree(String wssURL) {
        this();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"WSS AccessorDeegree(wssUrl)");
        }
        this.setWSS(wssURL);
    }

    public WSSAccessorDeegree(String wssURL, String proxyURL, int port) {
        this(wssURL);
        this.setProxy(proxyURL, port);
    }

    @Override
    public synchronized Payload doService(String dcp_type, String serviceRequest, NameValuePair[] requestParams, String facadeURL) throws ServiceException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("service request: " + serviceRequest + " facade url: " + facadeURL));
        }
        if (this.wss_url == null) {
            throw new NullPointerException("wss_url is not initialized");
        }
        if (this.currentAuth == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"not yet authed => call newSession()");
            }
            this.newSession();
        }
        String postMethod = this.wss_url;
        if (dcp_type.equals("HTTP_GET")) {
            postMethod = postMethod + "?";
        }
        PostMethod post = new PostMethod(postMethod);
        if (this.isCredentialProviderAvailable) {
            post.setDoAuthentication(true);
        }
        Payload doServiceResponse = null;
        try {
            Header[] footer;
            Header[] header;
            String wssRequest = serviceRequest + "&sessionID=" + this.currentAuth.getSessionID();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("WSS request: " + wssRequest.toString()));
            }
            Document request = DOMHelper.generateDoService(dcp_type, wssRequest, this.currentAuth, requestParams, facadeURL);
            post.setRequestEntity((RequestEntity)new StringRequestEntity(request.asXML(), "text/xml", "UTF-8"));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("sending WSS request: " + request.asXML()));
            }
            this.client.executeMethod((HttpMethod)post);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("getResponseBody: " + post.getResponseBody().toString()));
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("ResponseCharset: " + post.getResponseCharSet()));
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("ContentLength: " + post.getResponseContentLength()));
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("getStatusCode: " + post.getStatusCode()));
            }
            if ((header = post.getResponseHeaders()) != null) {
                for (Header current : header) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Response Header: " + current.getName() + " value: " + current.getValue()));
                }
            }
            if ((footer = post.getResponseFooters()) != null) {
                for (Header current : footer) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Response footer: " + current.getName() + " value: " + current.getValue()));
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Befor Payload object creation");
            }
            doServiceResponse = new Payload(post.getResponseBody(), post.getResponseCharSet());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"After Payload object creation");
            }
            if (doServiceResponse.containsException()) {
                if (!this.lastDoServiceFailed) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"doRequest failed first time => call newSession() and try again.");
                    }
                    this.newSession();
                    this.lastDoServiceFailed = true;
                    return this.doService(dcp_type, serviceRequest, requestParams, facadeURL);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"doRequest failed second time in a row => give up (throw Exception).");
                }
                this.lastDoServiceFailed = false;
                throw new ServiceException(doServiceResponse.asText());
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"doRequest not failed.");
            }
            this.lastDoServiceFailed = false;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)doServiceResponse.asText());
            }
            return doServiceResponse;
        }
        catch (IOException rethrow) {
            try {
                logger.error((Object)("Error in doService(). Exception: " + rethrow));
                throw rethrow;
            }
            catch (IOException ex) {
                logger.error((Object)("Could not perform doService(). Exception: " + ex));
                throw new ServiceException(ex);
            }
        }
    }

    private synchronized void newSession() throws ServiceException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"newSession()");
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"first close current session");
            }
            this.closeSession();
        }
        catch (ServiceException ex) {
            logger.warn((Object)"Failure while closing session", (Throwable)ex);
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"authenticate => calling getSession(authnMethod)");
            }
            SessionInformation sInfo = this.getSession(this.authnMethod);
            this.currentAuth = new SessionAuthenticationMethod(sInfo);
        }
        catch (AuthenticationFailedException ex) {
            this.currentAuth = null;
            logger.error((Object)"Authentication failed couldn't aquire session id: ", (Throwable)ex);
            throw new ServiceException(ex);
        }
    }

    @Override
    public Payload doService(String dcp_type, String serviceRequest, String facadeURL) throws ServiceException {
        return this.doService(dcp_type, serviceRequest, new NameValuePair[]{new NameValuePair("HTTP_Header", "Mime-Type: text/xml")}, facadeURL);
    }

    @Override
    public SessionInformation getSession(AuthenticationMethod authnMethod) throws AuthenticationFailedException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"getSession()");
        }
        if (this.wss_url == null) {
            throw new NullPointerException("wss_url is not initialized");
        }
        this.authnMethod = authnMethod;
        try {
            logger.info((Object)("getSession() with " + authnMethod.asText()));
            PostMethod post = new PostMethod(this.wss_url + "?");
            if (this.isCredentialProviderAvailable) {
                post.setDoAuthentication(true);
            }
            NameValuePair[] body = WSSAccessorDeegree.arrayMerge(authnMethod.asNameValue(), new NameValuePair[]{new NameValuePair("SERVICE", "WSS"), new NameValuePair("VERSION", "1.0"), new NameValuePair("REQUEST", "GetSession")});
            post.setRequestBody(body);
            this.client.executeMethod((HttpMethod)post);
            Payload getSessionResponse = new Payload(post.getResponseBodyAsStream(), post.getResponseCharSet());
            if (getSessionResponse.containsException()) {
                throw new AuthenticationFailedException(getSessionResponse.asText());
            }
            this.sessionInfo = new SessionInformationDeegree(getSessionResponse);
            logger.info((Object)("New Session with SessionID=" + this.sessionInfo.getSessionID() + " length: " + this.sessionInfo.getSessionID().length()));
            if (this.sessionInfo.getSessionID() == null || this.sessionInfo.getSessionID().length() == 0 || this.sessionInfo.getSessionID().length() == 2) {
                throw new AuthenticationFailedException("SessionID is null or equals  \"\"");
            }
            return this.sessionInfo;
        }
        catch (IOException ioex) {
            logger.info((Object)("Could not perform getSession(). Exception: " + ioex));
            throw new AuthenticationFailedException(ioex);
        }
    }

    public SessionInformation getSession() throws AuthenticationFailedException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"getSession() ");
        }
        if (this.wss_url == null) {
            throw new NullPointerException("wss_url is not initialized");
        }
        try {
            logger.info((Object)("getSession() with " + this.authnMethod.asText()));
            PostMethod post = new PostMethod(this.wss_url + "?");
            if (this.isCredentialProviderAvailable) {
                post.setDoAuthentication(true);
            }
            NameValuePair[] body = WSSAccessorDeegree.arrayMerge(this.authnMethod.asNameValue(), new NameValuePair[]{new NameValuePair("SERVICE", "WSS"), new NameValuePair("VERSION", "1.0"), new NameValuePair("REQUEST", "GetSession")});
            post.setRequestBody(body);
            HttpClient tmpClient = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
            tmpClient.executeMethod((HttpMethod)post);
            Payload getSessionResponse = new Payload(post.getResponseBodyAsStream(), post.getResponseCharSet());
            if (getSessionResponse.containsException()) {
                throw new AuthenticationFailedException(getSessionResponse.asText());
            }
            SessionInformationDeegree tmpSI = new SessionInformationDeegree(getSessionResponse);
            logger.info((Object)("New Session with SessionID=" + tmpSI.getSessionID() + " length: " + tmpSI.getSessionID().length()));
            if (tmpSI.getSessionID() == null || tmpSI.getSessionID().length() == 0 || tmpSI.getSessionID().length() == 2) {
                throw new AuthenticationFailedException("SessionID is null or equals  \"\"");
            }
            return tmpSI;
        }
        catch (IOException ioex) {
            logger.info((Object)("Could not perform getSession(). Exception: " + ioex));
            throw new AuthenticationFailedException(ioex);
        }
    }

    @Override
    public void closeSession() throws ServiceException {
        if (this.wss_url == null) {
            throw new NullPointerException("wss_url is not initialized");
        }
        try {
            PostMethod post = new PostMethod(this.wss_url + "?");
            if (this.isCredentialProviderAvailable) {
                post.setDoAuthentication(true);
            }
            NameValuePair[] data = new NameValuePair[]{new NameValuePair("SERVICE", "WSS"), new NameValuePair("REQUEST", "CloseSession"), new NameValuePair("SESSIONID", this.sessionInfo.getSessionID())};
            post.setRequestBody(data);
            this.client.executeMethod((HttpMethod)post);
            Payload closeSessionResponse = new Payload(post.getResponseBodyAsStream(), post.getResponseCharSet());
            if (closeSessionResponse.containsException()) {
                logger.error((Object)closeSessionResponse.asText());
                throw new ServiceException(closeSessionResponse.asText());
            }
        }
        catch (IOException ex) {
            logger.info((Object)("Could not perform closeSession(). Exception: " + ex));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"closeSession() called successfully");
        }
    }

    public void closeSession(SessionInformation si) throws ServiceException {
        if (this.wss_url == null) {
            throw new NullPointerException("wss_url is not initialized");
        }
        try {
            PostMethod post = new PostMethod(this.wss_url + "?");
            if (this.isCredentialProviderAvailable) {
                post.setDoAuthentication(true);
            }
            NameValuePair[] data = new NameValuePair[]{new NameValuePair("SERVICE", "WSS"), new NameValuePair("REQUEST", "CloseSession"), new NameValuePair("SESSIONID", si.getSessionID())};
            post.setRequestBody(data);
            this.client.executeMethod((HttpMethod)post);
            Payload closeSessionResponse = new Payload(post.getResponseBodyAsStream(), post.getResponseCharSet());
            if (closeSessionResponse.containsException()) {
                logger.error((Object)closeSessionResponse.asText());
                throw new ServiceException(closeSessionResponse.asText());
            }
        }
        catch (IOException ex) {
            logger.info((Object)("Could not perform closeSession(). Exception: " + ex));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"closeSession() called successfully");
        }
    }

    @Override
    public String getWSS() {
        return this.wss_url.toString();
    }

    public URL getWSSURL() {
        try {
            return new URL(this.wss_url);
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    @Override
    public void setProxy(String proxy_url, int port) {
        if (proxy_url == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"make new httpclient without proxy");
            }
            this.client = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("set accessor proxy: " + proxy_url + ":" + port));
            }
            this.client.getHostConfiguration().setProxy(proxy_url, port);
        }
    }

    @Override
    public void setCredentialProvider(CredentialsProvider credentialProvider) {
        this.client.getParams().setParameter("http.authentication.credential-provider", (Object)credentialProvider);
        this.isCredentialProviderAvailable = credentialProvider != null;
    }

    @Override
    public void setWSS(String wssUrl) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Using WSS: " + wssUrl));
        }
        this.wss_url = wssUrl;
        try {
            URL wssURL = new URL(wssUrl);
            if (!wssURL.getProtocol().equals("https")) {
                return;
            }
            Protocol easyHTTPS = new Protocol("https", (ProtocolSocketFactory)new EasySSLProtocolSocketFactory(), wssURL.getPort());
            Protocol.registerProtocol((String)"https", (Protocol)easyHTTPS);
            this.supportedAuthnMethods = null;
            this.sessionInfo = null;
        }
        catch (MalformedURLException ex) {
            logger.error((Object)("URL " + this.wss_url + " is malformed"));
        }
    }

    @Override
    public void setAuthenticationMethod(AuthenticationMethod authnMethod) {
        this.authnMethod = authnMethod;
    }

    @Override
    public List<String> getSupportedAuthenticationMethods() {
        if (this.wss_url == null) {
            throw new NullPointerException("wss_url is not initialized");
        }
        ArrayList<String> authMethodsList = new ArrayList<String>();
        Document capabilities = this.getWSSCapabilities();
        if (capabilities == null) {
            return authMethodsList;
        }
        ListIterator it = capabilities.selectNodes("//authn:SupportedAuthenticationMethod").listIterator();
        while (it.hasNext()) {
            Node e = (Node)it.next();
            authMethodsList.add(e.valueOf("//authn:AuthenticationMethod/@id"));
            e.detach();
        }
        return authMethodsList;
    }

    @Override
    public Document getWSSCapabilities() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Initial retrieval of WSS Capabilites");
        }
        if (this.wss_url == null) {
            throw new NullPointerException("wss_url is not initialized");
        }
        try {
            GetMethod get = new GetMethod(this.wss_url + "?SERVICE=WSS&REQUEST=GetCapabilities");
            if (this.isCredentialProviderAvailable) {
                get.setDoAuthentication(true);
            }
            this.client.executeMethod((HttpMethod)get);
            return this.getXMLDocumentFromStream(get.getResponseBodyAsStream());
        }
        catch (DocumentException dex) {
            logger.info((Object)("Could not parse capabilities document. Exception: " + (Object)((Object)dex)));
        }
        catch (IOException ex) {
            logger.info((Object)("Could not perform getCapabilities(). Exception: " + ex.getClass()));
        }
        return null;
    }

    public String getSecuredServiceType() {
        if (this.wssCapabilities == null) {
            this.wssCapabilities = this.getWSSCapabilities();
        }
        if (this.wssCapabilities != null) {
            Element root;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"wssCaps != null");
            }
            if ((root = this.wssCapabilities.getRootElement()) != null) {
                Element caps;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"root Element != null");
                }
                if ((caps = root.element("Capability")) != null) {
                    Element securedServiceType;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Caps Element != null");
                    }
                    if ((securedServiceType = caps.element("SecuredServiceType")) != null) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"SecuredServiceType Element != null");
                        }
                        return securedServiceType.getText();
                    }
                }
            }
        }
        logger.warn((Object)"It was not possible to determine the secured service type");
        return null;
    }

    private Document getXMLDocumentFromStream(InputStream is) throws DocumentException {
        SAXReader reader = new SAXReader();
        Document doc = reader.read(is);
        return doc;
    }

    private static <TYPE> TYPE[] arrayMerge(TYPE[] arrayA, TYPE[] arrayB) {
        int size = arrayA.length + arrayB.length;
        Object[] mergedArray = (Object[])Array.newInstance(arrayA.getClass().getComponentType(), size);
        System.arraycopy(arrayA, 0, mergedArray, 0, arrayA.length);
        System.arraycopy(arrayB, 0, mergedArray, arrayA.length, arrayB.length);
        return mergedArray;
    }

    public boolean isSessionAvailable() {
        return this.sessionInfo != null;
    }
}

