/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.beansbinding.ext;

import java.beans.BeanInfo;
import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.jdesktop.beansbinding.ext.BeanAdapterProvider;

public final class BeanAdapterFactory {
    private static final BeanAdapterFactory INSTANCE = new BeanAdapterFactory();
    private final Map<Object, List<VendedAdapter>> vendedAdapters;
    private final List<BeanAdapterProvider> providers = new ArrayList<BeanAdapterProvider>();
    private final Set<ClassLoader> classLoaders = new HashSet<ClassLoader>();
    private final Set<URL> serviceURLs = new HashSet<URL>();

    public static Object getAdapter(Object source, String property) {
        return INSTANCE.getAdapter0(source, property);
    }

    public static List<PropertyDescriptor> getAdapterPropertyDescriptors(Class<?> type) {
        return INSTANCE.getAdapterPropertyDescriptors0(type);
    }

    public BeanAdapterFactory() {
        this.vendedAdapters = new WeakHashMap<Object, List<VendedAdapter>>();
    }

    private void loadProvidersIfNecessary() {
        ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
        if (!this.classLoaders.contains(currentLoader)) {
            this.classLoaders.add(currentLoader);
            this.loadProviders(currentLoader);
        }
    }

    private void loadProviders(ClassLoader classLoader) {
        String serviceName = "META-INF/services/" + BeanAdapterProvider.class.getName();
        try {
            Enumeration<URL> urls = classLoader.getResources(serviceName);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                if (this.serviceURLs.contains(url)) continue;
                this.serviceURLs.add(url);
                this.addProviders(url);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void addProviders(URL url) {
        InputStream inputStream = null;
        BufferedReader reader = null;
        try {
            String line;
            inputStream = url.openStream();
            reader = new BufferedReader(new InputStreamReader(inputStream, "utf-8"));
            while ((line = reader.readLine()) != null) {
                try {
                    this.providers.add((BeanAdapterProvider)Class.forName(line).newInstance());
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public Object getAdapter0(Object source, String property) {
        if (source == null || property == null) {
            throw new IllegalArgumentException();
        }
        this.loadProvidersIfNecessary();
        property = property.intern();
        BeanAdapterProvider provider = this.getProvider(source, property);
        if (provider != null) {
            List<VendedAdapter> adapters = this.vendedAdapters.get(source);
            if (adapters != null) {
                for (int i = adapters.size() - 1; i >= 0; --i) {
                    VendedAdapter vendedAdapter = adapters.get(i);
                    Object adapter = vendedAdapter.getAdapter();
                    if (adapter == null) {
                        this.vendedAdapters.remove(i);
                        continue;
                    }
                    if (vendedAdapter.getProvider() != provider || vendedAdapter.getProperty() != property) continue;
                    return adapter;
                }
            } else {
                adapters = new ArrayList<VendedAdapter>(1);
                this.vendedAdapters.put(source, adapters);
            }
            Object adapter = provider.createAdapter(source, property);
            adapters.add(new VendedAdapter(property, provider, adapter));
            return adapter;
        }
        return null;
    }

    private BeanAdapterProvider getProvider(Object source, String property) {
        Class<?> type = source.getClass();
        for (BeanAdapterProvider provider : this.providers) {
            if (!provider.providesAdapter(type, property)) continue;
            return provider;
        }
        return null;
    }

    private List<FeatureDescriptor> getDescriptors(Class<?> type) {
        BeanInfo info = null;
        try {
            info = Introspector.getBeanInfo(type);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (info == null) {
            return Collections.emptyList();
        }
        ArrayList<FeatureDescriptor> list = new ArrayList<FeatureDescriptor>(info.getPropertyDescriptors().length);
        for (PropertyDescriptor pd : info.getPropertyDescriptors()) {
            if (pd.getPropertyType() != null) {
                pd.setValue("type", pd.getPropertyType());
            }
            pd.setValue("resolvableAtDesignTime", Boolean.TRUE);
            list.add(pd);
        }
        return list;
    }

    private static BeanInfo getBeanInfo(Class<?> type) {
        try {
            return Introspector.getBeanInfo(type);
        }
        catch (IntrospectionException ie) {
            return null;
        }
    }

    private List<PropertyDescriptor> getAdapterPropertyDescriptors0(Class<?> type) {
        if (type == null) {
            throw new IllegalArgumentException("Type must be non-null");
        }
        this.loadProvidersIfNecessary();
        ArrayList<PropertyDescriptor> des = new ArrayList<PropertyDescriptor>();
        for (BeanAdapterProvider provider : this.providers) {
            PropertyDescriptor[] pds;
            BeanInfo info;
            Class<?> pdType = provider.getAdapterClass(type);
            if (pdType == null || (info = BeanAdapterFactory.getBeanInfo(pdType)) == null || (pds = info.getPropertyDescriptors()) == null) continue;
            for (PropertyDescriptor pd : pds) {
                if (!provider.providesAdapter(type, pd.getName())) continue;
                des.add(pd);
            }
        }
        return des;
    }

    private static final class VendedAdapter {
        private final BeanAdapterProvider provider;
        private final String property;
        private final WeakReference<Object> adapter;

        public VendedAdapter(String property, BeanAdapterProvider provider, Object adapter) {
            this.property = property;
            this.adapter = new WeakReference<Object>(adapter);
            this.provider = provider;
        }

        public Object getAdapter() {
            return this.adapter.get();
        }

        public String getProperty() {
            return this.property;
        }

        public BeanAdapterProvider getProvider() {
            return this.provider;
        }
    }
}

