/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.el.impl.parser;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.jdesktop.el.ELContext;
import org.jdesktop.el.ELException;
import org.jdesktop.el.impl.lang.EvaluationContext;
import org.jdesktop.el.impl.parser.SimpleNode;

public final class AstNegative
extends SimpleNode {
    public AstNegative(int id) {
        super(id);
    }

    @Override
    public Class getType(EvaluationContext ctx) throws ELException {
        return Number.class;
    }

    @Override
    public Object getValue(EvaluationContext ctx) throws ELException {
        Object obj = this.children[0].getValue(ctx);
        if (obj == ELContext.UNRESOLVABLE_RESULT) {
            return ELContext.UNRESOLVABLE_RESULT;
        }
        if (obj == null) {
            return new Long(0L);
        }
        if (obj instanceof BigDecimal) {
            return ((BigDecimal)obj).negate();
        }
        if (obj instanceof BigInteger) {
            return ((BigInteger)obj).negate();
        }
        if (obj instanceof String) {
            if (AstNegative.isStringFloat((String)obj)) {
                return new Double(-Double.parseDouble((String)obj));
            }
            return new Long(-Long.parseLong((String)obj));
        }
        Class<?> type = obj.getClass();
        if (obj instanceof Long || Long.TYPE == type) {
            return new Long(-((Long)obj).longValue());
        }
        if (obj instanceof Double || Double.TYPE == type) {
            return new Double(-((Double)obj).doubleValue());
        }
        if (obj instanceof Integer || Integer.TYPE == type) {
            return new Integer(-((Integer)obj).intValue());
        }
        if (obj instanceof Float || Float.TYPE == type) {
            return new Float(-((Float)obj).floatValue());
        }
        if (obj instanceof Short || Short.TYPE == type) {
            return new Short(-((Short)obj).shortValue());
        }
        if (obj instanceof Byte || Byte.TYPE == type) {
            return new Byte(-((Byte)obj).byteValue());
        }
        Long num = (Long)AstNegative.coerceToNumber(obj, Long.class);
        return new Long(-num.longValue());
    }
}

