/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingbinding.adapters;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JFormattedTextField;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.JTextComponent;
import org.jdesktop.beansbinding.ext.BeanAdapterProvider;
import org.jdesktop.swingbinding.adapters.BeanAdapterBase;

public final class JTextComponentAdapterProvider
implements BeanAdapterProvider {
    private static final String PROPERTY_BASE = "text";
    private static final String ON_ACTION_OR_FOCUS_LOST = "text_ON_ACTION_OR_FOCUS_LOST";
    private static final String ON_FOCUS_LOST = "text_ON_FOCUS_LOST";

    @Override
    public boolean providesAdapter(Class<?> type, String property) {
        if (!JTextComponent.class.isAssignableFrom(type)) {
            return false;
        }
        return (property = property.intern()) == PROPERTY_BASE || property == ON_ACTION_OR_FOCUS_LOST || property == ON_FOCUS_LOST;
    }

    @Override
    public Object createAdapter(Object source, String property) {
        if (!this.providesAdapter(source.getClass(), property)) {
            throw new IllegalArgumentException();
        }
        return new Adapter((JTextComponent)source, property);
    }

    @Override
    public Class<?> getAdapterClass(Class<?> type) {
        return JTextComponent.class.isAssignableFrom(type) ? Adapter.class : null;
    }

    public final class Adapter
    extends BeanAdapterBase {
        private JTextComponent component;
        private Document document;
        private boolean inDocumentListener;
        private boolean installedFilter;
        private String cachedText;
        private Handler handler;

        private Adapter(JTextComponent component, String property) {
            super(property);
            this.component = component;
        }

        public String getText() {
            return this.component.getText();
        }

        public String getText_ON_ACTION_OR_FOCUS_LOST() {
            return this.getText();
        }

        public String getText_ON_FOCUS_LOST() {
            return this.getText();
        }

        public void setText(String text) {
            this.component.setText(text);
            this.component.setCaretPosition(0);
            this.cachedText = text;
        }

        public void setText_ON_ACTION_OR_FOCUS_LOST(String text) {
            this.setText(text);
        }

        public void setText_ON_FOCUS_LOST(String text) {
            this.setText(text);
        }

        @Override
        protected void listeningStarted() {
            this.cachedText = this.component.getText();
            this.handler = new Handler();
            this.component.addPropertyChangeListener("document", this.handler);
            if (this.property != JTextComponentAdapterProvider.PROPERTY_BASE) {
                this.component.addFocusListener(this.handler);
            }
            if (this.property == JTextComponentAdapterProvider.ON_ACTION_OR_FOCUS_LOST && this.component instanceof JTextField) {
                ((JTextField)this.component).addActionListener(this.handler);
            }
            this.document = this.component.getDocument();
            this.installDocumentListener();
        }

        @Override
        protected void listeningStopped() {
            this.cachedText = null;
            this.component.removePropertyChangeListener("document", this.handler);
            if (this.property != JTextComponentAdapterProvider.PROPERTY_BASE) {
                this.component.removeFocusListener(this.handler);
            }
            if (this.property == JTextComponentAdapterProvider.ON_ACTION_OR_FOCUS_LOST && this.component instanceof JTextField) {
                ((JTextField)this.component).removeActionListener(this.handler);
            }
            this.uninstallDocumentListener();
            this.document = null;
            this.handler = null;
        }

        private void installDocumentListener() {
            boolean useDocumentFilter;
            if (this.property != JTextComponentAdapterProvider.PROPERTY_BASE) {
                return;
            }
            boolean bl = useDocumentFilter = !(this.component instanceof JFormattedTextField);
            if (useDocumentFilter && this.document instanceof AbstractDocument && ((AbstractDocument)this.document).getDocumentFilter() == null) {
                ((AbstractDocument)this.document).setDocumentFilter(this.handler);
                this.installedFilter = true;
            } else {
                this.document.addDocumentListener(this.handler);
                this.installedFilter = false;
            }
        }

        private void uninstallDocumentListener() {
            if (this.property != JTextComponentAdapterProvider.PROPERTY_BASE) {
                return;
            }
            if (this.installedFilter) {
                AbstractDocument ad = (AbstractDocument)this.document;
                if (ad.getDocumentFilter() == this.handler) {
                    ad.setDocumentFilter(null);
                }
            } else {
                this.document.removeDocumentListener(this.handler);
            }
        }

        private class Handler
        extends DocumentFilter
        implements ActionListener,
        DocumentListener,
        FocusListener,
        PropertyChangeListener {
            private Handler() {
            }

            private void updateText() {
                String oldText = Adapter.this.cachedText;
                Adapter.this.cachedText = Adapter.this.getText();
                Adapter.this.firePropertyChange(oldText, Adapter.this.cachedText);
            }

            private void documentTextChanged() {
                try {
                    Adapter.this.inDocumentListener = true;
                    this.textChanged();
                }
                finally {
                    Adapter.this.inDocumentListener = false;
                }
            }

            private void textChanged() {
                this.updateText();
            }

            @Override
            public void propertyChange(PropertyChangeEvent pce) {
                Adapter.this.uninstallDocumentListener();
                Adapter.this.document = Adapter.this.component.getDocument();
                Adapter.this.installDocumentListener();
                this.updateText();
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.updateText();
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (!e.isTemporary()) {
                    this.updateText();
                }
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.documentTextChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.documentTextChanged();
            }

            @Override
            public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
                super.replace(fb, offset, length, text, attrs);
                this.textChanged();
            }

            @Override
            public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
                super.insertString(fb, offset, string, attr);
                this.textChanged();
            }

            @Override
            public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
                super.remove(fb, offset, length);
                this.textChanged();
            }

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        }
    }
}

