/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingbinding;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.beansbinding.PropertyStateEvent;
import org.jdesktop.beansbinding.PropertyStateListener;
import org.jdesktop.swingbinding.ElementsProperty;
import org.jdesktop.swingbinding.impl.AbstractColumnBinding;
import org.jdesktop.swingbinding.impl.ListBindingManager;

public final class JComboBoxBinding<E, SS, TS>
extends AutoBinding<SS, List<E>, TS, List> {
    private Property<TS, ? extends JComboBox> comboP;
    private ElementsProperty<TS> elementsP;
    private Handler handler = new Handler();
    private JComboBox combo;
    private BindingComboBoxModel model;

    protected JComboBoxBinding(AutoBinding.UpdateStrategy strategy, SS sourceObject, Property<SS, List<E>> sourceListProperty, TS targetObject, Property<TS, ? extends JComboBox> targetJComboBoxProperty, String name) {
        super(strategy == AutoBinding.UpdateStrategy.READ_WRITE ? AutoBinding.UpdateStrategy.READ : strategy, sourceObject, sourceListProperty, targetObject, new ElementsProperty(), name);
        if (targetJComboBoxProperty == null) {
            throw new IllegalArgumentException("target JComboBox property can't be null");
        }
        this.comboP = targetJComboBoxProperty;
        this.elementsP = (ElementsProperty)this.getTargetProperty();
    }

    @Override
    protected void bindImpl() {
        this.elementsP.setAccessible(this.isComboAccessible());
        this.comboP.addPropertyStateListener(this.getTargetObject(), this.handler);
        this.elementsP.addPropertyStateListener(null, this.handler);
        super.bindImpl();
    }

    @Override
    protected void unbindImpl() {
        this.elementsP.removePropertyStateListener(null, this.handler);
        this.comboP.removePropertyStateListener(this.getTargetObject(), this.handler);
        this.elementsP.setAccessible(false);
        this.cleanupForLast();
        super.unbindImpl();
    }

    private boolean isComboAccessible() {
        return this.comboP.isReadable(this.getTargetObject()) && this.comboP.getValue(this.getTargetObject()) != null;
    }

    private boolean isComboAccessible(Object value) {
        return value != null && value != PropertyStateEvent.UNREADABLE;
    }

    private void cleanupForLast() {
        if (this.combo == null) {
            return;
        }
        this.combo.setSelectedItem(null);
        this.combo.setModel(new DefaultComboBoxModel());
        this.model.updateElements(null, this.combo.isEditable());
        this.combo = null;
        this.model = null;
    }

    private final class BindingComboBoxModel
    extends ListBindingManager
    implements ComboBoxModel {
        private final List<ListDataListener> listeners = new CopyOnWriteArrayList<ListDataListener>();
        private Object selectedItem = null;
        private int selectedModelIndex = -1;

        public void updateElements(List<?> elements, boolean isEditable) {
            this.setElements(elements, false);
            if (!isEditable || this.selectedModelIndex != -1) {
                this.selectedItem = null;
                this.selectedModelIndex = -1;
            }
            if (this.size() <= 0) {
                if (this.selectedModelIndex != -1) {
                    this.selectedModelIndex = -1;
                    this.selectedItem = null;
                }
            } else if (this.selectedItem == null) {
                this.selectedModelIndex = 0;
                this.selectedItem = this.getElementAt(this.selectedModelIndex);
            }
            this.allChanged();
        }

        @Override
        protected AbstractColumnBinding[] getColBindings() {
            return new AbstractColumnBinding[0];
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedItem;
        }

        @Override
        public void setSelectedItem(Object item) {
            if (this.selectedItem != null && !this.selectedItem.equals(item) || this.selectedItem == null && item != null) {
                this.selectedItem = item;
                this.contentsChanged(-1, -1);
                this.selectedModelIndex = -1;
                if (item != null) {
                    int size = this.size();
                    for (int i = 0; i < size; ++i) {
                        if (!item.equals(this.getElementAt(i))) continue;
                        this.selectedModelIndex = i;
                        break;
                    }
                }
            }
        }

        @Override
        protected void allChanged() {
            this.contentsChanged(0, this.size());
        }

        @Override
        protected void valueChanged(int row, int column) {
        }

        @Override
        protected void added(int index, int length) {
            assert (length > 0);
            ListDataEvent e = new ListDataEvent(this, 1, index, index + length - 1);
            int size = this.listeners.size();
            for (int i = size - 1; i >= 0; --i) {
                this.listeners.get(i).intervalAdded(e);
            }
            if (this.size() == length && this.selectedItem == null) {
                this.setSelectedItem(this.getElementAt(0));
            }
        }

        @Override
        protected void removed(int index, int length) {
            assert (length > 0);
            ListDataEvent e = new ListDataEvent(this, 2, index, index + length - 1);
            int size = this.listeners.size();
            for (int i = size - 1; i >= 0; --i) {
                this.listeners.get(i).intervalRemoved(e);
            }
            if (this.selectedModelIndex >= index && this.selectedModelIndex < index + length) {
                if (this.size() == 0) {
                    this.setSelectedItem(null);
                } else {
                    this.setSelectedItem(this.getElementAt(Math.max(index - 1, 0)));
                }
            }
        }

        @Override
        protected void changed(int row) {
            this.contentsChanged(row, row);
        }

        private void contentsChanged(int row0, int row1) {
            ListDataEvent e = new ListDataEvent(this, 0, row0, row1);
            int size = this.listeners.size();
            for (int i = size - 1; i >= 0; --i) {
                this.listeners.get(i).contentsChanged(e);
            }
        }

        @Override
        public Object getElementAt(int index) {
            return this.getElement(index);
        }

        @Override
        public void addListDataListener(ListDataListener l) {
            this.listeners.add(l);
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
            this.listeners.remove(l);
        }

        @Override
        public int getSize() {
            return this.size();
        }
    }

    private class Handler
    implements PropertyStateListener {
        private Handler() {
        }

        @Override
        public void propertyStateChanged(PropertyStateEvent pse) {
            if (!pse.getValueChanged()) {
                return;
            }
            if (pse.getSourceProperty() == JComboBoxBinding.this.comboP) {
                JComboBoxBinding.this.cleanupForLast();
                boolean wasAccessible = JComboBoxBinding.this.isComboAccessible(pse.getOldValue());
                boolean isAccessible = JComboBoxBinding.this.isComboAccessible(pse.getNewValue());
                if (wasAccessible != isAccessible) {
                    JComboBoxBinding.this.elementsP.setAccessible(isAccessible);
                } else if (JComboBoxBinding.this.elementsP.isAccessible()) {
                    JComboBoxBinding.this.elementsP.setValueAndIgnore(null, null);
                }
            } else {
                if (((ElementsProperty.ElementsPropertyStateEvent)pse).shouldIgnore()) {
                    return;
                }
                if (JComboBoxBinding.this.combo == null) {
                    JComboBoxBinding.this.combo = JComboBoxBinding.this.comboP.getValue(JComboBoxBinding.this.getTargetObject());
                    JComboBoxBinding.this.combo.setSelectedItem(null);
                    JComboBoxBinding.this.model = new BindingComboBoxModel();
                    JComboBoxBinding.this.combo.setModel(JComboBoxBinding.this.model);
                }
                JComboBoxBinding.this.model.updateElements((List)pse.getNewValue(), JComboBoxBinding.this.combo.isEditable());
            }
        }
    }
}

