/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonpatch;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.github.fge.jsonpatch.JsonPatch;
import com.github.fge.jsonpatch.JsonPatchFactory;
import java.io.IOException;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.Test;

public class JsonPatchFactoryTest {
    @Test
    public void getReaderReturnsTheReaderFromTheMapper() {
        ObjectMapper mapper = (ObjectMapper)Mockito.mock(ObjectMapper.class);
        ObjectReader reader = (ObjectReader)Mockito.mock(ObjectReader.class);
        Mockito.when((Object)mapper.reader()).thenReturn((Object)reader);
        JsonPatchFactory factory = new JsonPatchFactory(mapper);
        Assert.assertSame((Object)reader, (Object)factory.getReader());
    }

    @Test
    public void getWriterReturnsTheWriterFromTheMapper() {
        ObjectMapper mapper = (ObjectMapper)Mockito.mock(ObjectMapper.class);
        ObjectWriter writer = (ObjectWriter)Mockito.mock(ObjectWriter.class);
        Mockito.when((Object)mapper.writer()).thenReturn((Object)writer);
        JsonPatchFactory factory = new JsonPatchFactory(mapper);
        Assert.assertSame((Object)writer, (Object)factory.getWriter());
    }

    @Test
    public void fromJsonParsesIntoJsonPatch() throws IOException {
        ObjectMapper mapper = (ObjectMapper)Mockito.mock(ObjectMapper.class);
        ObjectReader reader = (ObjectReader)Mockito.mock(ObjectReader.class);
        ObjectReader readerWithType = (ObjectReader)Mockito.mock(ObjectReader.class);
        JsonNode node = (JsonNode)Mockito.mock(JsonNode.class);
        JsonPatch patch = (JsonPatch)Mockito.mock(JsonPatch.class);
        Mockito.when((Object)mapper.reader()).thenReturn((Object)reader);
        Mockito.when((Object)reader.withType(JsonPatch.class)).thenReturn((Object)readerWithType);
        Mockito.when((Object)readerWithType.readValue((JsonNode)Mockito.any(JsonNode.class))).thenReturn((Object)patch);
        JsonPatchFactory factory = new JsonPatchFactory(mapper);
        Assert.assertSame((Object)patch, (Object)factory.fromJson(node));
    }
}

