/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonpatch;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.TextNode;
import com.github.fge.jackson.JacksonUtils;
import com.github.fge.jsonpatch.JsonPatch;
import com.github.fge.jsonpatch.JsonPatchException;
import com.github.fge.jsonpatch.JsonPatchMessages;
import com.github.fge.jsonpatch.operation.JsonPatchOperation;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.github.fge.msgsimple.load.MessageBundles;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public final class JsonPatchTest {
    protected static final MessageBundle BUNDLE = MessageBundles.getBundle(JsonPatchMessages.class);
    protected static final JsonNodeFactory FACTORY = JacksonUtils.nodeFactory();
    protected JsonPatchOperation op1;
    protected JsonPatchOperation op2;

    @BeforeMethod
    public void init() {
        this.op1 = (JsonPatchOperation)Mockito.mock(JsonPatchOperation.class);
        this.op2 = (JsonPatchOperation)Mockito.mock(JsonPatchOperation.class);
    }

    @Test
    public void nullInputsDuringBuildAreRejected() throws IOException {
        try {
            JsonPatch.fromJson(null);
            Assert.fail((String)"No exception thrown!!");
        }
        catch (NullPointerException e) {
            Assert.assertEquals((String)e.getMessage(), (String)BUNDLE.getMessage("jsonPatch.nullInput"));
        }
    }

    @Test
    public void cannotPatchNull() throws JsonPatchException {
        JsonPatch patch = new JsonPatch((List)ImmutableList.of((Object)this.op1, (Object)this.op2));
        try {
            patch.apply(null);
            Assert.fail((String)"No exception thrown!!");
        }
        catch (NullPointerException e) {
            Assert.assertEquals((String)e.getMessage(), (String)BUNDLE.getMessage("jsonPatch.nullInput"));
        }
    }

    @Test
    public void operationsAreCalledInOrder() throws JsonPatchException {
        TextNode node1 = FACTORY.textNode("hello");
        TextNode node2 = FACTORY.textNode("world");
        Mockito.when((Object)this.op1.apply((JsonNode)node1)).thenReturn((Object)node2);
        JsonPatch patch = new JsonPatch((List)ImmutableList.of((Object)this.op1, (Object)this.op2));
        ArgumentCaptor captor = ArgumentCaptor.forClass(JsonNode.class);
        patch.apply((JsonNode)node1);
        ((JsonPatchOperation)Mockito.verify((Object)this.op1, (VerificationMode)Mockito.only())).apply((JsonNode)Mockito.same((Object)node1));
        ((JsonPatchOperation)Mockito.verify((Object)this.op2, (VerificationMode)Mockito.only())).apply((JsonNode)captor.capture());
        Assert.assertSame((Object)captor.getValue(), (Object)node2);
    }

    @Test
    public void whenOneOperationFailsNextOperationIsNotCalled() throws JsonPatchException {
        String message = "foo";
        Mockito.when((Object)this.op1.apply((JsonNode)Mockito.any(JsonNode.class))).thenThrow(new Throwable[]{new JsonPatchException("foo")});
        JsonPatch patch = new JsonPatch((List)ImmutableList.of((Object)this.op1, (Object)this.op2));
        try {
            patch.apply((JsonNode)FACTORY.nullNode());
            Assert.fail((String)"No exception thrown!!");
        }
        catch (JsonPatchException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"foo");
        }
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.op2});
    }
}

