/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonpatch;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectReader;
import com.github.fge.jackson.JsonLoader;
import com.github.fge.jsonpatch.JsonPatch;
import com.github.fge.jsonpatch.JsonPatchException;
import com.github.fge.jsonpatch.JsonPatchFactory;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test
public abstract class JsonPatchTestSuite {
    protected final JsonNode testNode;
    protected final ObjectReader reader;

    public JsonPatchTestSuite(String directory, JsonPatchFactory factory) throws IOException {
        this.testNode = JsonLoader.fromResource((String)("/jsonpatch/" + directory + "/testsuite.json"));
        this.reader = factory.getReader().withType(JsonPatch.class);
    }

    @DataProvider
    public Iterator<Object[]> getTests() throws IOException, JsonPatchException {
        ArrayList list = Lists.newArrayList();
        for (JsonNode element : this.testNode) {
            if (!element.has("patch")) continue;
            JsonPatch patch = (JsonPatch)this.reader.readValue(element.get("patch"));
            JsonNode source = element.get("doc");
            JsonNode expected = element.get("expected");
            if (expected == null) {
                expected = source;
            }
            boolean valid = !element.has("error");
            list.add(new Object[]{source, patch, expected, valid});
        }
        return list.iterator();
    }

    @Test(dataProvider="getTests")
    public void testsFromTestSuitePass(JsonNode source, JsonPatch patch, JsonNode expected, boolean valid) {
        block3: {
            try {
                JsonNode actual = patch.apply(source);
                if (!valid) {
                    Assert.fail((String)"Test was expected to fail!!");
                }
                Assert.assertTrue((boolean)actual.equals((Object)expected));
            }
            catch (JsonPatchException ignored) {
                if (!valid) break block3;
                Assert.fail((String)"Test was expected to succeed!!");
            }
        }
    }
}

