/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonpatch.diff;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.JsonLoader;
import com.github.fge.jackson.JsonNumEquals;
import com.github.fge.jsonpatch.JsonPatch;
import com.github.fge.jsonpatch.JsonPatchException;
import com.github.fge.jsonpatch.diff.JsonDiff;
import com.google.common.base.Equivalence;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public final class JsonDiffTest {
    protected static final Equivalence<JsonNode> EQUIVALENCE = JsonNumEquals.getInstance();
    protected final JsonNode testData;

    public JsonDiffTest() throws IOException {
        String resource = "/jsonpatch/diff/diff.json";
        this.testData = JsonLoader.fromResource((String)"/jsonpatch/diff/diff.json");
    }

    @DataProvider
    public Iterator<Object[]> getPatchesOnly() {
        ArrayList list = Lists.newArrayList();
        for (JsonNode node : this.testData) {
            list.add(new Object[]{node.get("first"), node.get("second")});
        }
        return list.iterator();
    }

    @Test(dataProvider="getPatchesOnly")
    public void generatedPatchAppliesCleanly(JsonNode first, JsonNode second) throws JsonPatchException {
        JsonPatch patch = JsonDiff.asJsonPatch((JsonNode)first, (JsonNode)second);
        Predicate predicate = EQUIVALENCE.equivalentTo((Object)second);
        JsonNode actual = patch.apply(first);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)predicate.apply((Object)actual)).overridingErrorMessage("Generated patch failed to apply\nexpected: %s\nactual: %s", new Object[]{second, actual})).isTrue();
    }

    @DataProvider
    public Iterator<Object[]> getLiteralPatches() {
        ArrayList list = Lists.newArrayList();
        for (JsonNode node : this.testData) {
            if (!node.has("patch")) continue;
            list.add(new Object[]{node.get("message").textValue(), node.get("first"), node.get("second"), node.get("patch")});
        }
        return list.iterator();
    }

    @Test(dataProvider="getLiteralPatches", dependsOnMethods={"generatedPatchAppliesCleanly"})
    public void generatedPatchesAreWhatIsExpected(String message, JsonNode first, JsonNode second, JsonNode expected) {
        JsonNode actual = JsonDiff.asJson((JsonNode)first, (JsonNode)second);
        Predicate predicate = EQUIVALENCE.equivalentTo((Object)expected);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)predicate.apply((Object)actual)).overridingErrorMessage("patch is not what was expected\nscenario: %s\nexpected: %s\nactual: %s\n", new Object[]{message, expected, actual})).isTrue();
    }
}

