/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonpatch.diff;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.fge.jackson.JacksonUtils;
import com.github.fge.jackson.JsonLoader;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonpatch.diff.JsonDiff;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public final class UnchangedTest {
    protected static final ObjectMapper MAPPER = JacksonUtils.newMapper();
    protected static final TypeReference<Map<JsonPointer, JsonNode>> TYPE_REF = new TypeReference<Map<JsonPointer, JsonNode>>(){};
    protected final JsonNode testData;

    public UnchangedTest() throws IOException {
        String resource = "/jsonpatch/diff/unchanged.json";
        this.testData = JsonLoader.fromResource((String)"/jsonpatch/diff/unchanged.json");
    }

    @DataProvider
    public Iterator<Object[]> getTestData() throws IOException {
        ArrayList list = Lists.newArrayList();
        for (JsonNode node : this.testData) {
            list.add(new Object[]{node.get("first"), node.get("second"), MAPPER.readValue(node.get("unchanged").traverse(), TYPE_REF)});
        }
        return list.iterator();
    }

    @Test(dataProvider="getTestData")
    public void computeUnchangedValuesWorks(JsonNode first, JsonNode second, Map<JsonPointer, JsonNode> expected) {
        Map actual = JsonDiff.getUnchangedValues((JsonNode)first, (JsonNode)second);
        Assert.assertEquals((Map)actual, expected);
    }
}

