/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonpatch.mergepatch;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.github.fge.jackson.JsonLoader;
import com.github.fge.jackson.JsonNumEquals;
import com.github.fge.jsonpatch.JsonPatchException;
import com.github.fge.jsonpatch.JsonPatchMessages;
import com.github.fge.jsonpatch.mergepatch.JsonMergePatch;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.github.fge.msgsimple.load.MessageBundles;
import com.google.common.base.Equivalence;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public final class NonObjectMergePatchTest {
    protected static final Equivalence<JsonNode> EQUIVALENCE = JsonNumEquals.getInstance();
    protected static final MessageBundle BUNDLE = MessageBundles.getBundle(JsonPatchMessages.class);
    protected final JsonNode testData;

    public NonObjectMergePatchTest() throws IOException {
        String resource = "/jsonpatch/mergepatch/patch-nonobject.json";
        this.testData = JsonLoader.fromResource((String)"/jsonpatch/mergepatch/patch-nonobject.json");
    }

    @Test
    public void patchYellsOnNullInput() throws JsonPatchException {
        try {
            JsonMergePatch.fromJson((JsonNode)JsonNodeFactory.instance.arrayNode()).apply(null);
            Assert.fail((String)"No exception thrown!");
        }
        catch (NullPointerException e) {
            Assert.assertEquals((String)e.getMessage(), (String)BUNDLE.getMessage("jsonPatch.nullValue"));
        }
    }

    @DataProvider
    public Iterator<Object[]> getData() {
        ArrayList list = Lists.newArrayList();
        for (JsonNode node : this.testData) {
            list.add(new Object[]{node.get("patch"), node.get("victim")});
        }
        return list.iterator();
    }

    @Test(dataProvider="getData")
    public void patchingWorksAsExpected(JsonNode input, JsonNode victim) throws JsonPatchException {
        JsonMergePatch patch = JsonMergePatch.fromJson((JsonNode)input);
        JsonNode patched = patch.apply(victim);
        Assert.assertTrue((boolean)EQUIVALENCE.equivalent((Object)input, (Object)patched));
    }
}

