/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonpatch.mergepatch;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.fge.jackson.JacksonUtils;
import com.github.fge.jackson.JsonLoader;
import com.github.fge.jackson.JsonNumEquals;
import com.github.fge.jsonpatch.mergepatch.JsonMergePatch;
import com.github.fge.jsonpatch.mergepatch.NonObjectMergePatch;
import com.github.fge.jsonpatch.mergepatch.ObjectMergePatch;
import com.google.common.base.Equivalence;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public final class SerializationTest {
    protected static final Equivalence<JsonNode> EQUIVALENCE = JsonNumEquals.getInstance();
    protected final ObjectMapper mapper = JacksonUtils.newMapper();
    protected final JsonNode nonObjectTestData;
    protected final JsonNode objectTestData;

    public SerializationTest() throws IOException {
        String resource1 = "/jsonpatch/mergepatch/serdeser-nonobject.json";
        String resource2 = "/jsonpatch/mergepatch/serdeser-object.json";
        this.nonObjectTestData = JsonLoader.fromResource((String)"/jsonpatch/mergepatch/serdeser-nonobject.json");
        this.objectTestData = JsonLoader.fromResource((String)"/jsonpatch/mergepatch/serdeser-object.json");
    }

    @DataProvider
    public Iterator<Object[]> getNonObjectInputs() {
        ArrayList list = Lists.newArrayList();
        for (JsonNode node : this.nonObjectTestData) {
            list.add(new Object[]{node});
        }
        return list.iterator();
    }

    @Test(dataProvider="getNonObjectInputs")
    public void nonObjectSerDeserWorksCorrectly(JsonNode input) throws IOException {
        String in = input.toString();
        JsonMergePatch deserialized = (JsonMergePatch)this.mapper.readValue(in, JsonMergePatch.class);
        Assert.assertNotNull((Object)deserialized);
        Assert.assertSame(deserialized.getClass(), NonObjectMergePatch.class);
        String out = this.mapper.writeValueAsString((Object)deserialized);
        JsonNode serialized = JacksonUtils.getReader().readTree(out);
        Assert.assertTrue((boolean)EQUIVALENCE.equivalent((Object)input, (Object)serialized));
    }

    @DataProvider
    public Iterator<Object[]> getObjectInputs() {
        ArrayList list = Lists.newArrayList();
        for (JsonNode node : this.objectTestData) {
            list.add(new Object[]{node});
        }
        return list.iterator();
    }

    @Test(dataProvider="getObjectInputs")
    public void objectSerDeserWorksCorrectly(JsonNode input) throws IOException {
        String in = input.toString();
        JsonMergePatch deserialized = (JsonMergePatch)this.mapper.readValue(in, JsonMergePatch.class);
        Assert.assertNotNull((Object)deserialized);
        Assert.assertSame(deserialized.getClass(), ObjectMergePatch.class);
        String out = this.mapper.writeValueAsString((Object)deserialized);
        JsonNode serialized = JacksonUtils.getReader().readTree(out);
        Assert.assertTrue((boolean)EQUIVALENCE.equivalent((Object)input, (Object)serialized));
    }
}

