/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonpatch.operation;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectReader;
import com.github.fge.jackson.JsonLoader;
import com.github.fge.jackson.JsonNumEquals;
import com.github.fge.jsonpatch.JsonPatchException;
import com.github.fge.jsonpatch.JsonPatchFactory;
import com.github.fge.jsonpatch.JsonPatchMessages;
import com.github.fge.jsonpatch.operation.JsonPatchOperation;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.github.fge.msgsimple.load.MessageBundles;
import com.google.common.base.Equivalence;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test
public abstract class JsonPatchOperationTest {
    protected static final MessageBundle BUNDLE = MessageBundles.getBundle(JsonPatchMessages.class);
    protected static final Equivalence<JsonNode> EQUIVALENCE = JsonNumEquals.getInstance();
    protected final JsonNode errors;
    protected final JsonNode ops;
    protected final ObjectReader reader;

    protected JsonPatchOperationTest(String directoryName, String operationName, JsonPatchFactory factory) throws IOException {
        String resource = "/jsonpatch/" + directoryName + "/" + operationName + ".json";
        JsonNode node = JsonLoader.fromResource((String)resource);
        this.errors = node.get("errors");
        this.ops = node.get("ops");
        this.reader = factory.getReader().withType(JsonPatchOperation.class);
    }

    @DataProvider
    public final Iterator<Object[]> getErrors() throws NoSuchFieldException, IllegalAccessException {
        ArrayList list = Lists.newArrayList();
        for (JsonNode node : this.errors) {
            list.add(new Object[]{node.get("op"), node.get("node"), BUNDLE.getMessage(node.get("message").textValue())});
        }
        return list.iterator();
    }

    @Test(dataProvider="getErrors")
    public final void errorsAreCorrectlyReported(JsonNode patch, JsonNode node, String message) throws IOException, JsonPatchException {
        JsonPatchOperation op = (JsonPatchOperation)this.reader.readValue(patch);
        try {
            op.apply(node);
            Assert.fail((String)"No exception thrown!!");
        }
        catch (JsonPatchException e) {
            Assert.assertEquals((String)e.getMessage(), (String)message);
        }
    }

    @DataProvider
    public final Iterator<Object[]> getOps() {
        ArrayList list = Lists.newArrayList();
        for (JsonNode node : this.ops) {
            list.add(new Object[]{node.get("op"), node.get("node"), node.get("expected")});
        }
        return list.iterator();
    }

    @Test(dataProvider="getOps")
    public final void operationsYieldExpectedResults(JsonNode patch, JsonNode node, JsonNode expected) throws IOException, JsonPatchException {
        JsonPatchOperation op = (JsonPatchOperation)this.reader.readValue(patch);
        JsonNode actual = op.apply(node);
        Assert.assertTrue((boolean)EQUIVALENCE.equivalent((Object)actual, (Object)expected), (String)("patched node differs from expectations: expected " + String.valueOf(expected) + " but found " + String.valueOf(actual)));
        if (EQUIVALENCE.equivalent((Object)node, (Object)actual) && node.isContainerNode()) {
            Assert.assertNotSame((Object)node, (Object)actual, (String)"operation didn't make a copy of the input node");
        }
    }
}

