/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonpatch.operation;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.JacksonUtils;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonpatch.JsonPatchException;
import com.github.fge.jsonpatch.operation.ExtendedJsonPatchOperationTest;
import com.github.fge.jsonpatch.operation.OmitOperation;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public final class OmitOperationTest
extends ExtendedJsonPatchOperationTest {
    public OmitOperationTest() throws IOException {
        super("omit");
    }

    @DataProvider
    public final Iterator<Object[]> getNodesForMissingNodeTest() {
        ArrayList list = Lists.newArrayList();
        list.add(new Object[]{JacksonUtils.nodeFactory().objectNode().put("foo", "bar")});
        list.add(new Object[]{JacksonUtils.nodeFactory().arrayNode().add("foo")});
        list.add(new Object[]{JacksonUtils.nodeFactory().nullNode()});
        list.add(new Object[]{JacksonUtils.nodeFactory().textNode("foo")});
        list.add(new Object[]{JacksonUtils.nodeFactory().numberNode(123)});
        return list.iterator();
    }

    @Test(dataProvider="getNodesForMissingNodeTest")
    public void omittingRootWithMatchingValueReturnsMissingNode(JsonNode node) throws JsonPatchException {
        OmitOperation op = new OmitOperation(JsonPointer.empty(), node);
        JsonNode ret = op.apply(node);
        Assert.assertTrue((boolean)ret.isMissingNode());
    }
}

