/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonpatch.serialization;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.github.fge.jackson.JacksonUtils;
import com.github.fge.jackson.JsonLoader;
import com.github.fge.jackson.JsonNumEquals;
import com.github.fge.jsonpatch.JsonPatch;
import com.github.fge.jsonpatch.JsonPatchException;
import com.github.fge.jsonpatch.JsonPatchFactory;
import com.google.common.base.Equivalence;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test
public abstract class JsonPatchOperationSerializationTest {
    protected static final Equivalence<JsonNode> EQUIVALENCE = JsonNumEquals.getInstance();
    protected final JsonNode node;
    protected final ObjectReader reader;
    protected final ObjectWriter writer;

    protected JsonPatchOperationSerializationTest(String directoryName, String operationName, JsonPatchFactory factory) throws IOException {
        String resource = "/jsonpatch/" + directoryName + "/" + operationName + ".json";
        this.node = JsonLoader.fromResource((String)resource);
        this.reader = factory.getReader();
        this.writer = factory.getWriter();
    }

    @DataProvider
    public final Iterator<Object[]> getInputs() {
        ArrayList list = Lists.newArrayList();
        for (JsonNode n : this.node.get("errors")) {
            list.add(new Object[]{n.get("op")});
        }
        for (JsonNode n : this.node.get("ops")) {
            list.add(new Object[]{n.get("op")});
        }
        return list.iterator();
    }

    @Test(dataProvider="getInputs")
    public final void patchOperationSerializationWorks(JsonNode input) throws IOException, JsonPatchException {
        ArrayNode patchWithOpNode = JacksonUtils.nodeFactory().arrayNode().add(input);
        String in = patchWithOpNode.toString();
        JsonPatch patchWithOp = (JsonPatch)this.reader.withType(JsonPatch.class).readValue(in);
        String out = this.writer.writeValueAsString((Object)patchWithOp);
        JsonNode output = this.reader.readTree(out);
        Assert.assertTrue((boolean)EQUIVALENCE.equivalent((Object)patchWithOpNode, (Object)output));
    }
}

