/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonpatch;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializable;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.github.fge.jsonpatch.JsonPatchException;
import com.github.fge.jsonpatch.JsonPatchFactory;
import com.github.fge.jsonpatch.JsonPatchMessages;
import com.github.fge.jsonpatch.StandardJsonPatchFactory;
import com.github.fge.jsonpatch.operation.JsonPatchOperation;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.github.fge.msgsimple.load.MessageBundles;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;

public class JsonPatch
implements JsonSerializable {
    protected static final MessageBundle BUNDLE = MessageBundles.getBundle(JsonPatchMessages.class);
    protected static final JsonPatchFactory JSON_PATCH_FACTORY = StandardJsonPatchFactory.create();
    protected final List<JsonPatchOperation> operations;

    @JsonCreator
    public JsonPatch(List<JsonPatchOperation> operations) {
        this.operations = ImmutableList.copyOf(operations);
    }

    @Deprecated
    public static JsonPatch fromJson(JsonNode node) throws IOException {
        BUNDLE.checkNotNull((Object)node, "jsonPatch.nullInput");
        return JSON_PATCH_FACTORY.fromJson(node);
    }

    public JsonNode apply(JsonNode node) throws JsonPatchException {
        BUNDLE.checkNotNull((Object)node, "jsonPatch.nullInput");
        JsonNode ret = node;
        for (JsonPatchOperation operation : this.operations) {
            ret = operation.apply(ret);
        }
        return ret;
    }

    public String toString() {
        return this.operations.toString();
    }

    public void serialize(JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStartArray();
        for (JsonPatchOperation op : this.operations) {
            op.serialize(jgen, provider);
        }
        jgen.writeEndArray();
    }

    public void serializeWithType(JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        this.serialize(jgen, provider);
    }

    public List<JsonPatchOperation> getOperations() {
        return this.operations;
    }
}

