/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonpatch;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.github.fge.jsonpatch.JsonPatch;
import com.github.fge.jsonpatch.JsonPatchMessages;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.github.fge.msgsimple.load.MessageBundles;
import java.io.IOException;

public class JsonPatchFactory {
    protected static final MessageBundle BUNDLE = MessageBundles.getBundle(JsonPatchMessages.class);
    protected final ObjectMapper mapper;
    protected final ObjectReader reader;
    protected final ObjectWriter writer;

    public JsonPatchFactory(ObjectMapper mapper) {
        this.mapper = mapper;
        this.reader = mapper.reader();
        this.writer = mapper.writer();
    }

    public ObjectReader getReader() {
        return this.reader;
    }

    public ObjectWriter getWriter() {
        return this.writer;
    }

    public JsonPatch fromJson(JsonNode node) throws IOException {
        BUNDLE.checkNotNull((Object)node, "jsonPatch.nullInput");
        return (JsonPatch)this.reader.withType(JsonPatch.class).readValue(node);
    }
}

