/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonpatch.diff;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonpatch.operation.AddOperation;
import com.github.fge.jsonpatch.operation.CopyOperation;
import com.github.fge.jsonpatch.operation.JsonPatchOperation;
import com.github.fge.jsonpatch.operation.MoveOperation;
import com.github.fge.jsonpatch.operation.RemoveOperation;
import com.github.fge.jsonpatch.operation.ReplaceOperation;

public class DiffOperation {
    protected final Type type;
    protected final JsonPointer from;
    protected final JsonNode oldValue;
    protected final JsonPointer path;
    protected final JsonNode value;

    public static DiffOperation add(JsonPointer path, JsonNode value) {
        return new DiffOperation(Type.ADD, null, null, path, value);
    }

    public static DiffOperation copy(JsonPointer from, JsonPointer path, JsonNode value) {
        return new DiffOperation(Type.COPY, from, null, path, value);
    }

    public static DiffOperation move(JsonPointer from, JsonNode oldValue, JsonPointer path, JsonNode value) {
        return new DiffOperation(Type.MOVE, from, oldValue, path, value);
    }

    public static DiffOperation remove(JsonPointer from, JsonNode oldValue) {
        return new DiffOperation(Type.REMOVE, from, oldValue, null, null);
    }

    public static DiffOperation replace(JsonPointer from, JsonNode oldValue, JsonNode value) {
        return new DiffOperation(Type.REPLACE, from, oldValue, null, value);
    }

    public DiffOperation(Type type, JsonPointer from, JsonNode oldValue, JsonPointer path, JsonNode value) {
        this.type = type;
        this.from = from;
        this.oldValue = oldValue;
        this.path = path;
        this.value = value;
    }

    public Type getType() {
        return this.type;
    }

    public JsonPointer getFrom() {
        return this.from;
    }

    public JsonNode getOldValue() {
        return this.oldValue;
    }

    public JsonPointer getPath() {
        return this.path;
    }

    public JsonNode getValue() {
        return this.value;
    }

    public JsonPatchOperation asJsonPatchOperation() {
        return this.type.toOperation(this);
    }

    public static enum Type {
        ADD{

            @Override
            public JsonPatchOperation toOperation(DiffOperation op) {
                return new AddOperation(op.path, op.value);
            }
        }
        ,
        COPY{

            @Override
            public JsonPatchOperation toOperation(DiffOperation op) {
                return new CopyOperation(op.from, op.path);
            }
        }
        ,
        MOVE{

            @Override
            public JsonPatchOperation toOperation(DiffOperation op) {
                return new MoveOperation(op.from, op.path);
            }
        }
        ,
        REMOVE{

            @Override
            public JsonPatchOperation toOperation(DiffOperation op) {
                return new RemoveOperation(op.from);
            }
        }
        ,
        REPLACE{

            @Override
            public JsonPatchOperation toOperation(DiffOperation op) {
                return new ReplaceOperation(op.from, op.value);
            }
        };


        public abstract JsonPatchOperation toOperation(DiffOperation var1);
    }
}

