/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonpatch.diff;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.JsonNumEquals;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonpatch.JsonPatch;
import com.github.fge.jsonpatch.diff.DiffOperation;
import com.google.common.base.Equivalence;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class DiffProcessor {
    protected static final Equivalence<JsonNode> EQUIVALENCE = JsonNumEquals.getInstance();
    protected final Map<JsonPointer, JsonNode> unchanged;
    protected final List<DiffOperation> diffs = Lists.newArrayList();

    public DiffProcessor(Map<JsonPointer, JsonNode> unchanged) {
        this.unchanged = ImmutableMap.copyOf(unchanged);
    }

    public void valueReplaced(JsonPointer pointer, JsonNode oldValue, JsonNode newValue) {
        this.diffs.add(DiffOperation.replace(pointer, oldValue, newValue));
    }

    public void valueRemoved(JsonPointer pointer, JsonNode value) {
        this.diffs.add(DiffOperation.remove(pointer, value));
    }

    public void valueAdded(JsonPointer pointer, JsonNode value) {
        int removalIndex = this.findPreviouslyRemoved(value);
        if (removalIndex != -1) {
            DiffOperation removed = this.diffs.get(removalIndex);
            this.diffs.remove(removalIndex);
            this.diffs.add(DiffOperation.move(removed.getFrom(), value, pointer, value));
            return;
        }
        JsonPointer ptr = this.findUnchangedValue(value);
        DiffOperation op = ptr != null ? DiffOperation.copy(ptr, pointer, value) : DiffOperation.add(pointer, value);
        this.diffs.add(op);
    }

    public JsonPatch getPatch() {
        ArrayList list = Lists.newArrayList();
        for (DiffOperation op : this.diffs) {
            list.add(op.asJsonPatchOperation());
        }
        return new JsonPatch(list);
    }

    @Nullable
    protected JsonPointer findUnchangedValue(JsonNode value) {
        Predicate predicate = EQUIVALENCE.equivalentTo((Object)value);
        for (Map.Entry<JsonPointer, JsonNode> entry : this.unchanged.entrySet()) {
            if (!predicate.apply((Object)entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    protected int findPreviouslyRemoved(JsonNode value) {
        Predicate predicate = EQUIVALENCE.equivalentTo((Object)value);
        for (int i = 0; i < this.diffs.size(); ++i) {
            DiffOperation op = this.diffs.get(i);
            if (op.getType() != DiffOperation.Type.REMOVE || !predicate.apply((Object)op.getOldValue())) continue;
            return i;
        }
        return -1;
    }
}

