/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonpatch.operation;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonpatch.JsonPatchException;
import com.github.fge.jsonpatch.operation.AddOperation;
import com.github.fge.jsonpatch.operation.DualPathOperation;
import com.github.fge.jsonpatch.operation.RemoveOperation;

public class MoveOperation
extends DualPathOperation {
    public static final String OPERATION_NAME = "move";

    @JsonCreator
    public MoveOperation(@JsonProperty(value="from") JsonPointer from, @JsonProperty(value="path") JsonPointer path) {
        super(OPERATION_NAME, from, path);
    }

    @Override
    public JsonNode apply(JsonNode node) throws JsonPatchException {
        if (this.from.equals((Object)this.path)) {
            return node.deepCopy();
        }
        JsonNode movedNode = (JsonNode)this.from.path((TreeNode)node);
        if (movedNode.isMissingNode()) {
            throw new JsonPatchException(BUNDLE.getMessage("jsonPatch.noSuchPath"));
        }
        RemoveOperation remove = new RemoveOperation(this.from);
        AddOperation add = new AddOperation(this.path, movedNode);
        return add.apply(remove.apply(node));
    }
}

