/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * DMSPanel.java
 *
 * Created on 16. März 2007, 12:00
 */
package de.cismet.lagis.gui.panels;

import org.apache.log4j.Logger;

import java.util.Collection;

import javax.swing.Icon;

import de.cismet.cids.custom.beans.lagis.FlurstueckCustomBean;

import de.cismet.connectioncontext.ConnectionContext;

import de.cismet.lagis.broker.LagisBroker;

import de.cismet.lagis.commons.LagisConstants;

import de.cismet.lagis.interfaces.FlurstueckChangeListener;
import de.cismet.lagis.interfaces.FlurstueckSaver;

import de.cismet.lagis.widget.AbstractWidget;

/**
 * DOCUMENT ME!
 *
 * @author   Puhl
 * @version  $Revision$, $Date$
 */
public class DMSPanel extends AbstractWidget implements FlurstueckChangeListener, FlurstueckSaver {

    //~ Static fields/initializers ---------------------------------------------

    private static final String WIDGET_NAME = "Dokumenten Panel";

    private static final Logger LOG = org.apache.log4j.Logger.getLogger(DMSPanel.class);

    //~ Instance fields --------------------------------------------------------

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private de.cismet.cids.custom.clientutils.DmsUrlsPanel dmsUrlsPanel1;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form DMSPanel.
     */
    public DMSPanel() {
        setIsCoreWidget(true);
        initComponents();
        dmsUrlsPanel1.initWithConnectionContext(ConnectionContext.createDeprecated());
    }

    //~ Methods ----------------------------------------------------------------

    @Override
    public void flurstueckChanged(final FlurstueckCustomBean newFlurstueck) {
        try {
            clearComponent();
            setCursor(java.awt.Cursor.getDefaultCursor());
            dmsUrlsPanel1.setDmsUrls((Collection)newFlurstueck.getDokumente());
            dmsUrlsPanel1.refresh();
            repaint();
        } catch (final Exception ex) {
            LOG.error("Fehler beim Flurstueckswechsel im FlurstueckPanel: ", ex);
        } finally {
            LagisBroker.getInstance().flurstueckChangeFinished(DMSPanel.this);
        }
    }

    @Override
    public void setComponentEditable(final boolean isEditable) {
        dmsUrlsPanel1.setEnabled(isEditable);
    }

    @Override
    public synchronized void clearComponent() {
        dmsUrlsPanel1.setDmsUrls(null);
        dmsUrlsPanel1.refresh();
    }

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        dmsUrlsPanel1 = new de.cismet.cids.custom.clientutils.DmsUrlsPanel(LagisConstants.DOMAIN_LAGIS);

        setLayout(new java.awt.BorderLayout());
        add(dmsUrlsPanel1, java.awt.BorderLayout.CENTER);
    } // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    public boolean isInEditMode() {
        return dmsUrlsPanel1.isEnabled();
    }

    @Override
    public void refresh(final Object refreshObject) {
    }

    @Override
    public String getWidgetName() {
        return WIDGET_NAME;
    }

    @Override
    public void updateFlurstueckForSaving(final FlurstueckCustomBean flurstueck) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Dokumente werden gespeichert");
        }
        clearComponent();
    }

    // TODO USE
    @Override
    public Icon getWidgetIcon() {
        return null;
    }
}
