/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.beans.lagis;

import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.custom.beans.lagis.BaumCustomBean;
import de.cismet.cids.custom.beans.lagis.DmsUrlCustomBean;
import de.cismet.cids.custom.beans.lagis.FlurstueckSchluesselCustomBean;
import de.cismet.cids.custom.beans.lagis.KassenzeichenCustomBean;
import de.cismet.cids.custom.beans.lagis.NutzungCustomBean;
import de.cismet.cids.custom.beans.lagis.SpielplatzCustomBean;
import de.cismet.cids.custom.beans.lagis.StrassenfrontCustomBean;
import de.cismet.cids.custom.beans.lagis.VertragCustomBean;
import de.cismet.cids.custom.beans.lagis.VerwaltungsbereichCustomBean;
import de.cismet.cids.custom.beans.lagis.VerwaltungsbereicheEintragCustomBean;
import de.cismet.cids.custom.beans.lagis.ZusatzRolleCustomBean;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.lagis.broker.LagisBroker;
import de.cismet.lagisEE.entity.basic.BasicEntity;
import de.cismet.lagisEE.entity.core.Flurstueck;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import org.apache.log4j.Logger;

public class FlurstueckCustomBean
extends BasicEntity
implements Flurstueck {
    private static final Logger LOG = Logger.getLogger(Flurstueck.class);
    private static final String[] PROPERTY_NAMES = new String[]{"id", "bemerkung", "fk_spielplatz", "fk_flurstueck_schluessel", "in_stadtbesitz", "ar_baeume", "ar_vertraege", "n_verwaltungsbereiche_eintraege", "n_dms_urls", "n_nutzungen", "n_kassenzeichen", "n_zusatz_rollen", "n_strassenfronten"};
    private Collection<FlurstueckSchluesselCustomBean> vertrag_querverweise;
    private Collection<FlurstueckSchluesselCustomBean> baum_querverweise;
    private Integer id;
    private String bemerkung;
    private SpielplatzCustomBean fk_spielplatz;
    private FlurstueckSchluesselCustomBean fk_flurstueck_schluessel;
    private Boolean in_stadtbesitz;
    private Collection<BaumCustomBean> ar_baeume;
    private Collection<VertragCustomBean> ar_vertraege;
    private Collection<VerwaltungsbereicheEintragCustomBean> n_verwaltungsbereiche_eintraege;
    private Collection<DmsUrlCustomBean> n_dms_urls;
    private Collection<NutzungCustomBean> n_nutzungen;
    private Collection<KassenzeichenCustomBean> n_kassenzeichen;
    private Collection<ZusatzRolleCustomBean> n_zusatz_rollen;
    private Collection<StrassenfrontCustomBean> n_strassenfronten;

    public static FlurstueckCustomBean createNew() {
        try {
            return (FlurstueckCustomBean)CidsBean.createNewCidsBeanFromTableName((String)"LAGIS", (String)"flurstueck");
        }
        catch (Exception ex) {
            LOG.error((Object)"error creating flurstueck bean", (Throwable)ex);
            return null;
        }
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public void setId(Integer paramInteger) {
        this.id = paramInteger;
        this.propertyChangeSupport.firePropertyChange("id", null, this.id);
    }

    @Override
    public String getBemerkung() {
        return this.bemerkung;
    }

    @Override
    public void setBemerkung(String paramString) {
        this.bemerkung = paramString;
        this.propertyChangeSupport.firePropertyChange("bemerkung", null, this.bemerkung);
    }

    public SpielplatzCustomBean getFk_spielplatz() {
        return this.fk_spielplatz;
    }

    public void setFk_spielplatz(SpielplatzCustomBean val) {
        this.fk_spielplatz = val;
        this.propertyChangeSupport.firePropertyChange("fk_spielplatz", null, this.fk_spielplatz);
    }

    public FlurstueckSchluesselCustomBean getFk_flurstueck_schluessel() {
        return this.fk_flurstueck_schluessel;
    }

    public void setFk_flurstueck_schluessel(FlurstueckSchluesselCustomBean val) {
        this.fk_flurstueck_schluessel = val;
        this.propertyChangeSupport.firePropertyChange("fk_flurstueck_schluessel", null, this.fk_flurstueck_schluessel);
    }

    public Boolean isIn_stadtbesitz() {
        return this.in_stadtbesitz;
    }

    public Boolean getIn_stadtbesitz() {
        return this.in_stadtbesitz;
    }

    public void setIn_stadtbesitz(Boolean paramBoolean) {
        this.in_stadtbesitz = paramBoolean;
        this.propertyChangeSupport.firePropertyChange("in_stadtbesitz", null, this.in_stadtbesitz);
    }

    public Collection<BaumCustomBean> getAr_baeume() {
        return this.ar_baeume;
    }

    public void setAr_baeume(Collection<BaumCustomBean> paramCollection) {
        this.ar_baeume = paramCollection;
        this.propertyChangeSupport.firePropertyChange("ar_baeume", null, this.ar_baeume);
    }

    public Collection<VertragCustomBean> getAr_vertraege() {
        return this.ar_vertraege;
    }

    public void setAr_vertraege(Collection<VertragCustomBean> paramCollection) {
        this.ar_vertraege = paramCollection;
        this.propertyChangeSupport.firePropertyChange("ar_vertraege", null, this.ar_vertraege);
    }

    public Collection<VerwaltungsbereicheEintragCustomBean> getN_verwaltungsbereiche_eintraege() {
        return this.n_verwaltungsbereiche_eintraege;
    }

    public Collection<VerwaltungsbereicheEintragCustomBean> getSortedVerwaltungsbereicheEintraege() {
        ArrayList<VerwaltungsbereicheEintragCustomBean> list = new ArrayList<VerwaltungsbereicheEintragCustomBean>();
        for (VerwaltungsbereicheEintragCustomBean eintrag : this.getN_verwaltungsbereiche_eintraege()) {
            list.add(eintrag);
        }
        Collections.sort(list, new Comparator<VerwaltungsbereicheEintragCustomBean>(){

            @Override
            public int compare(VerwaltungsbereicheEintragCustomBean o1, VerwaltungsbereicheEintragCustomBean o2) {
                if (o1.getGeaendert_am() != null) {
                    if (o2.getGeaendert_am() == null) {
                        return 1;
                    }
                    return o1.getGeaendert_am().compareTo(o2.getGeaendert_am());
                }
                return o1.getId().compareTo(o2.getId());
            }
        });
        return list;
    }

    public void setN_verwaltungsbereiche_eintraege(Collection<VerwaltungsbereicheEintragCustomBean> n_verwaltungsbereiche_eintraege) {
        Collection<VerwaltungsbereicheEintragCustomBean> old = this.n_verwaltungsbereiche_eintraege;
        this.n_verwaltungsbereiche_eintraege = n_verwaltungsbereiche_eintraege;
        this.propertyChangeSupport.firePropertyChange("n_verwaltungsbereiche_eintraege", old, this.n_verwaltungsbereiche_eintraege);
    }

    public Collection<DmsUrlCustomBean> getN_dms_urls() {
        return this.n_dms_urls;
    }

    public void setN_dms_urls(Collection<DmsUrlCustomBean> val) {
        this.n_dms_urls = val;
        this.propertyChangeSupport.firePropertyChange("n_dms_urls", null, this.n_dms_urls);
    }

    public Collection<NutzungCustomBean> getN_nutzungen() {
        return this.n_nutzungen;
    }

    public void setN_nutzungen(Collection<NutzungCustomBean> val) {
        this.n_nutzungen = val;
        this.propertyChangeSupport.firePropertyChange("n_nutzungen", null, this.n_nutzungen);
    }

    public Collection<KassenzeichenCustomBean> getN_kassenzeichen() {
        return this.n_kassenzeichen;
    }

    public void setN_kassenzeichen(Collection<KassenzeichenCustomBean> val) {
        this.n_kassenzeichen = val;
        this.propertyChangeSupport.firePropertyChange("n_kassenzeichen", null, this.n_kassenzeichen);
    }

    public Collection<ZusatzRolleCustomBean> getN_zusatz_rollen() {
        return this.n_zusatz_rollen;
    }

    public void setN_zusatz_rollen(Collection<ZusatzRolleCustomBean> n_zusatz_rollen) {
        Collection<ZusatzRolleCustomBean> old = this.n_zusatz_rollen;
        this.n_zusatz_rollen = n_zusatz_rollen;
        this.propertyChangeSupport.firePropertyChange("n_zusatz_rollen", old, this.n_zusatz_rollen);
    }

    public Collection<StrassenfrontCustomBean> getN_strassenfronten() {
        return this.n_strassenfronten;
    }

    public void setN_strassenfronten(Collection<StrassenfrontCustomBean> n_strassenfronten) {
        Collection<StrassenfrontCustomBean> old = this.n_strassenfronten;
        this.n_strassenfronten = n_strassenfronten;
        this.propertyChangeSupport.firePropertyChange("n_strassenfronten", old, this.n_strassenfronten);
    }

    public String[] getPropertyNames() {
        return PROPERTY_NAMES;
    }

    @Override
    public FlurstueckSchluesselCustomBean getFlurstueckSchluessel() {
        return this.getFk_flurstueck_schluessel();
    }

    @Override
    public void setFlurstueckSchluessel(FlurstueckSchluesselCustomBean val) {
        this.setFk_flurstueck_schluessel(val);
    }

    @Override
    public Collection<BaumCustomBean> getBaeume() {
        return this.getAr_baeume();
    }

    @Override
    public void setBaeume(Collection<BaumCustomBean> val) {
        this.setAr_baeume(val);
    }

    @Override
    public Collection<VerwaltungsbereichCustomBean> getVerwaltungsbereiche() {
        VerwaltungsbereicheEintragCustomBean[] v = this.getSortedVerwaltungsbereicheEintraege().toArray(new VerwaltungsbereicheEintragCustomBean[0]);
        if (v.length <= 0) {
            return null;
        }
        return v[v.length - 1].getN_verwaltungsbereiche();
    }

    public Collection<VerwaltungsbereicheEintragCustomBean> getVerwaltungsbereicheHistorie() {
        VerwaltungsbereicheEintragCustomBean[] v = this.getSortedVerwaltungsbereicheEintraege().toArray(new VerwaltungsbereicheEintragCustomBean[0]);
        if (v.length <= 1) {
            return Arrays.asList(new VerwaltungsbereicheEintragCustomBean[0]);
        }
        VerwaltungsbereicheEintragCustomBean[] h = new VerwaltungsbereicheEintragCustomBean[v.length - 1];
        System.arraycopy(v, 0, h, 0, h.length);
        return Arrays.asList(h);
    }

    @Override
    public void setVerwaltungsbereiche(Collection<VerwaltungsbereichCustomBean> bereiche) {
        boolean oneOrMoreChanged;
        Collection<VerwaltungsbereichCustomBean> b = this.getVerwaltungsbereiche();
        VerwaltungsbereichCustomBean[] lastBereiche = b == null ? new VerwaltungsbereichCustomBean[]{} : b.toArray(new VerwaltungsbereichCustomBean[0]);
        VerwaltungsbereichCustomBean[] currentBereiche = bereiche.toArray(new VerwaltungsbereichCustomBean[0]);
        int verwaltungsBereicheSize = b == null ? 0 : b.size();
        boolean bl = oneOrMoreChanged = bereiche.size() != verwaltungsBereicheSize;
        if (!oneOrMoreChanged) {
            for (int index = 0; index < lastBereiche.length; ++index) {
                VerwaltungsbereichCustomBean lastBereich = lastBereiche[index];
                VerwaltungsbereichCustomBean currentBereich = currentBereiche[index];
                if (lastBereich.getFk_verwaltende_dienststelle() != currentBereich.getFk_verwaltende_dienststelle()) {
                    oneOrMoreChanged = true;
                }
                if (lastBereich.getFlaeche() != null) {
                    if (lastBereich.getFlaeche() != null && !lastBereich.getFlaeche().equals(currentBereich.getFlaeche()) || currentBereich.getFlaeche() != null && !currentBereich.getFlaeche().equals(lastBereich.getFlaeche())) {
                        oneOrMoreChanged = true;
                    }
                } else {
                    lastBereich.setFlaeche(index);
                }
                Geometry lastGeometry = lastBereich.getGeometry();
                Geometry currentGeometry = currentBereich.getGeometry();
                if ((lastGeometry == null || lastGeometry.equals(currentGeometry)) && (currentGeometry == null || currentGeometry.equals(lastGeometry))) continue;
                oneOrMoreChanged = true;
            }
        }
        if (oneOrMoreChanged) {
            VerwaltungsbereicheEintragCustomBean eintrag = VerwaltungsbereicheEintragCustomBean.createNew();
            eintrag.setGeaendert_am(new Date());
            eintrag.setGeaendert_von(LagisBroker.getInstance().getAccountName());
            eintrag.getN_verwaltungsbereiche().addAll(bereiche);
            this.getN_verwaltungsbereiche_eintraege().add(eintrag);
        }
    }

    @Override
    public Collection<DmsUrlCustomBean> getDokumente() {
        return this.getN_dms_urls();
    }

    @Override
    public void setDokumente(Collection<DmsUrlCustomBean> val) {
        this.setN_dms_urls(val);
    }

    @Override
    public Collection<NutzungCustomBean> getNutzungen() {
        return this.getN_nutzungen();
    }

    @Override
    public void setNutzungen(Collection<NutzungCustomBean> val) {
        this.setN_nutzungen(val);
    }

    @Override
    public Collection<VertragCustomBean> getVertraege() {
        return this.getAr_vertraege();
    }

    @Override
    public void setVertraege(Collection<VertragCustomBean> val) {
        this.setAr_vertraege(val);
    }

    @Override
    public Collection<FlurstueckSchluesselCustomBean> getVertraegeQuerverweise() {
        return this.vertrag_querverweise;
    }

    @Override
    public void setVertraegeQuerverweise(Collection<FlurstueckSchluesselCustomBean> val) {
        this.vertrag_querverweise = val;
    }

    @Override
    public Collection<FlurstueckSchluesselCustomBean> getBaeumeQuerverweise() {
        return this.baum_querverweise;
    }

    @Override
    public void setBaeumeQuerverweise(Collection<FlurstueckSchluesselCustomBean> val) {
        this.baum_querverweise = val;
    }

    @Override
    public SpielplatzCustomBean getSpielplatz() {
        return this.getFk_spielplatz();
    }

    @Override
    public void setSpielplatz(SpielplatzCustomBean val) {
        this.setFk_spielplatz(val);
    }

    public String toString() {
        try {
            if (this.getFlurstueckSchluessel().isEchterSchluessel()) {
                if (this.getFlurstueckSchluessel().getFlurstueckNenner() != null) {
                    return this.getFlurstueckSchluessel().getGemarkung().getBezeichnung() + " " + this.getFlurstueckSchluessel().getFlur() + " " + this.getFlurstueckSchluessel().getFlurstueckZaehler() + "/" + this.getFlurstueckSchluessel().getFlurstueckNenner();
                }
                return this.getFlurstueckSchluessel().getGemarkung().getBezeichnung() + " " + this.getFlurstueckSchluessel().getFlur() + " " + this.getFlurstueckSchluessel().getFlurstueckZaehler();
            }
            return "pseudo Schluessel" + this.getFlurstueckSchluessel().getId();
        }
        catch (Exception ex) {
            String msg = "Eine oder mehrere Felder der Entit\u00e4t sind null";
            LOG.error((Object)"Eine oder mehrere Felder der Entit\u00e4t sind null", (Throwable)ex);
            return "Eine oder mehrere Felder der Entit\u00e4t sind null";
        }
    }
}

