/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.beans.lagis;

import Sirius.server.middleware.types.MetaObject;
import de.cismet.cids.custom.beans.lagis.FlurstueckArtCustomBean;
import de.cismet.cids.custom.beans.lagis.GemarkungCustomBean;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.lagis.broker.CidsBroker;
import de.cismet.lagisEE.entity.basic.BasicEntity;
import de.cismet.lagisEE.entity.core.FlurstueckSchluessel;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.log4j.Logger;

public class FlurstueckSchluesselCustomBean
extends BasicEntity
implements FlurstueckSchluessel {
    private static final Logger LOG = Logger.getLogger(FlurstueckSchluesselCustomBean.class);
    private static final String BASE_QUERY = String.format(" SELECT (SELECT id FROM cs_class WHERE table_name ILIKE '%1$s'), id FROM %1$s", "flurstueck_schluessel");
    private static final String[] PROPERTY_NAMES = new String[]{"id", "flur", "flurstueck_zaehler", "flurstueck_nenner", "ist_gesperrt", "bemerkung_sperre", "datum_entstehung", "gueltig_bis", "fk_gemarkung", "datum_letzter_stadtbesitz", "war_staedtisch", "fk_flurstueck_art", "letzter_bearbeiter", "letzte_bearbeitung"};
    private Integer id;
    private Integer flur;
    private Integer flurstueck_zaehler;
    private Integer flurstueck_nenner;
    private Boolean ist_gesperrt;
    private String bemerkung_sperre;
    private Timestamp datum_entstehung;
    private Timestamp gueltig_bis;
    private GemarkungCustomBean fk_gemarkung;
    private Timestamp datum_letzter_stadtbesitz;
    private Boolean war_staedtisch;
    private FlurstueckArtCustomBean fk_flurstueck_art;
    private String letzter_bearbeiter;
    private Timestamp letzte_bearbeitung;

    public static FlurstueckSchluesselCustomBean createNew() {
        try {
            FlurstueckSchluesselCustomBean newBean = (FlurstueckSchluesselCustomBean)CidsBean.createNewCidsBeanFromTableName((String)"LAGIS", (String)"flurstueck_schluessel");
            newBean.setIstGesperrt(false);
            return newBean;
        }
        catch (Exception ex) {
            LOG.error((Object)"error creating flurstueck_schluessel bean", (Throwable)ex);
            return null;
        }
    }

    private static FlurstueckSchluesselCustomBean retrieve(String query) {
        MetaObject[] mos = CidsBroker.getInstance().getLagisMetaObject(query);
        if (mos != null && mos.length > 0) {
            if (mos.length > 1) {
                LOG.warn((Object)("Multiple FlurstueckSchluessel -> should only be one but was " + mos.length + ". query: " + query));
                return null;
            }
            return (FlurstueckSchluesselCustomBean)mos[0].getBean();
        }
        LOG.warn((Object)("could not find FlurstueckSchluessel with query: " + query));
        return null;
    }

    public static FlurstueckSchluesselCustomBean createNewById(Integer id) {
        if (id == null) {
            throw new NullPointerException("Given id must not be null");
        }
        if (id == -1) {
            throw new IllegalArgumentException("ID -1 is not valid");
        }
        String query = BASE_QUERY + " WHERE id = " + id;
        return FlurstueckSchluesselCustomBean.retrieve(query);
    }

    public static FlurstueckSchluesselCustomBean createNewByFsKey(FlurstueckSchluessel other) {
        if (other == null) {
            throw new NullPointerException("Given FlurstueckSchluessel must not be null");
        }
        Integer flur = other.getFlur();
        Integer fsZaehler = other.getFlurstueckZaehler();
        Integer fsNenner = other.getFlurstueckNenner();
        Integer gemarkungsId = null;
        GemarkungCustomBean gemarkung = other.getGemarkung();
        if (gemarkung != null) {
            gemarkungsId = gemarkung.getId();
        }
        if (flur == null && fsZaehler == null && fsNenner == null && gemarkungsId == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(other + " is a Pseudo FlurstueckSchluessel -> return null"));
            }
            return null;
        }
        String query = BASE_QUERY + " WHERE flur " + (flur == null ? " is NULL " : " = " + flur) + " and   flurstueck_zaehler " + (fsZaehler == null ? " is NULL " : " = " + fsZaehler) + " AND   flurstueck_nenner " + (fsNenner == null ? " is NULL " : " = " + fsNenner) + " AND   fk_gemarkung " + (gemarkungsId == null ? " is NULL " : " = " + gemarkungsId);
        return FlurstueckSchluesselCustomBean.retrieve(query);
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public void setId(Integer id) {
        this.id = id;
        this.propertyChangeSupport.firePropertyChange("id", null, this.id);
    }

    @Override
    public Integer getFlur() {
        return this.flur;
    }

    @Override
    public void setFlur(Integer val) {
        this.flur = val;
        this.propertyChangeSupport.firePropertyChange("flur", null, this.flur);
    }

    public Integer getFlurstueck_zaehler() {
        return this.flurstueck_zaehler;
    }

    public void setFlurstueck_zaehler(Integer val) {
        this.flurstueck_zaehler = val;
        this.propertyChangeSupport.firePropertyChange("flurstueck_zaehler", null, this.flurstueck_zaehler);
    }

    public Integer getFlurstueck_nenner() {
        return this.flurstueck_nenner;
    }

    public void setFlurstueck_nenner(Integer val) {
        this.flurstueck_nenner = val;
        this.propertyChangeSupport.firePropertyChange("flurstueck_nenner", null, this.flurstueck_nenner);
    }

    public Boolean isIst_gesperrt() {
        return this.ist_gesperrt;
    }

    public Boolean getIst_gesperrt() {
        return this.ist_gesperrt;
    }

    public void setIst_gesperrt(Boolean val) {
        this.ist_gesperrt = val;
        this.propertyChangeSupport.firePropertyChange("ist_gesperrt", null, this.ist_gesperrt);
    }

    public String getBemerkung_sperre() {
        return this.bemerkung_sperre;
    }

    public void setBemerkung_sperre(String val) {
        this.bemerkung_sperre = val;
        this.propertyChangeSupport.firePropertyChange("bemerkung_sperre", null, this.bemerkung_sperre);
    }

    public Timestamp getDatum_entstehung() {
        return this.datum_entstehung;
    }

    public void setDatum_entstehung(Timestamp val) {
        this.datum_entstehung = val;
        this.propertyChangeSupport.firePropertyChange("datum_entstehung", null, this.datum_entstehung);
    }

    public Timestamp getGueltig_bis() {
        return this.gueltig_bis;
    }

    public void setGueltig_bis(Timestamp val) {
        this.gueltig_bis = val;
        this.propertyChangeSupport.firePropertyChange("gueltig_bis", null, this.gueltig_bis);
    }

    public GemarkungCustomBean getFk_gemarkung() {
        return this.fk_gemarkung;
    }

    public void setFk_gemarkung(GemarkungCustomBean val) {
        this.fk_gemarkung = val;
        this.propertyChangeSupport.firePropertyChange("fk_gemarkung", null, this.fk_gemarkung);
    }

    public Timestamp getDatum_letzter_stadtbesitz() {
        return this.datum_letzter_stadtbesitz;
    }

    public void setDatum_letzter_stadtbesitz(Timestamp val) {
        this.datum_letzter_stadtbesitz = val;
        this.propertyChangeSupport.firePropertyChange("datum_letzter_stadtbesitz", null, this.datum_letzter_stadtbesitz);
    }

    public Boolean isWar_staedtisch() {
        return this.war_staedtisch;
    }

    public Boolean getWar_staedtisch() {
        return this.war_staedtisch;
    }

    public void setWar_staedtisch(Boolean val) {
        this.war_staedtisch = val;
        this.propertyChangeSupport.firePropertyChange("war_staedtisch", null, this.war_staedtisch);
    }

    public FlurstueckArtCustomBean getFk_flurstueck_art() {
        return this.fk_flurstueck_art;
    }

    public void setFk_flurstueck_art(FlurstueckArtCustomBean val) {
        this.fk_flurstueck_art = val;
        this.propertyChangeSupport.firePropertyChange("fk_flurstueck_art", null, this.fk_flurstueck_art);
    }

    @Override
    public String getLetzter_bearbeiter() {
        return this.letzter_bearbeiter;
    }

    @Override
    public void setLetzter_bearbeiter(String val) {
        this.letzter_bearbeiter = val;
        this.propertyChangeSupport.firePropertyChange("letzter_bearbeiter", null, this.letzter_bearbeiter);
    }

    @Override
    public Timestamp getLetzte_bearbeitung() {
        return this.letzte_bearbeitung;
    }

    public void setLetzte_bearbeitung(Timestamp val) {
        this.letzte_bearbeitung = val;
        this.propertyChangeSupport.firePropertyChange("letzte_bearbeitung", null, this.letzte_bearbeitung);
    }

    public String[] getPropertyNames() {
        return PROPERTY_NAMES;
    }

    @Override
    public GemarkungCustomBean getGemarkung() {
        return this.getFk_gemarkung();
    }

    @Override
    public void setGemarkung(GemarkungCustomBean val) {
        this.setFk_gemarkung(val);
    }

    @Override
    public Integer getFlurstueckZaehler() {
        return this.getFlurstueck_zaehler();
    }

    @Override
    public void setFlurstueckZaehler(Integer val) {
        this.setFlurstueck_zaehler(val);
    }

    @Override
    public Integer getFlurstueckNenner() {
        return this.getFlurstueck_nenner();
    }

    @Override
    public void setFlurstueckNenner(Integer val) {
        this.setFlurstueck_nenner(val);
    }

    @Override
    public String getKeyString() {
        try {
            if (this.isEchterSchluessel()) {
                if (this.getFlurstueckNenner() != null) {
                    return this.getGemarkung().getBezeichnung() + " " + this.getFlur() + " " + this.getFlurstueckZaehler() + "/" + this.getFlurstueckNenner();
                }
                return this.getGemarkung().getBezeichnung() + " " + this.getFlur() + " " + this.getFlurstueckZaehler();
            }
            return "pseudo Schluessel" + this.getId();
        }
        catch (Exception ex) {
            String msg = "Eine oder mehrere Felder der Entit\u00e4t sind null";
            LOG.error((Object)"Eine oder mehrere Felder der Entit\u00e4t sind null", (Throwable)ex);
            return "Eine oder mehrere Felder der Entit\u00e4t sind null";
        }
    }

    @Override
    public boolean isEchterSchluessel() {
        if (this.getFlurstueckArt() != null) {
            return !"pseudo".equals(this.getFlurstueckArt().getBezeichnung());
        }
        System.out.println("Warnung eine Flurst\u00fccksart ist nicht gesetzt");
        return true;
    }

    @Override
    public boolean getIstGesperrt() {
        Boolean bool = this.getIst_gesperrt();
        return bool == null ? false : bool;
    }

    @Override
    public void setIstGesperrt(boolean val) {
        this.setIst_gesperrt(val);
    }

    @Override
    public boolean isGesperrt() {
        return this.getIst_gesperrt();
    }

    @Override
    public String getBemerkungSperre() {
        return this.getBemerkung_sperre();
    }

    @Override
    public void setBemerkungSperre(String val) {
        this.setBemerkung_sperre(val);
    }

    @Override
    public Date getEntstehungsDatum() {
        return this.getDatum_entstehung();
    }

    @Override
    public void setEntstehungsDatum(Date val) {
        if (val == null) {
            this.setDatum_entstehung(null);
        } else {
            this.setDatum_entstehung(new Timestamp(val.getTime()));
        }
    }

    @Override
    public Date getGueltigBis() {
        return this.getGueltig_bis();
    }

    @Override
    public void setGueltigBis(Date val) {
        if (val == null) {
            this.setGueltig_bis(null);
        } else {
            this.setGueltig_bis(new Timestamp(val.getTime()));
        }
    }

    @Override
    public FlurstueckArtCustomBean getFlurstueckArt() {
        return this.getFk_flurstueck_art();
    }

    @Override
    public void setFlurstueckArt(FlurstueckArtCustomBean val) {
        this.setFk_flurstueck_art(val);
    }

    @Override
    public boolean getWarStaedtisch() {
        Boolean bool = this.getWar_staedtisch();
        return bool == null ? false : bool;
    }

    @Override
    public void setWarStaedtisch(boolean var) {
        this.setWar_staedtisch(var);
    }

    @Override
    public Date getDatumLetzterStadtbesitz() {
        return this.getDatum_letzter_stadtbesitz();
    }

    @Override
    public void setDatumLetzterStadtbesitz(Date val) {
        if (val == null) {
            this.setDatum_letzter_stadtbesitz(null);
        } else {
            this.setDatum_letzter_stadtbesitz(new Timestamp(val.getTime()));
        }
    }

    @Override
    public void setLetzte_bearbeitung(Date val) {
        if (val == null) {
            this.setLetzte_bearbeitung(null);
        } else {
            this.setLetzte_bearbeitung(new Timestamp(val.getTime()));
        }
    }

    public int compareTo(Object value) {
        if (value instanceof FlurstueckSchluesselCustomBean) {
            FlurstueckSchluesselCustomBean other = (FlurstueckSchluesselCustomBean)value;
            if (other != null && other.toString() != null && this.toString() != null) {
                if (other.getFlurstueckZaehler() > this.getFlurstueckZaehler()) {
                    return -1;
                }
                if (other.getFlurstueckZaehler() < this.getFlurstueckZaehler()) {
                    return 1;
                }
                if (other.getFlurstueckNenner() != null && this.getFlurstueckNenner() != null) {
                    if (other.getFlurstueckNenner() > this.getFlurstueckNenner()) {
                        return -1;
                    }
                    if (other.getFlurstueckNenner() < this.getFlurstueckNenner()) {
                        return 1;
                    }
                    return 0;
                }
                if (other.getFlurstueckNenner() != null) {
                    return 1;
                }
                return 0;
            }
            if (this.toString() == null) {
                return -1;
            }
            return 1;
        }
        return 1;
    }

    public String toString() {
        Integer z = this.getFlurstueckZaehler();
        Integer n = this.getFlurstueckNenner();
        if (z != null && n != null) {
            return z.toString() + "/" + n.toString();
        }
        if (z != null) {
            return z.toString();
        }
        if (!this.isEchterSchluessel()) {
            return "pseudo" + this.getId();
        }
        return null;
    }
}

