/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.beans.lagis;

import de.cismet.cids.custom.beans.lagis.AnlageklasseCustomBean;
import de.cismet.cids.custom.beans.lagis.NutzungCustomBean;
import de.cismet.cids.custom.beans.lagis.NutzungsartCustomBean;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.lagis.Exception.BuchungNotInNutzungException;
import de.cismet.lagis.Exception.IllegalNutzungStateException;
import de.cismet.lagisEE.entity.basic.BasicEntity;
import de.cismet.lagisEE.entity.core.NutzungsBuchung;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.log4j.Logger;

public class NutzungBuchungCustomBean
extends BasicEntity
implements NutzungsBuchung {
    private static final Logger LOG = Logger.getLogger(NutzungBuchungCustomBean.class);
    private static final String[] PROPERTY_NAMES = new String[]{"id", "bemerkung", "flaeche", "gueltig_bis", "gueltig_von", "ist_buchwert", "quadratmeterpreis", "fk_anlageklasse", "fk_nutzung", "fk_nutzungsart"};
    private Integer id;
    private String bemerkung;
    private Integer flaeche;
    private Timestamp gueltig_bis;
    private Timestamp gueltig_von;
    private Boolean ist_buchwert;
    private Double quadratmeterpreis;
    private AnlageklasseCustomBean fk_anlageklasse;
    private NutzungCustomBean fk_nutzung;
    private NutzungsartCustomBean fk_nutzungsart;
    private boolean sollGeloeschtWerden = false;
    private NutzungCustomBean nutzung;

    public static NutzungBuchungCustomBean createNew() {
        try {
            return (NutzungBuchungCustomBean)CidsBean.createNewCidsBeanFromTableName((String)"LAGIS", (String)"nutzung_buchung");
        }
        catch (Exception ex) {
            LOG.error((Object)"error creating nutzung_buchung bean", (Throwable)ex);
            return null;
        }
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public void setId(Integer val) {
        this.id = val;
        this.propertyChangeSupport.firePropertyChange("id", null, this.id);
    }

    @Override
    public String getBemerkung() {
        return this.bemerkung;
    }

    @Override
    public void setBemerkung(String val) {
        this.bemerkung = val;
        this.propertyChangeSupport.firePropertyChange("bemerkung", null, this.bemerkung);
    }

    @Override
    public Integer getFlaeche() {
        return this.flaeche;
    }

    @Override
    public void setFlaeche(Integer val) {
        this.flaeche = val;
        this.propertyChangeSupport.firePropertyChange("flaeche", null, this.flaeche);
    }

    public Timestamp getGueltig_bis() {
        return this.gueltig_bis;
    }

    public void setGueltig_bis(Timestamp val) {
        this.gueltig_bis = val;
        this.propertyChangeSupport.firePropertyChange("gueltig_bis", null, this.gueltig_bis);
    }

    public Timestamp getGueltig_von() {
        return this.gueltig_von;
    }

    public void setGueltig_von(Timestamp val) {
        this.gueltig_von = val;
        this.propertyChangeSupport.firePropertyChange("gueltig_von", null, this.gueltig_von);
    }

    public Boolean isIst_buchwert() {
        return this.ist_buchwert;
    }

    public Boolean getIst_buchwert() {
        return this.ist_buchwert;
    }

    public void setIst_buchwert(Boolean val) {
        this.ist_buchwert = val;
        this.propertyChangeSupport.firePropertyChange("ist_buchwert", null, this.ist_buchwert);
    }

    @Override
    public Double getQuadratmeterpreis() {
        return this.quadratmeterpreis;
    }

    @Override
    public void setQuadratmeterpreis(Double val) {
        this.quadratmeterpreis = val;
        this.propertyChangeSupport.firePropertyChange("quadratmeterpreis", null, this.quadratmeterpreis);
    }

    public AnlageklasseCustomBean getFk_anlageklasse() {
        return this.fk_anlageklasse;
    }

    public void setFk_anlageklasse(AnlageklasseCustomBean val) {
        this.fk_anlageklasse = val;
        this.propertyChangeSupport.firePropertyChange("fk_anlageklasse", null, this.fk_anlageklasse);
    }

    public NutzungCustomBean getFk_nutzung() {
        return this.fk_nutzung;
    }

    public void setFk_nutzung(NutzungCustomBean val) {
        this.fk_nutzung = val;
        this.propertyChangeSupport.firePropertyChange("fk_nutzung", null, this.fk_nutzung);
    }

    public NutzungsartCustomBean getFk_nutzungsart() {
        return this.fk_nutzungsart;
    }

    public void setFk_nutzungsart(NutzungsartCustomBean val) {
        this.fk_nutzungsart = val;
        this.propertyChangeSupport.firePropertyChange("fk_nutzungsart", null, this.fk_nutzungsart);
    }

    public String[] getPropertyNames() {
        return PROPERTY_NAMES;
    }

    @Override
    public AnlageklasseCustomBean getAnlageklasse() {
        return this.getFk_anlageklasse();
    }

    @Override
    public void setAnlageklasse(AnlageklasseCustomBean val) {
        this.setFk_anlageklasse(val);
    }

    @Override
    public NutzungsartCustomBean getNutzungsart() {
        return this.getFk_nutzungsart();
    }

    @Override
    public void setNutzungsart(NutzungsartCustomBean val) {
        this.setFk_nutzungsart(val);
    }

    @Override
    public Date getGueltigbis() {
        return this.getGueltig_bis();
    }

    @Override
    public void setGueltigbis(Date val) {
        if (val == null) {
            this.setGueltig_bis(null);
        } else {
            this.setGueltig_bis(new Timestamp(val.getTime()));
        }
    }

    @Override
    public Date getGueltigvon() {
        return this.getGueltig_von();
    }

    @Override
    public void setGueltigvon(Date val) {
        if (val == null) {
            this.setGueltig_von(null);
        } else {
            this.setGueltig_von(new Timestamp(val.getTime()));
        }
    }

    @Override
    public Double getGesamtpreis() {
        if (this.getQuadratmeterpreis() != null && this.getFlaeche() != null) {
            return this.getQuadratmeterpreis() * (double)this.getFlaeche().intValue();
        }
        return null;
    }

    @Override
    public void flipBuchungsBuchwert() throws IllegalNutzungStateException, BuchungNotInNutzungException {
        if (this.getNutzung() == null) {
            throw new IllegalNutzungStateException("Buchung geh\u00f6rt zu keiner Nutzung.");
        }
        this.getNutzung().flipBuchungsBuchwertValue(this);
    }

    @Override
    public boolean isBuchwertFlippable() {
        if (this.getNutzung() != null) {
            return this.getNutzung().isBuchungFlippable(this);
        }
        return false;
    }

    @Override
    public String getPrettyString() {
        StringBuffer result = new StringBuffer();
        result.append("Anlageklasse: ");
        if (this.getAnlageklasse() != null) {
            StringBuffer stringBuffer = result.append(this.getAnlageklasse()).append("\n");
        } else {
            result.append("Keine Anlageklasse vorhanden\n");
        }
        result.append("Nutzungsart: ");
        if (this.getNutzungsart() != null) {
            result.append(this.getNutzungsart().getBezeichnung()).append("-").append(this.getNutzungsart().getSchluessel()).append("\n");
        } else {
            result.append("Keine Nutzungsart vorhanden\n");
        }
        result.append("Nutzungsart: ");
        if (this.getFlaeche() != null) {
            result.append(this.getFlaeche()).append("m\u00b2\n");
        } else {
            result.append("Keine Fl\u00e4che vorhanden\n");
        }
        result.append("Quadratmeterpreis: ");
        if (this.getQuadratmeterpreis() != null) {
            result.append(this.getQuadratmeterpreis()).append("\u20ac\n");
        } else {
            result.append("Keine Quadratmeterpreis vorhanden\n");
        }
        result.append("Gesamtpreis: ");
        if (this.getGesamtpreis() != null) {
            result.append(this.getGesamtpreis()).append("\u20ac\n");
        } else {
            result.append("Keine Gesamtpreis vorhanden\n");
        }
        return result.toString();
    }

    @Override
    public NutzungBuchungCustomBean cloneBuchung() {
        NutzungBuchungCustomBean newBuchung = NutzungBuchungCustomBean.createNew();
        newBuchung.setAnlageklasse(this.getAnlageklasse());
        newBuchung.setNutzungsart(this.getNutzungsart());
        if (this.getFlaeche() != null) {
            newBuchung.setFlaeche(this.getFlaeche());
        }
        if (this.getBemerkung() != null) {
            newBuchung.setBemerkung(this.getBemerkung());
        }
        if (this.getQuadratmeterpreis() != null) {
            newBuchung.setQuadratmeterpreis(this.getQuadratmeterpreis());
        }
        return newBuchung;
    }

    @Override
    public boolean getIstBuchwert() {
        Boolean bool = this.getIst_buchwert();
        return bool == null ? false : bool;
    }

    @Override
    public void setIstBuchwert(boolean val) {
        this.setIst_buchwert(val);
    }

    @Override
    public boolean getSollGeloeschtWerden() {
        return this.sollGeloeschtWerden;
    }

    @Override
    public void setSollGeloeschtWerden(boolean val) {
        this.sollGeloeschtWerden = val;
    }

    @Override
    public NutzungCustomBean getNutzung() {
        return this.nutzung;
    }

    @Override
    public void setNutzung(NutzungCustomBean val) {
        this.nutzung = val;
    }

    public String toString() {
        return "de.cismet.lagisEE.entity.core.NutzunBuchungg[id=" + this.getId() + "]";
    }

    protected Object clone() throws CloneNotSupportedException {
        NutzungBuchungCustomBean clone = this.cloneBuchung();
        clone.setIstBuchwert(this.getIstBuchwert());
        clone.setGueltigbis(this.getGueltigbis());
        clone.setGueltigvon(this.getGueltigvon());
        clone.setId(null);
        clone.setSollGeloeschtWerden(this.getSollGeloeschtWerden());
        clone.setNutzung(null);
        return clone;
    }
}

