/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.broker;

import Sirius.navigator.connection.ConnectionSession;
import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;
import Sirius.server.middleware.types.AbstractAttributeRepresentationFormater;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.middleware.types.MetaObjectNode;
import Sirius.server.newuser.User;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.custom.beans.lagis.AnlageklasseCustomBean;
import de.cismet.cids.custom.beans.lagis.BaumCustomBean;
import de.cismet.cids.custom.beans.lagis.BaumKategorieCustomBean;
import de.cismet.cids.custom.beans.lagis.BaumMerkmalCustomBean;
import de.cismet.cids.custom.beans.lagis.BeschlussartCustomBean;
import de.cismet.cids.custom.beans.lagis.FlurstueckArtCustomBean;
import de.cismet.cids.custom.beans.lagis.FlurstueckCustomBean;
import de.cismet.cids.custom.beans.lagis.FlurstueckHistorieCustomBean;
import de.cismet.cids.custom.beans.lagis.FlurstueckSchluesselCustomBean;
import de.cismet.cids.custom.beans.lagis.GemarkungCustomBean;
import de.cismet.cids.custom.beans.lagis.KostenartCustomBean;
import de.cismet.cids.custom.beans.lagis.MipaCustomBean;
import de.cismet.cids.custom.beans.lagis.MipaKategorieCustomBean;
import de.cismet.cids.custom.beans.lagis.MipaMerkmalCustomBean;
import de.cismet.cids.custom.beans.lagis.NutzungBuchungCustomBean;
import de.cismet.cids.custom.beans.lagis.NutzungCustomBean;
import de.cismet.cids.custom.beans.lagis.NutzungsartCustomBean;
import de.cismet.cids.custom.beans.lagis.RebeArtCustomBean;
import de.cismet.cids.custom.beans.lagis.RebeCustomBean;
import de.cismet.cids.custom.beans.lagis.VertragCustomBean;
import de.cismet.cids.custom.beans.lagis.VertragsartCustomBean;
import de.cismet.cids.custom.beans.lagis.VerwaltendeDienststelleCustomBean;
import de.cismet.cids.custom.beans.lagis.VerwaltungsbereichCustomBean;
import de.cismet.cids.custom.beans.lagis.ZusatzRolleArtCustomBean;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.statusbar.StatusBar;
import de.cismet.lagis.Exception.ActionNotSuccessfulException;
import de.cismet.lagis.Exception.ErrorInNutzungProcessingException;
import de.cismet.lagis.broker.AlreadyLockedObjectsPanel;
import de.cismet.lagis.broker.CidsBroker;
import de.cismet.lagis.broker.LockAlreadyExistsException;
import de.cismet.lagis.gui.main.LagisApp;
import de.cismet.lagis.gui.panels.VerdisCrossoverPanel;
import de.cismet.lagis.interfaces.FeatureSelectionChangedListener;
import de.cismet.lagis.interfaces.FlurstueckChangeListener;
import de.cismet.lagis.interfaces.FlurstueckChangeObserver;
import de.cismet.lagis.interfaces.FlurstueckRequester;
import de.cismet.lagis.interfaces.FlurstueckSaver;
import de.cismet.lagis.interfaces.GeometrySlotProvider;
import de.cismet.lagis.interfaces.LagisBrokerPropertyChangeListener;
import de.cismet.lagis.interfaces.Refreshable;
import de.cismet.lagis.interfaces.Resettable;
import de.cismet.lagis.interfaces.Widget;
import de.cismet.lagis.server.search.FlurstueckHistorieGraphSearch;
import de.cismet.lagis.server.search.FlurstueckHistorieGraphSearchResultItem;
import de.cismet.lagis.server.search.FlurstueckSchluesselByMipaAktenzeichenSearch;
import de.cismet.lagis.server.search.FlurstueckSchluesselByVertragAktenzeichenSearch;
import de.cismet.lagis.server.search.MiPaGeomSearch;
import de.cismet.lagis.server.search.ReBeGeomSearch;
import de.cismet.lagis.utillity.EmailConfig;
import de.cismet.lagis.utillity.GeometrySlotInformation;
import de.cismet.lagis.utillity.Message;
import de.cismet.lagis.wizard.GeometryWorker;
import de.cismet.lagis.wizard.panels.HistoricNoSucessorDialog;
import de.cismet.lagisEE.entity.core.Nutzung;
import de.cismet.lagisEE.interfaces.GeometrySlot;
import de.cismet.lagisEE.interfaces.Key;
import de.cismet.lagisEE.util.FlurKey;
import de.cismet.netutil.ProxyProperties;
import de.cismet.tools.CurrentStackTrace;
import de.cismet.tools.configuration.Configurable;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.verdis.server.search.AlkisLandparcelSearch;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeEvent;
import java.net.URL;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import net.infonode.docking.RootWindow;
import net.infonode.gui.componentpainter.ComponentPainter;
import net.infonode.gui.componentpainter.GradientComponentPainter;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.CompoundHighlighter;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.jdesktop.swingx.error.ErrorInfo;
import org.jdom.Element;

public class LagisBroker
implements FlurstueckChangeObserver,
Configurable {
    private static LagisBroker INSTANCE = null;
    private static final Logger LOG = Logger.getLogger(LagisBroker.class);
    private static final String DEFAULT_DOT_HEADER = "digraph G{\n";
    private static final Vector<Resettable> clearAndDisableListeners = new Vector();
    private static final DecimalFormat CURRENCY_FORMATTER = new DecimalFormat(",##0.00 \u00a4");
    private static final DateFormat DATE_FORMATTER = new SimpleDateFormat("dd.MM.yyyy");
    public static final Color YELLOW = new Color(231, 223, 84);
    public static final Color RED = new Color(219, 96, 96);
    public static final Color BLUE = new Color(124, 160, 221);
    public static final Color GREY = Color.LIGHT_GRAY;
    public static final int ALPHA = 255;
    public static final Color ODD_ROW_DEFAULT_COLOR = new Color(BLUE.getRed() + 113, BLUE.getGreen() + 79, BLUE.getBlue() + 14, 255);
    public static Color ODD_ROW_EDIT_COLOR = new Color(RED.getRed() + 25, RED.getGreen() + 143, RED.getBlue() + 143, 255);
    public static final Color ODD_ROW_LOCK_COLOR = new Color(YELLOW.getRed() + 23, YELLOW.getGreen() + 31, YELLOW.getBlue() + 134, 255);
    public static final Color ERROR_COLOR = RED;
    public static final Color ACCEPTED_COLOR = Color.WHITE;
    public static final Color UNKOWN_COLOR = ODD_ROW_LOCK_COLOR;
    public static final Color SUCCESSFUL_COLOR = new Color(113, 220, 109);
    public static final Color INITIAL_COLOR = Color.WHITE;
    public static final Color STADT_FILLING_COLOR = new Color(43, 106, 21);
    public static final Color ABTEILUNG_IX_FILLING_COLOR = new Color(100, 40, 106);
    public static final Color UNKNOWN_FILLING_COLOR = UNKOWN_COLOR;
    public static final Color HISTORIC_FLURSTUECK_COLOR = Color.DARK_GRAY;
    public static final Color EVEN_ROW_COLOR = Color.WHITE;
    public static final Color FOREGROUND_ROW_COLOR = Color.BLACK;
    public static Highlighter ALTERNATE_ROW_HIGHLIGHTER = HighlighterFactory.createAlternateStriping((Color)ODD_ROW_DEFAULT_COLOR, (Color)EVEN_ROW_COLOR);
    public static final Color EDIT_MODE_COLOR = RED;
    public static final Color LOCK_MODE_COLOR = YELLOW;
    public static final Color HISTORY_MODE_COLOR = GREY;
    public static final Color DEFAULT_MODE_COLOR = BLUE;
    private static final GregorianCalendar CALENDAR = new GregorianCalendar();
    private HashMap<Integer, GemarkungCustomBean> gemarkungsHashMap;
    private final Vector<Widget> widgets = new Vector();
    private FlurstueckCustomBean currentFlurstueck = null;
    private final List<CidsBean> currentLocks = new ArrayList<CidsBean>();
    private final Vector<FlurstueckChangeListener> observedFlurstueckChangedListeners = new Vector();
    private String title;
    private String totd;
    private boolean loggedIn = false;
    private MappingComponent mappingComponent;
    private RootWindow rootWindow;
    private FlurstueckSchluesselCustomBean currentFlurstueckSchluessel = null;
    private String callserverUrl;
    private String domain;
    private String connectionClass;
    private boolean compressionEnabled = false;
    private String account;
    private FlurstueckRequester requester;
    private boolean isInWfsMode = false;
    private boolean isFullReadOnlyMode = true;
    private boolean isCoreReadOnlyMode = true;
    private StatusBar statusBar;
    private ExecutorService execService = null;
    private int verdisCrossoverPort = -1;
    private Geometry currentWFSGeometry;
    private double mipaBuffer = -1.0;
    private double rebeBuffer = -1.0;
    private double kassenzeichenBuffer = -0.2;
    private double kassenzeichenBuffer100 = -0.5;
    private boolean skipSecurityCheckFlurstueckAssistent = false;
    private boolean nkfAdminPermission = false;
    private transient ConnectionSession session;
    private String currentValidationErrorMessage = null;
    private Vector<Message> messages = new Vector();
    private boolean flustueckChangeInProgress = false;
    private boolean isUnkown = false;
    private EmailConfig emailConfig;
    private Vector<String> developerMailaddresses;
    private Vector<String> nkfMailaddresses;
    private Vector<String> maintenanceMailAddresses;
    private StringBuffer nkfRecipients;
    private StringBuffer developerRecipients;
    private StringBuffer maintenanceRecipients;
    private RenderedImage historyImage;
    private final Collection<LagisBrokerPropertyChangeListener> wfsFlurstueckChangeListeners = new ArrayList<LagisBrokerPropertyChangeListener>();
    private List<RebeCustomBean> currentRebes = null;
    private List<MipaCustomBean> currentMipas = null;
    private ProxyProperties proxyProperties;

    private LagisBroker() {
        this.execService = Executors.newCachedThreadPool();
    }

    public ConnectionSession getSession() {
        return this.session;
    }

    public void setSession(ConnectionSession session) {
        this.session = session;
    }

    public static LagisBroker getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new LagisBroker();
        }
        return INSTANCE;
    }

    public boolean isCompressionEnabled() {
        return this.compressionEnabled;
    }

    public void setCompressionEnabled(boolean compressionEnabled) {
        this.compressionEnabled = compressionEnabled;
    }

    public ProxyProperties getProxyProperties() {
        return this.proxyProperties;
    }

    public void setProxyProperties(ProxyProperties proxyProperties) {
        this.proxyProperties = proxyProperties;
    }

    public List<RebeCustomBean> getRechteUndBelastungen(Geometry flurstueckGeometry) {
        try {
            ArrayList<RebeCustomBean> rebes = new ArrayList<RebeCustomBean>();
            if (flurstueckGeometry != null) {
                Geometry bufferedGeom = flurstueckGeometry.buffer(this.getRebeBuffer());
                bufferedGeom.setSRID(flurstueckGeometry.getSRID());
                Collection mons = CidsBroker.getInstance().executeSearch((CidsServerSearch)new ReBeGeomSearch((Geometry)(bufferedGeom.isEmpty() ? flurstueckGeometry.getInteriorPoint() : bufferedGeom)));
                if (mons != null) {
                    for (MetaObjectNode mon : mons) {
                        MetaObject mo;
                        CidsBean cidsBean;
                        if (mon == null || !((cidsBean = (mo = CidsBroker.getInstance().getMetaObject(mon.getObjectId(), mon.getClassId(), mon.getDomain())).getBean()) instanceof RebeCustomBean)) continue;
                        rebes.add((RebeCustomBean)cidsBean);
                    }
                }
            }
            return rebes;
        }
        catch (ConnectionException ex) {
            LOG.fatal((Object)ex, (Throwable)ex);
            return null;
        }
    }

    public List<MipaCustomBean> getMiPas(Geometry flurstueckGeometry) {
        try {
            ArrayList<MipaCustomBean> mipas = new ArrayList<MipaCustomBean>();
            if (flurstueckGeometry != null) {
                Geometry bufferedGeom = flurstueckGeometry.buffer(this.getMipaBuffer());
                bufferedGeom.setSRID(flurstueckGeometry.getSRID());
                Collection mons = CidsBroker.getInstance().executeSearch((CidsServerSearch)new MiPaGeomSearch((Geometry)(bufferedGeom.isEmpty() ? flurstueckGeometry.getInteriorPoint() : bufferedGeom)));
                if (mons != null) {
                    for (MetaObjectNode mon : mons) {
                        MetaObject mo;
                        CidsBean cidsBean;
                        if (mon == null || !((cidsBean = (mo = CidsBroker.getInstance().getMetaObject(mon.getObjectId(), mon.getClassId(), mon.getDomain())).getBean()) instanceof MipaCustomBean)) continue;
                        mipas.add((MipaCustomBean)cidsBean);
                    }
                }
            }
            return mipas;
        }
        catch (ConnectionException ex) {
            LOG.fatal((Object)ex, (Throwable)ex);
            return null;
        }
    }

    public void openKassenzeichenInVerdis(CidsBean bean) {
        if (bean != null) {
            if (this.verdisCrossoverPort < 0 || this.verdisCrossoverPort > 65535) {
                LOG.warn((Object)("Crossover: verdisCrossoverPort ist ung\u00fcltig: " + this.verdisCrossoverPort));
            } else {
                final URL verdisQuery = VerdisCrossoverPanel.createQuery(this.verdisCrossoverPort, bean);
                if (verdisQuery != null) {
                    SwingWorker<Void, Void> openKassenzeichen = new SwingWorker<Void, Void>(){

                        @Override
                        protected Void doInBackground() throws Exception {
                            verdisQuery.openStream();
                            return null;
                        }

                        @Override
                        protected void done() {
                            try {
                                this.get();
                            }
                            catch (Exception ex) {
                                LOG.error((Object)"Fehler beim \u00f6ffnen des Kassenzeichens", (Throwable)ex);
                            }
                        }
                    };
                    this.execute(openKassenzeichen);
                } else {
                    LOG.warn((Object)"Crossover: konnte keine Query anlegen. Kein Abruf der Kassenzeichen m\u00f6glich.");
                }
            }
        } else {
            LOG.warn((Object)"Crossover: Kann angebenes Flurst\u00fcck nicht \u00f6ffnwen");
        }
    }

    public RenderedImage getHistoryImage() {
        return this.historyImage;
    }

    public void setHistoryImage(RenderedImage historyImage) {
        this.historyImage = historyImage;
    }

    public boolean isNkfAdminPermission() {
        return this.nkfAdminPermission;
    }

    public void checkNKFAdminPermissionsOnServer() {
        try {
            this.nkfAdminPermission = this.getSession().getConnection().hasConfigAttr(this.getSession().getUser(), "lagis.perm.nkf.admin");
            LOG.info((Object)("NKF Admin Recht wurde gesetzt: " + this.nkfAdminPermission));
        }
        catch (Exception ex) {
            LOG.error((Object)"Fehler beim setzen der NKF Admin Rechte. Rechte wurden nicht richtig gesetzt und deshalb deaktiviert.", (Throwable)ex);
        }
    }

    public void addWidget(Widget widget) {
        this.widgets.add(widget);
    }

    public void addWidgets(List<Widget> widgets) {
        Iterator<Widget> it = widgets.iterator();
        while (it.hasNext()) {
            this.widgets.add(it.next());
        }
    }

    public void resetWidgets() {
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Lagis Broker : Reset widgets");
                    }
                    for (Widget tmp : LagisBroker.this.widgets) {
                        tmp.clearComponent();
                        tmp.setComponentEditable(false);
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Lagis Broker : Reset widgets durch");
                    }
                }
            });
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Lagis Broker : Reset widgets");
        }
        for (Widget tmp : this.widgets) {
            tmp.clearComponent();
            tmp.setComponentEditable(false);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Lagis Broker : Reset widgets durch");
        }
    }

    public synchronized void setWidgetsEditable(final boolean isEditable) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Setze Widgets editable: " + isEditable));
        }
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Iterator it = LagisBroker.this.widgets.iterator();
                    while (it.hasNext()) {
                        if (LagisBroker.this.isCurrentFlurstueckLockedByUser()) {
                            ((ColorHighlighter)((CompoundHighlighter)ALTERNATE_ROW_HIGHLIGHTER).getHighlighters()[0]).setBackground(ODD_ROW_LOCK_COLOR);
                        } else if (isEditable) {
                            ((ColorHighlighter)((CompoundHighlighter)ALTERNATE_ROW_HIGHLIGHTER).getHighlighters()[0]).setBackground(ODD_ROW_EDIT_COLOR);
                        } else {
                            ((ColorHighlighter)((CompoundHighlighter)ALTERNATE_ROW_HIGHLIGHTER).getHighlighters()[0]).setBackground(ODD_ROW_DEFAULT_COLOR);
                        }
                        if (isEditable) {
                            Widget currentWidget = (Widget)it.next();
                            if (currentWidget.isWidgetReadOnly()) continue;
                            currentWidget.setComponentEditable(isEditable);
                            continue;
                        }
                        ((Widget)it.next()).setComponentEditable(isEditable);
                    }
                }
            });
        } else {
            Iterator<Widget> it = this.widgets.iterator();
            while (it.hasNext()) {
                if (this.isCurrentFlurstueckLockedByUser()) {
                    ((ColorHighlighter)((CompoundHighlighter)ALTERNATE_ROW_HIGHLIGHTER).getHighlighters()[0]).setBackground(ODD_ROW_LOCK_COLOR);
                } else if (isEditable) {
                    ((ColorHighlighter)((CompoundHighlighter)ALTERNATE_ROW_HIGHLIGHTER).getHighlighters()[0]).setBackground(ODD_ROW_EDIT_COLOR);
                } else {
                    ((ColorHighlighter)((CompoundHighlighter)ALTERNATE_ROW_HIGHLIGHTER).getHighlighters()[0]).setBackground(ODD_ROW_DEFAULT_COLOR);
                }
                if (isEditable) {
                    Widget currentWidget = it.next();
                    if (currentWidget.isWidgetReadOnly()) continue;
                    currentWidget.setComponentEditable(isEditable);
                    continue;
                }
                it.next().setComponentEditable(isEditable);
            }
        }
    }

    public GeometrySlotInformation assignGeometry(Geometry geom) {
        Object[] openSlots = this.collectGeometrySlots();
        switch (openSlots.length) {
            case 0: {
                JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)this.mappingComponent), "Es ist kein Element vorhanden dem eine Fl\u00e4che zugeordnet werden kann\noder die entsprechenden Rechte sind nicht ausreichend", "Geometrie zuordnen", 1);
                return null;
            }
            case 1: {
                int anwser = JOptionPane.showConfirmDialog(StaticSwingTools.getParentFrame((Component)this.mappingComponent), "Es ist genau ein Element vorhanden, dem eine Fl\u00e4che zugeordnet werden kann:\n\n    " + openSlots[0] + "\n\nSoll die Geometrie diesem dem Element hinzugef\u00fcgt werden ?", "Geometrie zuordnen", 0);
                if (anwser == 0) {
                    GeometrySlot slotGeom = ((GeometrySlotInformation)openSlots[0]).getOpenSlot();
                    if (slotGeom != null) {
                        slotGeom.setGeometry(geom);
                    } else {
                        slotGeom.setGeometry(geom);
                    }
                    return openSlots[0];
                }
                return null;
            }
        }
        GeometrySlotInformation selectedSlot = (GeometrySlotInformation)JOptionPane.showInputDialog(StaticSwingTools.getParentFrame((Component)this.mappingComponent), "Bitte w\u00e4hlen Sie das Element, dem Sie die Geometrie zuordnen m\u00f6chten:\n", "Geometrie zuordnen", -1, null, openSlots, openSlots[0]);
        if (selectedSlot != null) {
            GeometrySlot slotGeom = selectedSlot.getOpenSlot();
            if (slotGeom != null) {
                slotGeom.setGeometry(geom);
            } else {
                slotGeom.setGeometry(geom);
            }
            return selectedSlot;
        }
        return null;
    }

    private GeometrySlotInformation[] collectGeometrySlots() {
        Vector<GeometrySlotInformation> openSlots = new Vector<GeometrySlotInformation>();
        for (Widget curWidget : this.widgets) {
            if (!(curWidget instanceof GeometrySlotProvider)) continue;
            openSlots.addAll(((GeometrySlotProvider)((Object)curWidget)).getSlotInformation());
        }
        return openSlots.toArray(new GeometrySlotInformation[openSlots.size()]);
    }

    public void fireChangeEvent(Object event) {
        for (Widget curWidget : this.widgets) {
            if (!(curWidget instanceof FeatureSelectionChangedListener) || !((FeatureSelectionChangedListener)((Object)curWidget)).isFeatureSelectionChangedEnabled() || !(event instanceof Collection)) continue;
            ((FeatureSelectionChangedListener)((Object)curWidget)).featureSelectionChanged((Collection)event);
        }
    }

    public static DecimalFormat getCurrencyFormatter() {
        return CURRENCY_FORMATTER;
    }

    public static DateFormat getDateFormatter() {
        return DATE_FORMATTER;
    }

    public MappingComponent getMappingComponent() {
        return this.mappingComponent;
    }

    public void setMappingComponent(MappingComponent aMappingComponent) {
        this.mappingComponent = aMappingComponent;
    }

    public boolean acquireLock() {
        if (this.currentFlurstueck != null && this.currentLocks.isEmpty()) {
            try {
                this.currentLocks.add(this.createFlurstueckSchluesselLock(this.currentFlurstueck.getFlurstueckSchluessel()));
                if (this.currentRebes != null) {
                    for (RebeCustomBean rebe : this.currentRebes) {
                        this.currentLocks.add(this.createRebeLock(rebe, this.currentFlurstueck.getFlurstueckSchluessel()));
                    }
                }
                if (this.currentMipas != null) {
                    for (MipaCustomBean mipa : this.currentMipas) {
                        this.currentLocks.add(this.createMipaLock(mipa, this.currentFlurstueck.getFlurstueckSchluessel()));
                    }
                }
                this.setWidgetsEditable(true);
                for (Feature feature : this.getMappingComponent().getFeatureCollection().getSelectedFeatures()) {
                    this.getMappingComponent().getFeatureCollection().select(feature);
                }
                return true;
            }
            catch (LockAlreadyExistsException ex) {
                this.showObjectsLockedDialog(ex.getAlreadyExisingLocks());
                return false;
            }
            catch (Exception ex) {
                this.currentLocks.clear();
                this.showError("Kein Editieren m\u00f6glich", "Beim Sperren des Datensatzes ist ein unerwarteter Fehler aufgetreten.", ex);
                return false;
            }
        }
        JOptionPane.showMessageDialog(LagisApp.getInstance(), "Kein Flurstueck ausgew\u00e4hlt oder bereits im Editiermodus.", "Kein Editieren m\u00f6glich", 2);
        return false;
    }

    public void showError(final String title, final String message, final Exception exception) {
        if (SwingUtilities.isEventDispatchThread()) {
            ErrorInfo errorInfo = new ErrorInfo(title, message, null, "", (Throwable)exception, null, null);
            JXErrorPane.showDialog((Component)LagisApp.getInstance(), (ErrorInfo)errorInfo);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        LagisBroker.this.showError(title, message, exception);
                    }
                });
            }
            catch (Exception ex) {
                LOG.error((Object)ex, (Throwable)ex);
            }
        }
    }

    public void showObjectsLockedDialog(Collection<CidsBean> locks) {
        JDialog dialog = new JDialog((Frame)null, "Gesperrte Objekte...", true);
        dialog.add(new AlreadyLockedObjectsPanel(locks));
        dialog.setResizable(false);
        dialog.pack();
        StaticSwingTools.showDialog((JDialog)dialog);
    }

    public boolean releaseLocks() {
        boolean success = this.releaseLocks(this.currentLocks);
        if (success) {
            this.currentLocks.clear();
        }
        return success;
    }

    public boolean releaseLocks(List<CidsBean> locks) {
        if (locks != null && !locks.isEmpty()) {
            for (CidsBean lock : locks) {
                if (this.releaseLock(lock)) continue;
                return false;
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"keine Sperre zum L\u00f6sen vorhanden");
            }
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Alle Sperren wurden erfolgreich gel\u00f6st");
        }
        this.setWidgetsEditable(false);
        return true;
    }

    public boolean releaseLock(CidsBean lock) {
        try {
            if (lock != null) {
                lock.delete();
                lock.persist();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Sperre erfolgreich gel\u00f6st");
                }
            } else {
                LOG.warn((Object)"Sperre war null.");
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Fehler beim l\u00f6sen der Sperre", (Throwable)ex);
            return false;
        }
        return true;
    }

    public CidsBean isLocked(FlurstueckSchluesselCustomBean key) {
        if (key != null) {
            MetaClass metaclass = CidsBroker.getInstance().getLagisMetaClass("sperre");
            if (metaclass == null) {
                return null;
            }
            String query = "SELECT " + metaclass.getID() + ", " + metaclass.getTableName() + "." + metaclass.getPrimaryKey() + " FROM " + metaclass.getTableName() + " WHERE " + metaclass.getTableName() + ".fk_flurstueck_schluessel = " + key.getId();
            MetaObject[] mos = CidsBroker.getInstance().getLagisMetaObject(query);
            if (mos != null && mos.length > 0) {
                CidsBean sperre = mos[0].getBean();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Es ist eine Sperre vorhanden und wird von: " + (String)sperre.getProperty("user_string") + " gehalten"));
                }
                return sperre;
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Flurst\u00fcckkey == null");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Es ist keine Sperre f\u00fcr das angegebne Flurst\u00fcck vorhanden");
        }
        return null;
    }

    public CidsBean createFlurstueckSchluesselLock(FlurstueckSchluesselCustomBean flurstueckSchluessel) throws Exception {
        return this.createLock(flurstueckSchluessel, this.getCurrentFlurstueckSchluessel().getKeyString() + ";-");
    }

    public CidsBean createRebeLock(RebeCustomBean rebe, FlurstueckSchluesselCustomBean flurstueckSchluessel) throws Exception {
        return this.createLock(rebe, this.getCurrentFlurstueckSchluessel().getKeyString() + ";Recht/Belastung: " + rebe.toString());
    }

    public CidsBean createMipaLock(MipaCustomBean mipa, FlurstueckSchluesselCustomBean flurstueckSchluessel) throws Exception {
        return this.createLock(mipa, this.getCurrentFlurstueckSchluessel().getKeyString() + ";Vermietung/Verpachtung: " + mipa.toString());
    }

    public CidsBean createLock(CidsBean cidsBean, String infoString) throws Exception {
        CidsBean lockBean = CidsBean.createNewCidsBeanFromTableName((String)"LAGIS", (String)"cs_locks");
        lockBean.setProperty("class_id", (Object)cidsBean.getMetaObject().getClassID());
        lockBean.setProperty("object_id", (Object)cidsBean.getMetaObject().getId());
        lockBean.setProperty("user_string", (Object)this.getAccountName());
        lockBean.setProperty("additional_info", (Object)(infoString + ";" + DATE_FORMATTER.format(new Date())));
        return this.persistLockIfNotAlreadyLocked(lockBean);
    }

    public FlurstueckCustomBean renameFlurstueck(FlurstueckSchluesselCustomBean oldFlurstueckSchluessel, FlurstueckSchluesselCustomBean newFlurstueckSchluessel, String benutzerkonto) throws ActionNotSuccessfulException {
        oldFlurstueckSchluessel.setLetzter_bearbeiter(this.getAccountName());
        newFlurstueckSchluessel.setLetzter_bearbeiter(this.getAccountName());
        oldFlurstueckSchluessel.setLetzte_bearbeitung(this.getCurrentDate());
        newFlurstueckSchluessel.setLetzte_bearbeitung(this.getCurrentDate());
        CidsBean lock = null;
        try {
            FlurstueckCustomBean oldFlurstueck;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Rename Flurst\u00fcck");
            }
            if ((oldFlurstueck = this.retrieveFlurstueck(oldFlurstueckSchluessel)) != null) {
                FlurstueckCustomBean newFlurstueck;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"AltesFlurst\u00fcck existiert");
                }
                if (this.isLocked(oldFlurstueck.getFlurstueckSchluessel()) == null) {
                    lock = this.createFlurstueckSchluesselLock(oldFlurstueck.getFlurstueckSchluessel());
                    if (lock == null) {
                        throw new ActionNotSuccessfulException("Anlegen einer Sperre f\u00fcr das alte Flurst\u00fcck nicht m\u00f6glich");
                    }
                } else {
                    throw new ActionNotSuccessfulException("Es exisitert bereits eine Sperre f\u00fcr das alte Flurst\u00fcck");
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Flurst\u00fcck wurde Historisch gesetzt");
                }
                if (!this.existHistoryEntry(oldFlurstueck)) {
                    newFlurstueck = this.createFlurstueck(newFlurstueckSchluessel);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Es exitieren kein History Eintrag --> keine Kante zu einem anderen Flurst\u00fcck");
                        LOG.debug((Object)"Kein nachfolger f\u00fcr das Flurst\u00fcck vorhanden --> Lege neues Flurstueck an");
                        LOG.debug((Object)"Erzeuge History Eintrag f\u00fcr altes Flurst\u00fcck");
                    }
                    this.createHistoryEdge(oldFlurstueck, newFlurstueck);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Neuer History Eintrag f\u00fcr Flurst\u00fcck erzeugt");
                    }
                } else {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Renamen des Flurst\u00fccks nicht m\u00f6glich");
                    }
                    this.releaseLock(lock);
                    throw new ActionNotSuccessfulException("Es existieren bereits Historieneintr\u00e4ge f\u00fcr dieses Flurst\u00fcck");
                }
                if (newFlurstueck != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Alle Aktionen f\u00fcr das umbenennen erfolgreich abgeschlossen.");
                    }
                    User user = SessionManager.getSession().getUser();
                    MetaClass mcDmsUrl = ClassCacheMultiple.getMetaClass((String)"LAGIS", (String)"dms_url");
                    MetaClass mcNutzung = ClassCacheMultiple.getMetaClass((String)"LAGIS", (String)"nutzung");
                    MetaClass mcRebe = ClassCacheMultiple.getMetaClass((String)"LAGIS", (String)"rebe");
                    MetaClass mcVerwaltungsbereichEintrag = ClassCacheMultiple.getMetaClass((String)"LAGIS", (String)"verwaltungsbereiche_eintrag");
                    String queryDmsUrl = "SELECT " + mcDmsUrl.getID() + ", " + mcDmsUrl.getPrimaryKey() + " FROM " + mcDmsUrl.getTableName() + " WHERE  fk_flurstueck = " + oldFlurstueck.getId().toString();
                    String queryNutzung = "SELECT " + mcNutzung.getID() + ", " + mcNutzung.getPrimaryKey() + " FROM " + mcNutzung.getTableName() + " WHERE  fk_flurstueck = " + oldFlurstueck.getId().toString();
                    String queryVerwaltungsbereichEintrag = "SELECT " + mcVerwaltungsbereichEintrag.getID() + ", " + mcVerwaltungsbereichEintrag.getPrimaryKey() + " FROM " + mcVerwaltungsbereichEintrag.getTableName() + " WHERE  fk_flurstueck = " + oldFlurstueck.getId().toString();
                    newFlurstueck.getAr_baeume().addAll(oldFlurstueck.getAr_baeume());
                    oldFlurstueck.getAr_baeume().clear();
                    newFlurstueck.getAr_vertraege().addAll(oldFlurstueck.getAr_vertraege());
                    oldFlurstueck.getAr_vertraege().clear();
                    for (MetaObject moDmsUrl : SessionManager.getProxy().getMetaObjectByQuery(user, queryDmsUrl)) {
                        moDmsUrl.getBean().setProperty("fk_flurstueck", (Object)newFlurstueck);
                        moDmsUrl.getBean().persist();
                    }
                    for (MetaObject moNutzung : SessionManager.getProxy().getMetaObjectByQuery(user, queryNutzung)) {
                        CidsBean nutzungCopy = LagisBroker.cloneNutzung(moNutzung.getBean(), null);
                        nutzungCopy.setProperty("historisch", (Object)false);
                        nutzungCopy.setProperty("fk_flurstueck", (Object)newFlurstueck);
                        nutzungCopy.persist();
                    }
                    this.setFlurstueckHistoric(oldFlurstueckSchluessel);
                    for (MetaObject moVerwaltungsbereichEintrag : SessionManager.getProxy().getMetaObjectByQuery(user, queryVerwaltungsbereichEintrag)) {
                        moVerwaltungsbereichEintrag.getBean().setProperty("fk_flurstueck", (Object)newFlurstueck);
                        moVerwaltungsbereichEintrag.getBean().persist();
                    }
                } else {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Das neue Flurst\u00fcck konnte nicht angelegt werden.");
                    }
                    this.releaseLock(lock);
                    throw new ActionNotSuccessfulException("Das neue Flurst\u00fcck konnte nicht angelegt werden.");
                }
                newFlurstueck.setFk_spielplatz(oldFlurstueck.getFk_spielplatz());
                newFlurstueck.setBemerkung(oldFlurstueck.getBemerkung());
                newFlurstueck.setIn_stadtbesitz(oldFlurstueck.getIn_stadtbesitz());
                newFlurstueck = (FlurstueckCustomBean)newFlurstueck.persist();
                oldFlurstueck.persist();
                this.releaseLock(lock);
                return newFlurstueck;
            }
            throw new ActionNotSuccessfulException("Altes Flurst\u00fcck existiert nicht.");
        }
        catch (ActionNotSuccessfulException ex) {
            throw ex;
        }
        catch (Exception ex) {
            LOG.error((Object)"Unbekannter Fehler beim renamen des Flurst\u00fccks.", (Throwable)ex);
            this.releaseLock(lock);
            throw new ActionNotSuccessfulException("Ein Unbekannter Ausnamefehler ist aufgetreten. Bitte wenden Sie sich an Ihren Systemadministrator", ex);
        }
    }

    public static CidsBean cloneNutzung(CidsBean bean, CidsBean parentObject) throws Exception {
        if (bean == null) {
            return null;
        }
        CidsBean clone = bean.getMetaObject().getMetaClass().getEmptyInstance().getBean();
        clone = clone.persist();
        for (String propName : bean.getPropertyNames()) {
            if (propName.toLowerCase().equals("id")) continue;
            Object o = bean.getProperty(propName);
            if (propName.equalsIgnoreCase("fk_nutzung")) {
                clone.setProperty(propName, (Object)parentObject);
                continue;
            }
            if (o instanceof CidsBean) {
                if (propName.toLowerCase().equals("fk_flurstueck") || ((CidsBean)o).getMetaObject().getMetaClass().getTableName().equalsIgnoreCase("nutzungsart") || ((CidsBean)o).getMetaObject().getMetaClass().getTableName().equalsIgnoreCase("anlageklasse")) {
                    clone.setProperty(propName, (Object)((CidsBean)o));
                    continue;
                }
                if (!((CidsBean)o).getMetaObject().getMetaClass().getTableName().equalsIgnoreCase("nutzung")) continue;
                clone.setProperty(propName, (Object)parentObject);
                continue;
            }
            if (o instanceof Collection) {
                List list = (List)o;
                ArrayList<CidsBean> newList = new ArrayList<CidsBean>();
                for (CidsBean tmpBean : list) {
                    if (tmpBean.getMetaObject().getMetaClass().getTableName().equalsIgnoreCase("bebauung") || tmpBean.getMetaObject().getMetaClass().getTableName().equalsIgnoreCase("flaechennutzung")) {
                        newList.add(tmpBean);
                        continue;
                    }
                    newList.add(LagisBroker.cloneNutzung(tmpBean, clone));
                }
                clone.setProperty(propName, newList);
                continue;
            }
            if (o instanceof Geometry) {
                clone.setProperty(propName, ((Geometry)o).clone());
                continue;
            }
            if (o instanceof Long) {
                clone.setProperty(propName, (Object)new Long(o.toString()));
                continue;
            }
            if (o instanceof Double) {
                clone.setProperty(propName, (Object)new Double(o.toString()));
                continue;
            }
            if (o instanceof Integer) {
                clone.setProperty(propName, (Object)new Integer(o.toString()));
                continue;
            }
            if (o instanceof Boolean) {
                clone.setProperty(propName, (Object)new Boolean(o.toString()));
                continue;
            }
            if (o instanceof String) {
                clone.setProperty(propName, o);
                continue;
            }
            if (o instanceof Timestamp) {
                clone.setProperty(propName, ((Timestamp)o).clone());
                continue;
            }
            if (o != null) {
                LOG.error((Object)("unknown property type: " + o.getClass().getName()));
            }
            clone.setProperty(propName, o);
        }
        clone.persist();
        return clone;
    }

    private void replacePseudoFlurstuecke(Collection<FlurstueckHistorieCustomBean> flurstueckHistorie, Collection<FlurstueckHistorieCustomBean> allEdges, HistoryType direction) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("replacePseudoFlurstuecke: direction=" + (Object)((Object)direction) + " Kanten=" + flurstueckHistorie));
        }
        if (flurstueckHistorie != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"es existieren Kanten");
            }
            Iterator<FlurstueckHistorieCustomBean> itr = flurstueckHistorie.iterator();
            ArrayList<FlurstueckHistorieCustomBean> pseudoKeysToRemove = new ArrayList<FlurstueckHistorieCustomBean>();
            HashSet<FlurstueckHistorieCustomBean> realNeighbours = new HashSet<FlurstueckHistorieCustomBean>();
            while (itr.hasNext()) {
                Collection<FlurstueckHistorieCustomBean> result;
                FlurstueckHistorieCustomBean currentFlurstueckHistorie = itr.next();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("" + currentFlurstueckHistorie.getNachfolger()));
                }
                if (direction == HistoryType.PREDECESSOR && currentFlurstueckHistorie.getNachfolger() != null && currentFlurstueckHistorie.getVorgaenger() != null && currentFlurstueckHistorie.getVorgaenger().getFlurstueckSchluessel() != null && !currentFlurstueckHistorie.getVorgaenger().getFlurstueckSchluessel().isEchterSchluessel()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Vorg\u00e4nger ist ein PseudoFlurst\u00fcck und besitzt vorg\u00e4nge --> suche heraus und ersetze");
                    }
                    allEdges.add(currentFlurstueckHistorie);
                    pseudoKeysToRemove.add(currentFlurstueckHistorie);
                    result = this.getHistoryPredecessors(currentFlurstueckHistorie.getVorgaenger().getFlurstueckSchluessel());
                    if (result == null) continue;
                    realNeighbours.addAll(result);
                    continue;
                }
                if (direction != HistoryType.SUCCESSOR || currentFlurstueckHistorie.getNachfolger() == null || currentFlurstueckHistorie.getVorgaenger() == null || currentFlurstueckHistorie.getNachfolger().getFlurstueckSchluessel() == null || currentFlurstueckHistorie.getNachfolger().getFlurstueckSchluessel().isEchterSchluessel()) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Vorg\u00e4nger ist ein PseudoFlurst\u00fcck und besitzt vorg\u00e4nge --> suche heraus und ersetze");
                }
                allEdges.add(currentFlurstueckHistorie);
                pseudoKeysToRemove.add(currentFlurstueckHistorie);
                result = this.getHistorySuccessor(currentFlurstueckHistorie.getNachfolger().getFlurstueckSchluessel());
                if (result == null) continue;
                realNeighbours.addAll(result);
            }
            flurstueckHistorie.removeAll(pseudoKeysToRemove);
            flurstueckHistorie.addAll(realNeighbours);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Keine Pseudoflurst\u00fccke zum ersetzen");
        }
    }

    private Collection<FlurstueckHistorieCustomBean> getHistoryPredecessors(FlurstueckSchluesselCustomBean flurstueckSchluessel) {
        MetaClass metaclass;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Suche Vorg\u00e4nger f\u00fcr Flurst\u00fcck");
            LOG.debug((Object)("ID des Schluessels ist: " + flurstueckSchluessel));
        }
        if ((metaclass = CidsBroker.getInstance().getLagisMetaClass("flurstueck_historie")) == null) {
            return null;
        }
        String query = "SELECT    " + metaclass.getID() + ",    " + metaclass.getTableName() + "." + metaclass.getPrimaryKey() + " FROM    " + metaclass.getTableName() + ",    flurstueck WHERE    " + metaclass.getTableName() + ".fk_nachfolger = flurstueck.id    AND flurstueck.fk_flurstueck_schluessel = " + flurstueckSchluessel.getId();
        MetaObject[] mos = CidsBroker.getInstance().getLagisMetaObject(query);
        HashSet<FlurstueckHistorieCustomBean> historyEntries = new HashSet<FlurstueckHistorieCustomBean>();
        for (MetaObject metaObject : mos) {
            historyEntries.add((FlurstueckHistorieCustomBean)metaObject.getBean());
        }
        if (historyEntries != null) {
            if (historyEntries.isEmpty()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Ergebnisliste ist leer");
                }
                return null;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Suche lieferte mindestens ein Ergebnis zur\u00fcck");
            }
            return historyEntries;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Suche lieferte kein Ergebnis zur\u00fcck");
        }
        return null;
    }

    private CidsBean persistLockIfNotAlreadyLocked(CidsBean lock) throws LockAlreadyExistsException, Exception {
        if (lock == null) {
            throw new Exception("can't persist null lock");
        }
        MetaClass metaclass = lock.getMetaObject().getMetaClass();
        if (metaclass == null) {
            throw new Exception("can't get MetaClass for cs_locks");
        }
        String query = "SELECT " + metaclass.getID() + ", " + metaclass.getTableName() + "." + metaclass.getPrimaryKey() + " FROM " + metaclass.getTableName() + " WHERE " + metaclass.getTableName() + ".object_id = " + lock.getProperty("object_id") + " AND " + metaclass.getTableName() + ".class_id = " + lock.getProperty("class_id");
        MetaObject[] oldcsLocks = CidsBroker.getInstance().getLagisMetaObject(query);
        if (oldcsLocks == null || oldcsLocks.length == 0) {
            return lock.persist();
        }
        ArrayList<CidsBean> existingLocks = new ArrayList<CidsBean>();
        for (MetaObject oldcsLock : oldcsLocks) {
            existingLocks.add(oldcsLock.getBean());
        }
        throw new LockAlreadyExistsException("A lock for the desired object is already existing", existingLocks);
    }

    public GemarkungCustomBean completeGemarkung(GemarkungCustomBean gem) {
        try {
            if (gem != null && gem.getBezeichnung() != null) {
                Collection<GemarkungCustomBean> gemarkungen = this.getGemarkungsKeys();
                if (gemarkungen != null) {
                    for (GemarkungCustomBean tmp : gemarkungen) {
                        if (!tmp.getBezeichnung().equals(gem.getBezeichnung())) continue;
                        return tmp;
                    }
                    return null;
                }
                return null;
            }
            if (gem != null && gem.getSchluessel() != null) {
                Collection<GemarkungCustomBean> gemarkungen;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Schl\u00fcssel != null");
                }
                if ((gemarkungen = this.getGemarkungsKeys()) != null) {
                    Iterator<GemarkungCustomBean> it = gemarkungen.iterator();
                    while (it.hasNext()) {
                        GemarkungCustomBean tmp;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"checke schl\u00fcssel durch");
                        }
                        if ((tmp = it.next()).getSchluessel().intValue() != gem.getSchluessel().intValue()) continue;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"Schl\u00fcssel gefunden");
                        }
                        return tmp;
                    }
                    return null;
                }
                return null;
            }
            return null;
        }
        catch (Exception ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Fehler beim Kompletieren einer Gemarkung: " + gem), (Throwable)ex);
            }
            return null;
        }
    }

    public Date getCurrentDate() {
        return new Date();
    }

    public void modifyFlurstueck(FlurstueckCustomBean flurstueck) throws ActionNotSuccessfulException {
        flurstueck.getFlurstueckSchluessel().setLetzter_bearbeiter(this.getAccountName());
        flurstueck.getFlurstueckSchluessel().setLetzte_bearbeitung(this.getCurrentDate());
        try {
            this.processNutzungen(flurstueck.getNutzungen(), flurstueck.getFlurstueckSchluessel().getKeyString());
            this.checkIfFlurstueckWasStaedtisch(flurstueck.getFlurstueckSchluessel(), null);
            flurstueck.persist();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Flurst\u00fcck gespeichert");
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Fehler beim speichern der Entit\u00e4t", (Throwable)ex);
            throw new ActionNotSuccessfulException("Fehler beim speichern eines vorhandenen Flurst\u00fccks", ex);
        }
    }

    public void modifyFlurstueckSchluessel(FlurstueckSchluesselCustomBean key) {
        key.setLetzter_bearbeiter(this.getAccountName());
        key.setLetzte_bearbeitung(this.getCurrentDate());
        try {
            FlurstueckSchluesselCustomBean oldKey = this.completeFlurstueckSchluessel(key);
            FlurstueckArtCustomBean oldArt = null;
            if (oldKey != null) {
                oldArt = oldKey.getFlurstueckArt();
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Alterschl\u00fcssel ist == null");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Art " + oldArt != null ? 1 : 0));
                LOG.debug((Object)("Bezeichnung " + oldArt.getBezeichnung() != null ? 1 : 0));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Alter war staedtich " + "st\u00e4dtisch".equals(oldArt.getBezeichnung())));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Art hat sich ge\u00e4ndert " + !FlurstueckArtCustomBean.FLURSTUECK_ART_EQUALATOR.pedanticEquals(oldArt, key.getFlurstueckArt())));
            }
            if (oldArt != null && oldArt.getBezeichnung() != null && "st\u00e4dtisch".equals(oldArt.getBezeichnung()) && !FlurstueckArtCustomBean.FLURSTUECK_ART_EQUALATOR.pedanticEquals(oldArt, key.getFlurstueckArt())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Die Art eines st\u00e4dtischen Flurst\u00fccks wurde auf eine andere ge\u00e4ndert update lettzer Stadtbestizt Datum");
                }
                key.setWarStaedtisch(true);
                key.setDatumLetzterStadtbesitz(new Date());
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Die Art eines St\u00e4dtischen Flurst\u00fccks wurde nicht auf eine andere ge\u00e4ndert --> checkIfFlurstueckWasStaedtisch");
                }
                this.checkIfFlurstueckWasStaedtisch(key, null);
            }
            key.persist();
        }
        catch (Throwable t) {
            LOG.error((Object)"Fehler beim speichern der Entit\u00e4t", t);
        }
    }

    public void deleteFlurstueck(FlurstueckCustomBean flurstueck) throws ActionNotSuccessfulException {
        block12: {
            boolean illegalDelete = false;
            try {
                if (!illegalDelete) {
                    for (VerwaltungsbereichCustomBean verwaltungsbereichCustomBean : flurstueck.getVerwaltungsbereiche()) {
                        if (verwaltungsbereichCustomBean == null) continue;
                        illegalDelete = true;
                        break;
                    }
                }
                if (!illegalDelete) {
                    for (NutzungCustomBean nutzungCustomBean : flurstueck.getNutzungen()) {
                        if (nutzungCustomBean == null) continue;
                        illegalDelete = true;
                        break;
                    }
                }
                if (!illegalDelete) {
                    for (VertragCustomBean vertragCustomBean : flurstueck.getVertraege()) {
                        if (vertragCustomBean == null) continue;
                        illegalDelete = true;
                        break;
                    }
                }
                if (!illegalDelete) {
                    for (FlurstueckHistorieCustomBean flurstueckHistorieCustomBean : this.getAllHistoryEntries(flurstueck.getFlurstueckSchluessel())) {
                        if (flurstueckHistorieCustomBean == null) continue;
                        illegalDelete = true;
                        break;
                    }
                }
                if (illegalDelete) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Es sind daten f\u00fcr das Flurst\u00fcck vorhanden es kann nicht gel\u00f6scht werden");
                    }
                    throw new ActionNotSuccessfulException("Es sind Daten f\u00fcr das Flurst\u00fcck vorhanden, es kann nicht gel\u00f6scht werden");
                }
                flurstueck.delete();
                flurstueck.persist();
            }
            catch (Exception ex) {
                LOG.error((Object)("Fehler beim l\u00f6schen eines Flurst\u00fccks: " + flurstueck), (Throwable)ex);
                if (!(ex instanceof ActionNotSuccessfulException)) break block12;
                throw (ActionNotSuccessfulException)ex;
            }
        }
    }

    public Collection<GemarkungCustomBean> getGemarkungsKeys() {
        MetaClass metaclass = CidsBroker.getInstance().getLagisMetaClass("gemarkung");
        if (metaclass == null) {
            return null;
        }
        MetaObject[] mos = CidsBroker.getInstance().getLagisMetaObject("SELECT " + metaclass.getID() + ", " + metaclass.getTableName() + "." + metaclass.getPrimaryKey() + " FROM " + metaclass.getTableName());
        HashSet<GemarkungCustomBean> beans = new HashSet<GemarkungCustomBean>();
        for (MetaObject metaObject : mos) {
            beans.add((GemarkungCustomBean)metaObject.getBean());
        }
        return beans;
    }

    public HashMap<Integer, GemarkungCustomBean> getGemarkungsHashMap() {
        Collection<GemarkungCustomBean> gemarkungen = this.getGemarkungsKeys();
        if (gemarkungen != null) {
            HashMap<Integer, GemarkungCustomBean> result = new HashMap<Integer, GemarkungCustomBean>();
            for (GemarkungCustomBean gemarkung : gemarkungen) {
                if (gemarkung == null || gemarkung.getBezeichnung() == null || gemarkung.getSchluessel() == null) continue;
                result.put(gemarkung.getSchluessel(), gemarkung);
            }
            return result;
        }
        return null;
    }

    public void createFlurstueckHistoryEntry(FlurstueckHistorieCustomBean flurstueckHistorie) {
        try {
            flurstueckHistorie.persist();
        }
        catch (Exception ex) {
            LOG.error((Object)("Fehler beim anlegen der Flurstueckshistorie: " + flurstueckHistorie), (Throwable)ex);
        }
    }

    public Collection<Key> getDependingKeysForKey(Key key) {
        block36: {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"GetDependingKeysForKey");
            }
            try {
                if (key != null) {
                    if (key instanceof GemarkungCustomBean) {
                        GemarkungCustomBean currentGemarkung;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"Key ist Gemarkung");
                        }
                        if ((currentGemarkung = (GemarkungCustomBean)key).getSchluessel() != null) {
                            MetaClass metaclass = CidsBroker.getInstance().getLagisMetaClass("flurstueck_schluessel");
                            if (metaclass == null) {
                                return null;
                            }
                            String query = "SELECT DISTINCT    min(" + metaclass.getTableName() + "." + metaclass.getPrimaryKey() + ") AS id,    min(" + metaclass.getTableName() + ".flur) AS flur FROM    " + metaclass.getTableName() + ",    gemarkung WHERE     " + metaclass.getTableName() + ".fk_gemarkung = gemarkung.id     AND " + metaclass.getTableName() + ".fk_flurstueck_art != 3     AND gemarkung.schluessel = " + currentGemarkung.getSchluessel() + " GROUP BY " + metaclass.getTableName() + ".flur";
                            MetaObject[] mos = CidsBroker.getInstance().getLagisLWMetaObjects(metaclass.getTableName(), query, new String[]{"id", "flur"}, new AbstractAttributeRepresentationFormater(){

                                public String getRepresentation() {
                                    return String.valueOf(this.getAttribute("flur"));
                                }
                            });
                            if (mos != null) {
                                HashSet<Key> flurKeys = new HashSet<Key>();
                                for (MetaObject mo : mos) {
                                    Integer flur = Integer.parseInt(mo.toString());
                                    flurKeys.add(new FlurKey(currentGemarkung, flur));
                                }
                                return flurKeys;
                            }
                            return new HashSet<Key>();
                        }
                        if (currentGemarkung.getBezeichnung() != null) {
                            GemarkungCustomBean completed = this.completeGemarkung(currentGemarkung);
                            if (completed != null) {
                                MetaClass metaclass = CidsBroker.getInstance().getLagisMetaClass("flurstueck_schluessel");
                                if (metaclass == null) {
                                    return null;
                                }
                                String query = "SELECT DISTINCT    min(" + metaclass.getTableName() + "." + metaclass.getPrimaryKey() + ") AS id,    min(" + metaclass.getTableName() + ".flur) AS flur FROM    " + metaclass.getTableName() + ",    gemarkung WHERE     " + metaclass.getTableName() + ".fk_gemarkung = gemarkung.id     AND " + metaclass.getTableName() + ".fk_flurstueck_art != 3     AND gemarkung.schluessel = " + completed.getSchluessel() + " GROUP BY " + metaclass.getTableName() + ".flur";
                                MetaObject[] mos = CidsBroker.getInstance().getLagisLWMetaObjects(metaclass.getTableName(), query, new String[]{"id", "flur"}, new AbstractAttributeRepresentationFormater(){

                                    public String getRepresentation() {
                                        return String.valueOf(this.getAttribute("flur"));
                                    }
                                });
                                if (mos != null) {
                                    HashSet<Key> flurKeys = new HashSet<Key>();
                                    for (MetaObject mo : mos) {
                                        Integer flur = Integer.parseInt(mo.toString());
                                        flurKeys.add(new FlurKey(currentGemarkung, flur));
                                    }
                                    return flurKeys;
                                }
                                return new HashSet<Key>();
                            }
                            return new HashSet<Key>();
                        }
                        return new HashSet<Key>();
                    }
                    if (key instanceof FlurKey) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"Key ist Flur");
                        }
                        FlurKey currentFlur = (FlurKey)key;
                        MetaClass metaclass = CidsBroker.getInstance().getLagisMetaClass("flurstueck_schluessel");
                        if (metaclass == null) {
                            return null;
                        }
                        String query = null;
                        if (!(currentFlur.isCurrentFilterEnabled() || currentFlur.isHistoricFilterEnabled() || currentFlur.isAbteilungXIFilterEnabled() || currentFlur.isStaedtischFilterEnabled())) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)"Kein Filter f\u00fcr Flur Aktiviert");
                            }
                            query = "SELECT " + metaclass.getID() + ", " + metaclass.getTableName() + "." + metaclass.getPrimaryKey() + " FROM    " + metaclass.getTableName() + ",    gemarkung WHERE    " + metaclass.getTableName() + ".fk_gemarkung = gemarkung.id    AND " + metaclass.getTableName() + ".flur = " + currentFlur.getFlurId() + "    AND " + metaclass.getTableName() + ".fk_flurstueck_art != 3    AND gemarkung.schluessel = " + currentFlur.getGemarkungsId();
                        } else if (currentFlur.isCurrentFilterEnabled()) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)"Filter nur aktuelle Flurst\u00fccke: Aktiviert");
                            }
                            query = "SELECT " + metaclass.getID() + ", " + metaclass.getTableName() + "." + metaclass.getPrimaryKey() + " FROM    " + metaclass.getTableName() + ",    gemarkung WHERE    " + metaclass.getTableName() + ".fk_gemarkung = gemarkung.id    AND " + metaclass.getTableName() + ".flur = " + currentFlur.getFlurId() + "    AND " + metaclass.getTableName() + ".fk_flurstueck_art != 3    AND " + metaclass.getTableName() + ".gueltig_bis IS NULL    AND gemarkung.schluessel = " + currentFlur.getGemarkungsId();
                        } else if (currentFlur.isHistoricFilterEnabled()) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)"Filter nur historische Flurst\u00fccke: Aktiviert");
                            }
                            query = "SELECT " + metaclass.getID() + ", " + metaclass.getTableName() + "." + metaclass.getPrimaryKey() + " FROM    " + metaclass.getTableName() + ",    gemarkung WHERE    " + metaclass.getTableName() + ".fk_gemarkung = gemarkung.id    AND " + metaclass.getTableName() + ".flur = " + currentFlur.getFlurId() + "    AND " + metaclass.getTableName() + ".fk_flurstueck_art != 3    AND " + metaclass.getTableName() + ".gueltig_bis IS NOT NULL    AND gemarkung.schluessel = " + currentFlur.getGemarkungsId();
                        } else if (currentFlur.isAbteilungXIFilterEnabled()) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)"Filter nur Abteilung IX Flurst\u00fccke: Aktiviert");
                            }
                            query = "SELECT " + metaclass.getID() + ", " + metaclass.getTableName() + "." + metaclass.getPrimaryKey() + " FROM    " + metaclass.getTableName() + ",    gemarkung WHERE    " + metaclass.getTableName() + ".fk_gemarkung = gemarkung.id    AND " + metaclass.getTableName() + ".flur = " + currentFlur.getFlurId() + "    AND " + metaclass.getTableName() + ".fk_flurstueck_art = 2    AND gemarkung.schluessel = " + currentFlur.getGemarkungsId();
                        } else if (currentFlur.isStaedtischFilterEnabled()) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)"Filter nur staedtische Flurst\u00fccke: Aktiviert");
                            }
                            query = "SELECT " + metaclass.getID() + ", " + metaclass.getTableName() + "." + metaclass.getPrimaryKey() + " FROM    " + metaclass.getTableName() + ",    gemarkung WHERE    " + metaclass.getTableName() + ".fk_gemarkung = gemarkung.id    AND " + metaclass.getTableName() + ".flur = " + currentFlur.getFlurId() + "    AND " + metaclass.getTableName() + ".fk_flurstueck_art = 1    AND gemarkung.schluessel = " + currentFlur.getGemarkungsId();
                        }
                        if (query != null) {
                            MetaObject[] mos = CidsBroker.getInstance().getLagisMetaObject(query);
                            HashSet<FlurstueckSchluesselCustomBean> flurstuecke = new HashSet<FlurstueckSchluesselCustomBean>();
                            for (MetaObject metaObject : mos) {
                                flurstuecke.add((FlurstueckSchluesselCustomBean)metaObject.getBean());
                            }
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("Ergebnisse f\u00fcr Abfrage vorhanden: " + flurstuecke.size()));
                            }
                            return new HashSet<Key>(flurstuecke);
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"Keine Ergebnisse f\u00fcr Abfrage vorhanden");
                        }
                        return new HashSet<Key>();
                    }
                    break block36;
                }
                return new HashSet<Key>();
            }
            catch (Exception ex) {
                LOG.error((Object)("Fehler beim abfragen eines Keys: " + key + " Class: " + (key != null ? key.getClass() : null)), (Throwable)ex);
            }
        }
        return new HashSet<Key>();
    }

    private Collection<CidsBean> searchAlkisLandparcelBeans(Geometry geometry) {
        try {
            AlkisLandparcelSearch serverSearch = new AlkisLandparcelSearch();
            String crs = serverSearch.getCrs();
            Geometry transformedGeom = CrsTransformer.transformToGivenCrs((Geometry)geometry, (String)crs);
            transformedGeom.setSRID(CrsTransformer.extractSridFromCrs((String)crs));
            serverSearch.setGeometry(transformedGeom);
            List alkisLandparcelIds = (List)SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)serverSearch);
            if (alkisLandparcelIds.isEmpty()) {
                return null;
            }
            StringBuilder idStringBuilder = new StringBuilder();
            for (int index = 0; index < alkisLandparcelIds.size(); ++index) {
                Integer alkisLandparcel = (Integer)alkisLandparcelIds.get(index);
                if (index > 0) {
                    idStringBuilder.append(", ");
                }
                idStringBuilder.append(Integer.toString(alkisLandparcel));
            }
            MetaClass mc = CidsBean.getMetaClassFromTableName((String)"WUNDA_BLAU", (String)"alkis_landparcel");
            MetaObject[] mos = SessionManager.getProxy().getMetaObjectByQuery(SessionManager.getSession().getUser(), "SELECT " + mc.getId() + ", id FROM alkis_landparcel WHERE id IN (" + idStringBuilder.toString() + ")", "WUNDA_BLAU");
            ArrayList<CidsBean> alkisLandparcelBeans = new ArrayList<CidsBean>();
            for (MetaObject mo : mos) {
                alkisLandparcelBeans.add(mo.getBean());
            }
            return alkisLandparcelBeans;
        }
        catch (Exception ex) {
            LOG.error((Object)"error while searching alkis landparcels", (Throwable)ex);
            return null;
        }
    }

    public FlurstueckCustomBean retrieveFlurstueck(FlurstueckSchluesselCustomBean key) {
        try {
            MetaClass metaclass;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Finde Flurstuck: ");
                LOG.debug((Object)("Id       : " + key.getId()));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Gemarkung: " + key.getGemarkung()));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Flur     : " + key.getFlur()));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Zaehler  : " + key.getFlurstueckZaehler()));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Nenner   : " + key.getFlurstueckNenner()));
            }
            if ((metaclass = CidsBroker.getInstance().getLagisMetaClass("flurstueck")) == null) {
                return null;
            }
            Integer flur = key.getFlur();
            Integer fsZaehler = key.getFlurstueckZaehler();
            Integer fsNenner = key.getFlurstueckNenner();
            Integer gemarkung = key.getGemarkung() == null ? null : key.getGemarkung().getId();
            MetaObject[] mos = flur != null && fsZaehler != null && fsNenner != null && gemarkung != null ? CidsBroker.getInstance().getLagisMetaObject("SELECT " + metaclass.getID() + ", " + metaclass.getTableName() + "." + metaclass.getPrimaryKey() + "  FROM " + metaclass.getTableName() + ", flurstueck_schluessel fk WHERE " + metaclass.getTableName() + ".fk_flurstueck_schluessel = fk.id  AND fk.flur = " + key.getFlur() + " AND fk.fk_gemarkung = " + key.getGemarkung().getId() + " AND fk.flurstueck_zaehler = " + key.getFlurstueckZaehler() + " AND fk.flurstueck_nenner  = " + key.getFlurstueckNenner()) : CidsBroker.getInstance().getLagisMetaObject("SELECT " + metaclass.getID() + ", " + metaclass.getTableName() + "." + metaclass.getPrimaryKey() + "  FROM " + metaclass.getTableName() + ", flurstueck_schluessel fk WHERE " + metaclass.getTableName() + ".fk_flurstueck_schluessel = fk.id  AND fk.id = " + key.getId() + " AND fk.flur is NULL  AND fk.fk_gemarkung is NULL  AND fk.flurstueck_zaehler is NULL  AND fk.flurstueck_nenner  is NULL ");
            if (mos != null && mos.length > 0) {
                Collection<BaumCustomBean> baueme;
                if (mos.length > 1) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Anzahl Flurstuecke: " + mos.length));
                    }
                    throw new Exception("Multiple Flurstuecke should only be one");
                }
                FlurstueckCustomBean result = (FlurstueckCustomBean)mos[0].getBean();
                Collection<VertragCustomBean> vertrage = result.getVertraege();
                if (vertrage != null && vertrage.size() > 0) {
                    Collection<FlurstueckSchluesselCustomBean> resultKeys = this.getCrossreferencesForVertraege(vertrage);
                    if (resultKeys != null) {
                        resultKeys.remove(result.getFlurstueckSchluessel());
                    }
                    result.setVertraegeQuerverweise(resultKeys);
                }
                if ((baueme = result.getBaeume()) != null && baueme.size() > 0) {
                    Collection<FlurstueckSchluesselCustomBean> resultKeys = this.getCrossreferencesForBaeume(baueme);
                    if (resultKeys != null) {
                        resultKeys.remove(result.getFlurstueckSchluessel());
                    }
                    result.setBaeumeQuerverweise(resultKeys);
                }
                return result;
            }
            return null;
        }
        catch (Exception ex) {
            LOG.error((Object)("Fehler beim abfragen des Flurstuecks: " + key), (Throwable)ex);
            return null;
        }
    }

    public String getHistoryGraph(FlurstueckCustomBean currentFlurstueck, HistoryLevel level, int levelLimit, HistorySibblingLevel sibblingLevel, int sibblingLevelLimit, HistoryType type, HashMap<String, Integer> nodeToKeyMapIn) throws ActionNotSuccessfulException {
        StringBuilder dotGraphRepresentation = new StringBuilder(DEFAULT_DOT_HEADER);
        try {
            HashMap<String, Integer> nodeToKeyMap;
            int sibblingLevelCount;
            int successorLevelCount;
            int predecessorLevelCount;
            boolean followPredecessors = HistoryType.BOTH.equals((Object)type) || HistoryType.PREDECESSOR.equals((Object)type);
            boolean followSuccessors = HistoryType.BOTH.equals((Object)type) || HistoryType.SUCCESSOR.equals((Object)type);
            switch (level) {
                case All: {
                    predecessorLevelCount = followPredecessors ? Integer.MIN_VALUE : 1;
                    successorLevelCount = followSuccessors ? Integer.MAX_VALUE : 0;
                    break;
                }
                case DIRECT_RELATIONS: {
                    predecessorLevelCount = followPredecessors ? -1 : Integer.MAX_VALUE;
                    successorLevelCount = followSuccessors ? 1 : Integer.MIN_VALUE;
                    break;
                }
                case CUSTOM: {
                    predecessorLevelCount = followPredecessors ? -levelLimit : Integer.MAX_VALUE;
                    successorLevelCount = followSuccessors ? levelLimit : Integer.MIN_VALUE;
                    break;
                }
                default: {
                    predecessorLevelCount = Integer.MAX_VALUE;
                    successorLevelCount = Integer.MIN_VALUE;
                }
            }
            switch (sibblingLevel) {
                case FULL: {
                    sibblingLevelCount = Integer.MAX_VALUE;
                    break;
                }
                case SIBBLING_ONLY: {
                    sibblingLevelCount = 0;
                    break;
                }
                case CUSTOM: {
                    sibblingLevelCount = sibblingLevelLimit;
                    break;
                }
                default: {
                    sibblingLevelCount = Integer.MIN_VALUE;
                }
            }
            FlurstueckHistorieGraphSearch search = new FlurstueckHistorieGraphSearch(currentFlurstueck.getId(), Integer.valueOf(predecessorLevelCount), Integer.valueOf(successorLevelCount), Integer.valueOf(sibblingLevelCount));
            Collection allEdges = CidsBroker.getInstance().executeSearch((CidsServerSearch)search);
            HashMap<String, String> pseudoKeys = new HashMap<String, String>();
            HashMap<String, Integer> hashMap = nodeToKeyMap = nodeToKeyMapIn == null ? new HashMap<String, Integer>() : nodeToKeyMapIn;
            if (allEdges != null && allEdges.size() > 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Historie Graph hat: " + allEdges.size() + " Kanten"));
                }
                for (FlurstueckHistorieGraphSearchResultItem currentEdge : allEdges) {
                    String currentVorgaenger = currentEdge.getVorgaengerName();
                    String currentNachfolger = currentEdge.getNachfolgerName();
                    if (currentVorgaenger.startsWith("pseudo")) {
                        pseudoKeys.put(currentVorgaenger, "    ");
                    }
                    if (currentNachfolger.startsWith("pseudo")) {
                        pseudoKeys.put(currentNachfolger, "    ");
                    }
                    dotGraphRepresentation.append("\"").append(currentVorgaenger).append("\"->\"").append(currentNachfolger).append("\" [lineInterpolate=\"linear\"];\n");
                    nodeToKeyMap.put(currentEdge.getVorgaengerName(), currentEdge.getVorgaengerSchluesselId());
                    nodeToKeyMap.put(currentEdge.getNachfolgerName(), currentEdge.getNachfolgerSchluesselId());
                }
                dotGraphRepresentation.append("\"").append(currentFlurstueck).append("\"  [style=\"fill: #eee; font-weight: bold\"];\n");
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Historie Graph ist < 1 --> keine Historie");
                }
                dotGraphRepresentation.append("\"").append(currentFlurstueck).append("\"  [style=\"fill: #eee; font-weight: bold\"];\n");
                nodeToKeyMap.put(currentFlurstueck.toString(), currentFlurstueck.getId());
            }
            if (pseudoKeys.size() > 0) {
                for (String key : pseudoKeys.keySet()) {
                    dotGraphRepresentation.append("\"").append(key).append("\" [label=\"    \"]");
                }
            }
            dotGraphRepresentation.append("}");
        }
        catch (Exception ex) {
            throw new ActionNotSuccessfulException("error while searching historie for " + currentFlurstueck, ex);
        }
        return dotGraphRepresentation.toString();
    }

    public Collection<VertragCustomBean> getVertraegeForKey(FlurstueckSchluesselCustomBean key) {
        MetaClass metaclass = CidsBroker.getInstance().getLagisMetaClass("vertrag");
        if (metaclass == null) {
            return null;
        }
        String query = "SELECT    " + metaclass.getID() + ",    jt_flurstueck_vertrag.fk_vertrag FROM    flurstueck,    jt_flurstueck_vertrag WHERE    jt_flurstueck_vertrag.fk_flurstueck = flurstueck.id    AND flurstueck.fk_flurstueck_schluessel = " + key.getId();
        MetaObject[] mos = CidsBroker.getInstance().getLagisMetaObject(query);
        HashSet<VertragCustomBean> beans = new HashSet<VertragCustomBean>();
        for (MetaObject metaObject : mos) {
            beans.add((VertragCustomBean)metaObject.getBean());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Anzahl Vertraege ist: " + beans.size()));
        }
        return beans;
    }

    public Collection<FlurstueckSchluesselCustomBean> getCrossReferencesForVertrag(VertragCustomBean vertrag) {
        MetaClass metaclass = CidsBroker.getInstance().getLagisMetaClass("flurstueck_schluessel");
        if (metaclass == null) {
            return null;
        }
        String query = "SELECT    " + metaclass.getID() + ",    flurstueck.fk_flurstueck_schluessel FROM    public.flurstueck,    public.jt_flurstueck_vertrag WHERE    public.flurstueck.ar_vertraege = public.jt_flurstueck_vertrag.fk_flurstueck     AND public.jt_flurstueck_vertrag.fk_vertrag = " + vertrag.getId();
        MetaObject[] mosVertrag = CidsBroker.getInstance().getLagisMetaObject(query);
        HashSet<FlurstueckSchluesselCustomBean> keys = new HashSet<FlurstueckSchluesselCustomBean>();
        for (MetaObject metaObject : mosVertrag) {
            keys.add((FlurstueckSchluesselCustomBean)metaObject.getBean());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Anzahl FlurstueckSchluessel ist: " + keys.size()));
        }
        return keys;
    }

    public Collection<FlurstueckSchluesselCustomBean> getCrossreferencesForVertraege(Collection<VertragCustomBean> vertraege) {
        if (vertraege != null && vertraege.size() > 0) {
            HashSet<FlurstueckSchluesselCustomBean> result = new HashSet<FlurstueckSchluesselCustomBean>();
            Iterator<VertragCustomBean> it = vertraege.iterator();
            while (it.hasNext()) {
                Collection<FlurstueckSchluesselCustomBean> curKeys = this.getCrossReferencesForVertrag(it.next());
                if (curKeys == null || curKeys.size() <= 0) continue;
                result.addAll(curKeys);
            }
            return result;
        }
        return null;
    }

    private Collection<FlurstueckSchluesselCustomBean> getFlurstueckSchluesselBy(CidsServerSearch search) {
        HashSet<FlurstueckSchluesselCustomBean> flurstueckSchluessel = new HashSet<FlurstueckSchluesselCustomBean>();
        try {
            Collection mons = CidsBroker.getInstance().executeSearch(search);
            if (mons != null) {
                for (MetaObjectNode mon : mons) {
                    MetaObject metaObject = CidsBroker.getInstance().getLagisMetaObject(mon.getObjectId(), mon.getClassId());
                    if (metaObject == null) continue;
                    flurstueckSchluessel.add((FlurstueckSchluesselCustomBean)metaObject.getBean());
                }
            }
        }
        catch (Exception ex) {
            LOG.fatal((Object)ex, (Throwable)ex);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Anzahl gefundener Flurstst\u00fcckschl\u00fcssel ist: " + flurstueckSchluessel.size()));
        }
        return flurstueckSchluessel;
    }

    public Collection<FlurstueckSchluesselCustomBean> getFlurstueckSchluesselByVertragAktenzeichen(String aktenzeichenSearchPattern) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Suche nach Flurst\u00fccken(Schluesseln) mit dem Vertrags-Aktenzeichen: " + aktenzeichenSearchPattern));
        }
        return this.getFlurstueckSchluesselBy((CidsServerSearch)new FlurstueckSchluesselByVertragAktenzeichenSearch(aktenzeichenSearchPattern));
    }

    public Collection<FlurstueckSchluesselCustomBean> getFlurstueckSchluesselByMipaAktenzeichen(String aktenzeichenSearchPattern) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Suche nach Flurst\u00fccken(Schluesseln) mit dem Mipa-Aktenzeichen: " + aktenzeichenSearchPattern));
        }
        return this.getFlurstueckSchluesselBy((CidsServerSearch)new FlurstueckSchluesselByMipaAktenzeichenSearch(aktenzeichenSearchPattern));
    }

    public Collection<FlurstueckSchluesselCustomBean> getCrossReferencesForMiPa(MipaCustomBean mipa) {
        MetaClass mcFlurstueckSchluessel = CidsBroker.getInstance().getLagisMetaClass("flurstueck_schluessel");
        if (mcFlurstueckSchluessel == null) {
            return null;
        }
        FlurstueckSchluesselCustomBean currentFlurstueckSchluessel = this.getCurrentFlurstueckSchluessel();
        Collection<CidsBean> alkisFlurstuecke = this.searchAlkisLandparcelBeans(mipa.getGeometry().buffer(this.mipaBuffer));
        HashSet<FlurstueckSchluesselCustomBean> keys = new HashSet<FlurstueckSchluesselCustomBean>();
        if (alkisFlurstuecke != null) {
            for (CidsBean alkisFlurstueck : alkisFlurstuecke) {
                if (alkisFlurstueck == null) continue;
                String query = "SELECT   " + mcFlurstueckSchluessel.getID() + ",   flurstueck_schluessel.id FROM flurstueck_schluessel LEFT JOIN gemarkung   ON flurstueck_schluessel.fk_gemarkung = gemarkung.id WHERE   gemarkung.bezeichnung ILIKE '" + alkisFlurstueck.getProperty("gemarkung") + "'   AND flurstueck_schluessel.flur = '" + alkisFlurstueck.getProperty("flur") + "'::integer " + (alkisFlurstueck.getProperty("fstck_zaehler") != null ? "  AND flurstueck_schluessel.flurstueck_zaehler = '" + alkisFlurstueck.getProperty("fstck_zaehler") + "'::integer" : "") + " " + (alkisFlurstueck.getProperty("fstck_nenner") != null ? "  AND flurstueck_schluessel.flurstueck_nenner  = '" + alkisFlurstueck.getProperty("fstck_nenner") + "'::integer" : "") + ";";
                MetaObject[] mosMipa = CidsBroker.getInstance().getLagisMetaObject(query);
                if (mosMipa == null) continue;
                for (MetaObject metaObject : mosMipa) {
                    FlurstueckSchluesselCustomBean schluessel = (FlurstueckSchluesselCustomBean)metaObject.getBean();
                    if (schluessel == null || schluessel.equals(currentFlurstueckSchluessel)) continue;
                    keys.add(schluessel);
                }
            }
        }
        return keys;
    }

    public Map<MipaCustomBean, Collection<FlurstueckSchluesselCustomBean>> getCrossreferencesForMiPas(Collection<MipaCustomBean> mipas) {
        if (mipas != null && mipas.size() > 0) {
            HashMap<MipaCustomBean, Collection<FlurstueckSchluesselCustomBean>> result = new HashMap<MipaCustomBean, Collection<FlurstueckSchluesselCustomBean>>();
            for (MipaCustomBean mipa : mipas) {
                Collection<FlurstueckSchluesselCustomBean> keys = this.getCrossReferencesForMiPa(mipa);
                if (keys == null || keys.size() <= 0) continue;
                result.put(mipa, keys);
            }
            return result;
        }
        return null;
    }

    public Collection<BaumCustomBean> getBaumForKey(FlurstueckSchluesselCustomBean key) {
        MetaClass mcBaum = CidsBroker.getInstance().getLagisMetaClass("baum");
        if (mcBaum == null) {
            return null;
        }
        String query = "SELECT    " + mcBaum.getID() + ",    jt_flurstueck_baum.fk_baum FROM    flurstueck,    jt_flurstueck_baum WHERE    jt_flurstueck_baum.fk_flurstueck = flurstueck.id    AND flurstueck.fk_flurstueck_schluessel = " + key.getId();
        MetaObject[] mosBaum = CidsBroker.getInstance().getLagisMetaObject(query);
        HashSet<BaumCustomBean> baeume = new HashSet<BaumCustomBean>();
        for (MetaObject metaObject : mosBaum) {
            baeume.add((BaumCustomBean)metaObject.getBean());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Anzahl Baueme ist: " + baeume.size()));
        }
        return baeume;
    }

    public Collection<FlurstueckSchluesselCustomBean> getCrossReferencesForBaum(BaumCustomBean baum) {
        MetaClass mcFlurstueckSchluessel = CidsBroker.getInstance().getLagisMetaClass("flurstueck_schluessel");
        if (mcFlurstueckSchluessel == null) {
            return null;
        }
        String query = "SELECT    " + mcFlurstueckSchluessel.getID() + ",    flurstueck.fk_flurstueck_schluessel FROM    public.flurstueck,    public.jt_flurstueck_baum WHERE    public.flurstueck.ar_baeume = public.jt_flurstueck_baum.fk_flurstueck     AND public.jt_flurstueck_baum.fk_baum = " + baum.getId();
        MetaObject[] mosBaum = CidsBroker.getInstance().getLagisMetaObject(query);
        HashSet<FlurstueckSchluesselCustomBean> keys = new HashSet<FlurstueckSchluesselCustomBean>();
        for (MetaObject metaObject : mosBaum) {
            keys.add((FlurstueckSchluesselCustomBean)metaObject.getBean());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Anzahl FlurstueckSchluessel ist: " + keys.size()));
        }
        return keys;
    }

    public Collection<FlurstueckSchluesselCustomBean> getCrossreferencesForBaeume(Collection<BaumCustomBean> baeume) {
        if (baeume != null && baeume.size() > 0) {
            HashSet<FlurstueckSchluesselCustomBean> result = new HashSet<FlurstueckSchluesselCustomBean>();
            Iterator<BaumCustomBean> it = baeume.iterator();
            while (it.hasNext()) {
                Collection<FlurstueckSchluesselCustomBean> curKeys = this.getCrossReferencesForBaum(it.next());
                if (curKeys == null || curKeys.size() <= 0) continue;
                result.addAll(curKeys);
            }
            return result;
        }
        return null;
    }

    public void setFlurstueckHistoric(FlurstueckSchluesselCustomBean key) throws ActionNotSuccessfulException {
        key.setLetzter_bearbeiter(this.getAccountName());
        key.setLetzte_bearbeitung(this.getCurrentDate());
        this.setFlurstueckHistoric(key, new Date());
    }

    public void setFlurstueckHistoric(FlurstueckSchluesselCustomBean key, Date date) throws ActionNotSuccessfulException {
        this.setFlurstueckHistoric(key, date, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setFlurstueckHistoric(FlurstueckSchluesselCustomBean key, Date date, boolean delRebeMipa) throws ActionNotSuccessfulException {
        key.setLetzter_bearbeiter(this.getAccountName());
        key.setLetzte_bearbeitung(this.getCurrentDate());
        try {
            if (key.getWarStaedtisch()) {
                FlurstueckCustomBean flurstueck = this.retrieveFlurstueck(key);
                flurstueck.setFlurstueckSchluessel(key);
                if (delRebeMipa) {
                    Date mipaVertragsendeDatum;
                    Date rebeLoeschDatum;
                    boolean hasMiPa;
                    GeometryWorker worker = new GeometryWorker(Arrays.asList(key));
                    Iterator<FlurstueckArtCustomBean> result = worker.call();
                    Geometry flurstueckGeometry = (Geometry)result.get(key);
                    List<RebeCustomBean> rechteUndBelastungen = this.getRechteUndBelastungen(flurstueckGeometry);
                    boolean hasReBe = !rechteUndBelastungen.isEmpty();
                    List<MipaCustomBean> mipas = this.getMiPas(flurstueckGeometry);
                    boolean bl = hasMiPa = !mipas.isEmpty();
                    if (hasReBe || hasMiPa) {
                        HistoricNoSucessorDialog.getInstance().setHistorischDatum(date);
                        StaticSwingTools.showDialog((JDialog)HistoricNoSucessorDialog.getInstance());
                        if (HistoricNoSucessorDialog.getInstance().isAbort()) {
                            throw new ActionNotSuccessfulException("Die Aktion wurde vom Benutzer abgebrochen.");
                        }
                        rebeLoeschDatum = HistoricNoSucessorDialog.getInstance().getRebeLoeschDatum();
                        mipaVertragsendeDatum = HistoricNoSucessorDialog.getInstance().getMipaVertragsendeDatum();
                    } else {
                        rebeLoeschDatum = null;
                        mipaVertragsendeDatum = null;
                    }
                    if (rebeLoeschDatum != null) {
                        for (MipaCustomBean mipa : mipas) {
                            mipa.setVertragsende(mipaVertragsendeDatum);
                            mipa.persist();
                        }
                        for (RebeCustomBean rebe : rechteUndBelastungen) {
                            rebe.setDatumLoeschung(rebeLoeschDatum);
                            rebe.persist();
                        }
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Flurstueck war schon mal staedtisch wird historisch gesetzt");
                }
                if (key.getGueltigBis() != null) return;
                if (!"st\u00e4dtisch".equals(key.getFlurstueckArt().getBezeichnung())) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Flurstueck ist nicht st\u00e4dtisch");
                    }
                    FlurstueckArtCustomBean abteilungIX = null;
                    for (FlurstueckArtCustomBean current : this.getAllFlurstueckArten()) {
                        if (!"Abteilung IX".equals(current.getBezeichnung())) continue;
                        abteilungIX = current;
                    }
                    if (abteilungIX == null) {
                        throw new ActionNotSuccessfulException("Flurst\u00fccksart AbteilungIX konnte nicht gefunden werden.");
                    }
                    if (!"Abteilung IX".equals(key.getFlurstueckArt().getBezeichnung())) throw new ActionNotSuccessfulException("Die Flurst\u00fcckart st\u00e4dtisch ist nicht in der Datenbank");
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Flurst\u00fcck ist Abteilung IX  --> alle Rechte werden entfernt");
                    }
                    flurstueck.getFlurstueckSchluessel().setFlurstueckArt(abteilungIX);
                    if (flurstueck.getFlurstueckSchluessel().getDatumLetzterStadtbesitz() != null) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"Setze Gueltigbis Datum des Flurstueks auf letzten Stadtbesitz");
                        }
                        Date letzterStadtbesitzDate = flurstueck.getFlurstueckSchluessel().getDatumLetzterStadtbesitz();
                        flurstueck.getFlurstueckSchluessel().setGueltigBis(letzterStadtbesitzDate);
                        for (NutzungCustomBean nutzung : flurstueck.getNutzungen()) {
                            nutzung.setHistorisch(true);
                            nutzung.persist();
                            for (NutzungBuchungCustomBean buchung : nutzung.getNutzungsBuchungen()) {
                                if (buchung.getGueltig_bis() != null && !buchung.getGueltig_bis().after(letzterStadtbesitzDate)) continue;
                                buchung.setGueltigbis(letzterStadtbesitzDate);
                            }
                        }
                    } else {
                        if (!LOG.isDebugEnabled()) throw new ActionNotSuccessfulException("Das Flurst\u00fcck war schon mal in Stadtbesitz, aber es existiert kein Datum wann");
                        LOG.debug((Object)"Achtung war schon in Stadtbesitz hat aber kein Datum");
                        throw new ActionNotSuccessfulException("Das Flurst\u00fcck war schon mal in Stadtbesitz, aber es existiert kein Datum wann");
                    }
                    flurstueck.persist();
                    return;
                } else {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Flurst\u00fcck ist st\u00e4dtisch und wird historisch gesetzt");
                    }
                    key.setDatumLetzterStadtbesitz(date);
                    key.setGueltigBis(date);
                    for (NutzungCustomBean nutzung : flurstueck.getNutzungen()) {
                        nutzung.setHistorisch(true);
                        nutzung.persist();
                        for (NutzungBuchungCustomBean buchung : nutzung.getNutzungsBuchungen()) {
                            if (buchung.getGueltig_bis() != null && !buchung.getGueltig_bis().after(date)) continue;
                            buchung.setGueltigbis(date);
                        }
                    }
                    flurstueck.persist();
                }
                return;
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Flurstueck war noch nie staedtisch wird historisch gesetzt");
                }
                key.setGueltigBis(date);
                key.persist();
            }
            return;
        }
        catch (Exception ex) {
            LOG.error((Object)"Fehler beim historisch setzen eines Flurst\u00fccks", (Throwable)ex);
            if (!(ex instanceof ActionNotSuccessfulException)) throw new ActionNotSuccessfulException("Ein Unbekannter Ausnamefehler ist aufgetreten. Bitte wenden Sie sich an Ihren Systemadministrator.", ex);
            throw (ActionNotSuccessfulException)ex;
        }
    }

    public boolean hasFlurstueckSucccessors(FlurstueckSchluesselCustomBean flurstueckSchluessel) throws ActionNotSuccessfulException {
        MetaClass metaclass;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Suche Nachfolger f\u00fcr Flurst\u00fcck");
            LOG.debug((Object)("ID des Schluessels ist: " + flurstueckSchluessel.getId()));
        }
        if ((metaclass = CidsBroker.getInstance().getLagisMetaClass("flurstueck_historie")) == null) {
            return false;
        }
        String query = "SELECT    " + metaclass.getID() + ",    " + metaclass.getTableName() + "." + metaclass.getPrimaryKey() + " FROM    " + metaclass.getTableName() + ",    flurstueck WHERE    " + metaclass.getTableName() + ".fk_vorgaenger = flurstueck.id    AND flurstueck.fk_flurstueck_schluessel = " + flurstueckSchluessel.getId();
        MetaObject[] mos = CidsBroker.getInstance().getLagisMetaObject(query);
        if (mos != null) {
            if (mos.length == 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Ergebnisliste ist leer");
                }
                return false;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Suche lieferte mindestens ein Ergebnis zur\u00fcck");
            }
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Suche lieferte kein Ergebnis zur\u00fcck");
        }
        return false;
    }

    public boolean setFlurstueckActive(FlurstueckSchluesselCustomBean key) throws ActionNotSuccessfulException {
        key.setLetzter_bearbeiter(this.getAccountName());
        key.setLetzte_bearbeitung(this.getCurrentDate());
        try {
            if (key.getGueltigBis() != null) {
                if (!this.hasFlurstueckSucccessors(key)) {
                    if (key.getFlurstueckArt() == null || key.getFlurstueckArt().getBezeichnung() == null) {
                        throw new ActionNotSuccessfulException("Das Flurst\u00fcck kann nicht aktiviert werden, weil es keine Flurst\u00fccksart besitzt");
                    }
                    if ("st\u00e4dtisch".equals(key.getFlurstueckArt().getBezeichnung())) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"St\u00e4dtisches Flurst\u00fcck wurde reactiviert");
                        }
                        Date currentDate = new Date();
                        key.setEntstehungsDatum(currentDate);
                        key.setDatumLetzterStadtbesitz(currentDate);
                    }
                    key.setGueltigBis(null);
                    key.persist();
                    return true;
                }
                throw new ActionNotSuccessfulException("Das Flurst\u00fcck kann nicht aktiviert werden, weil es Nachfolger hat");
            }
            throw new ActionNotSuccessfulException("Das Flurst\u00fcck war aktiv");
        }
        catch (Exception ex) {
            LOG.error((Object)"Fehler beim historisch setzen eines Flurst\u00fccks", (Throwable)ex);
            throw new ActionNotSuccessfulException("Ein Unbekannter Ausnamefehler ist aufgetreten. Bitte wenden Sie sich an Ihren Systemadministrator.", ex);
        }
    }

    public void bookNutzungenForFlurstueck(FlurstueckSchluesselCustomBean key, String username) throws ActionNotSuccessfulException {
        key.setLetzter_bearbeiter(this.getAccountName());
        key.setLetzte_bearbeitung(this.getCurrentDate());
    }

    public Collection<AnlageklasseCustomBean> getAllAnlageklassen() {
        return this.getAllOf("anlageklasse");
    }

    public Collection<VertragsartCustomBean> getAllVertragsarten() {
        return this.getAllOf("vertragsart");
    }

    public Collection<MipaKategorieCustomBean> getAllMiPaKategorien() {
        return this.getAllOf("mipa_kategorie");
    }

    public Collection<BaumKategorieCustomBean> getAllBaumKategorien() {
        return this.getAllOf("baum_kategorie");
    }

    public Collection<VerwaltendeDienststelleCustomBean> getAllVerwaltendeDienstellen() {
        return this.getAllOf("verwaltende_dienststelle");
    }

    public Collection<ZusatzRolleArtCustomBean> getAllZusatzRolleArten() {
        return this.getAllOf("zusatz_rolle_art");
    }

    private Collection getAllOf(String metaClassName) {
        MetaClass metaclass = CidsBroker.getInstance().getLagisMetaClass(metaClassName);
        if (metaclass == null) {
            return null;
        }
        MetaObject[] mos = CidsBroker.getInstance().getLagisMetaObject("SELECT " + metaclass.getID() + ", " + metaclass.getTableName() + "." + metaclass.getPrimaryKey() + " FROM " + metaclass.getTableName());
        HashSet<CidsBean> beans = new HashSet<CidsBean>();
        for (MetaObject metaObject : mos) {
            beans.add(metaObject.getBean());
        }
        return beans;
    }

    public Collection<RebeArtCustomBean> getAllRebeArten() {
        return this.getAllOf("rebe_art");
    }

    public Collection<NutzungsartCustomBean> getAllNutzungsarten() {
        return this.getAllOf("nutzungsart");
    }

    public Collection<BeschlussartCustomBean> getAllBeschlussarten() {
        return this.getAllOf("beschlussart");
    }

    public Collection<KostenartCustomBean> getAllKostenarten() {
        return this.getAllOf("kostenart");
    }

    public Collection<MipaMerkmalCustomBean> getAllMiPaMerkmale() {
        return this.getAllOf("mipa_merkmal");
    }

    public Collection<BaumMerkmalCustomBean> getAllBaumMerkmale() {
        return this.getAllOf("baum_merkmal");
    }

    public Collection<FlurstueckArtCustomBean> getAllFlurstueckArten() {
        return this.getAllOf("flurstueck_art");
    }

    public FlurstueckSchluesselCustomBean completeFlurstueckSchluessel(FlurstueckSchluesselCustomBean flurstueckSchluessel) {
        return FlurstueckSchluesselCustomBean.createNewByFsKey(flurstueckSchluessel);
    }

    public FlurstueckCustomBean createFlurstueck(FlurstueckSchluesselCustomBean key) {
        key.setLetzter_bearbeiter(this.getAccountName());
        key.setLetzte_bearbeitung(this.getCurrentDate());
        try {
            FlurstueckSchluesselCustomBean checkedKey;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"createFlurstueck: key ist != null");
            }
            if ((checkedKey = this.completeFlurstueckSchluessel(key)) != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"createFlurstueck: Vervollst\u00e4ndigter key ist == null");
                }
                return null;
            }
            FlurstueckCustomBean newFlurstueck = FlurstueckCustomBean.createNew();
            Date datumEntstehung = new Date();
            key.setEntstehungsDatum(datumEntstehung);
            key.setIstGesperrt(false);
            newFlurstueck.setFlurstueckSchluessel(key);
            this.checkIfFlurstueckWasStaedtisch(key, datumEntstehung);
            newFlurstueck.persist();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"createFlurstueck: neues Flurst\u00fcck erzeugt");
            }
            return this.retrieveFlurstueck(key);
        }
        catch (Exception ex) {
            LOG.error((Object)"Fehler beim anlegen des Flurst\u00fccks", (Throwable)ex);
            return null;
        }
    }

    public boolean isFlurstueckHistoric(FlurstueckSchluesselCustomBean key) {
        return key.getGueltigBis() != null;
    }

    public Collection<FlurstueckHistorieCustomBean> getHistorySuccessor(FlurstueckSchluesselCustomBean flurstueckSchluessel) {
        MetaClass metaclass;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Suche Nachfolger f\u00fcr Flurst\u00fcck");
        }
        if ((metaclass = CidsBroker.getInstance().getLagisMetaClass("flurstueck_historie")) == null) {
            return null;
        }
        String query = "SELECT    " + metaclass.getID() + ",    " + metaclass.getTableName() + "." + metaclass.getPrimaryKey() + " FROM    " + metaclass.getTableName() + ",    flurstueck WHERE    " + metaclass.getTableName() + ".fk_vorgaenger = flurstueck.id    AND flurstueck.fk_flurstueck_schluessel = " + flurstueckSchluessel.getId();
        MetaObject[] mos = CidsBroker.getInstance().getLagisMetaObject(query);
        HashSet<FlurstueckHistorieCustomBean> historyEntries = new HashSet<FlurstueckHistorieCustomBean>();
        for (MetaObject metaObject : mos) {
            historyEntries.add((FlurstueckHistorieCustomBean)metaObject.getBean());
        }
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("ID des Schluessels ist: " + flurstueckSchluessel));
            }
            if (historyEntries != null) {
                if (historyEntries.isEmpty()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Ergebnisliste ist leer");
                    }
                    return null;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Suche lieferte mindestens ein Ergebnis zur\u00fcck");
                }
                return historyEntries;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Suche lieferte kein Ergebnis zur\u00fcck");
            }
            return null;
        }
        catch (Exception ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Fehler beim suchen der Nachfolger eines Flurst\u00fccks", (Throwable)ex);
            }
            return null;
        }
    }

    private void checkIfFlurstueckWasStaedtisch(FlurstueckSchluesselCustomBean key, Date useDate) {
        FlurstueckArtCustomBean art = key.getFlurstueckArt();
        if (!key.getWarStaedtisch()) {
            if ("st\u00e4dtisch".equals(art.getBezeichnung())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Flurst\u00fcck ist St\u00e4dtisch Datum letzter Stadtbesitz wird geupdated");
                }
                key.setWarStaedtisch(true);
                if (useDate != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Flurst\u00fcck wurde neu angelegt und ist st\u00e4dtisch");
                    }
                    key.setDatumLetzterStadtbesitz(useDate);
                } else {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Flurst\u00fcck war noch nie in Stadtbesitz und wird jetzt hinzugef\u00fcgt");
                    }
                    Date currentDate = new Date();
                    key.setDatumLetzterStadtbesitz(currentDate);
                    key.setEntstehungsDatum(currentDate);
                }
            }
        } else if (key.getFlurstueckArt() != null && key.getFlurstueckArt().getBezeichnung() != null && "st\u00e4dtisch".equals(key.getFlurstueckArt().getBezeichnung())) {
            FlurstueckSchluesselCustomBean oldSchluessel;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Flurst\u00fcck war und ist St\u00e4dtisch --> Datum wird geupdated");
            }
            Date currentDate = new Date();
            if (useDate != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Dieser Fall sollte nicht vorkommen");
                }
                key.setDatumLetzterStadtbesitz(useDate);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Datum letzter Stadt_besitz geupdated");
                }
            } else {
                key.setDatumLetzterStadtbesitz(currentDate);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Datum letzter Stadt_besitz geupdated");
                }
            }
            if ((oldSchluessel = (FlurstueckSchluesselCustomBean)CidsBroker.getInstance().getLagisMetaObject(key.getId(), CidsBroker.getInstance().getLagisMetaClass("flurstueck_schluessel").getId()).getBean()) != null && oldSchluessel.getFlurstueckArt() != null && oldSchluessel.getFlurstueckArt().getBezeichnung() != null && !FlurstueckArtCustomBean.FLURSTUECK_ART_EQUALATOR.pedanticEquals(oldSchluessel.getFlurstueckArt(), key.getFlurstueckArt()) && "st\u00e4dtisch".equals(key.getFlurstueckArt().getBezeichnung())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Flurst\u00fcck kommt erneut in den Stadtbesitz --> entstehungsDatum wird geupdated");
                }
                if (useDate != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"sollte nicht vorkkommen");
                    }
                    key.setEntstehungsDatum(useDate);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Datum Entstehung geupdated");
                    }
                } else {
                    key.setEntstehungsDatum(currentDate);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Datum Entstehung geupdated");
                    }
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Kein wechsel von irgendeiner Flurst\u00fccksart nach st\u00e4dtisch --> kein Update");
            }
        }
    }

    private boolean existHistoryEntry(FlurstueckCustomBean flurstueckToCheck) {
        MetaClass metaclass;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Suche History Eintr\u00e4ge");
        }
        if ((metaclass = CidsBroker.getInstance().getLagisMetaClass("flurstueck_historie")) == null) {
            return false;
        }
        String query = "SELECT " + metaclass.getID() + ", " + metaclass.getTableName() + "." + metaclass.getPrimaryKey() + " FROM " + metaclass.getTableName() + " WHERE " + metaclass.getTableName() + ".fk_vorgaenger = " + flurstueckToCheck.getId();
        MetaObject[] mos = CidsBroker.getInstance().getLagisMetaObject(query);
        if (mos != null && mos.length > 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Es existiert ein History Eintrag");
                LOG.debug((Object)"Es gibt schon einen Nachfolger");
            }
            return true;
        }
        return false;
    }

    private void processNutzungen(Collection<NutzungCustomBean> nutzungen, String flurstueckKey) throws ErrorInNutzungProcessingException {
        try {
            if (nutzungen != null && nutzungen.size() > 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Anzahl Ketten in aktuellem Flurst\u00fcck: " + nutzungen.size()));
                }
                Date bookingDate = new Date();
                for (NutzungCustomBean curNutzung : nutzungen) {
                    Collection<Nutzung.NUTZUNG_STATES> nutzungsState = curNutzung.getNutzungsState();
                    if (nutzungsState.isEmpty()) {
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)"Keine \u00c4nderung");
                        continue;
                    }
                    if (nutzungsState.contains((Object)Nutzung.NUTZUNG_STATES.NUTZUNG_CREATED)) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"Neue Nutzung angelegt.");
                        }
                        curNutzung.getBuchwert().setGueltigvon(bookingDate);
                        continue;
                    }
                    if (nutzungsState.contains((Object)Nutzung.NUTZUNG_STATES.NUTZUNG_CHANGED)) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Nutzungskette wurde modifiziert " + Arrays.deepToString(nutzungsState.toArray())));
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"Setzte Datum f\u00fcr die letzten beiden Buchungen");
                        }
                        curNutzung.getOpenBuchung().setGueltigvon(bookingDate);
                        curNutzung.getPreviousBuchung().setGueltigbis(bookingDate);
                        if (nutzungsState.contains((Object)Nutzung.NUTZUNG_STATES.NUTZUNGSART_CHANGED) && LOG.isDebugEnabled()) {
                            LOG.debug((Object)"Nutzungsart wurde ge\u00e4ndert.");
                        }
                        if (nutzungsState.contains((Object)Nutzung.NUTZUNG_STATES.STILLE_RESERVE_CREATED)) {
                            if (!LOG.isDebugEnabled()) continue;
                            LOG.debug((Object)"Stille Reserve wurde gebildet.");
                            continue;
                        }
                        if (nutzungsState.contains((Object)Nutzung.NUTZUNG_STATES.STILLE_RESERVE_INCREASED)) {
                            if (!LOG.isDebugEnabled()) continue;
                            LOG.debug((Object)"Vorhandene Stille Reserve wurde erh\u00f6ht.");
                            continue;
                        }
                        if (nutzungsState.contains((Object)Nutzung.NUTZUNG_STATES.STILLE_RESERVE_DECREASED)) {
                            if (!LOG.isDebugEnabled()) continue;
                            LOG.debug((Object)"Vorhandene Stille Reserve wurde vermindert.");
                            continue;
                        }
                        if (nutzungsState.contains((Object)Nutzung.NUTZUNG_STATES.STILLE_RESERVE_DISOLVED)) {
                            if (!LOG.isDebugEnabled()) continue;
                            LOG.debug((Object)"Vorhandene Stille Reserve wurde vollst\u00e4ndig aufgebraucht.");
                            continue;
                        }
                        if (nutzungsState.contains((Object)Nutzung.NUTZUNG_STATES.POSITIVE_BUCHUNG)) {
                            if (!LOG.isDebugEnabled()) continue;
                            LOG.debug((Object)"Positive Buchung ohne Stille Reserve.");
                            continue;
                        }
                        if (!nutzungsState.contains((Object)Nutzung.NUTZUNG_STATES.NEGATIVE_BUCHUNG) || !LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)"Negative Buchung ohne Stille Reserve.");
                        continue;
                    }
                    if (nutzungsState.contains((Object)Nutzung.NUTZUNG_STATES.NUTZUNG_TERMINATED)) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"Nutzungskette wurde terminiert, setze Buchungsdatum");
                        }
                        curNutzung.getTerminalBuchung().setGueltigbis(bookingDate);
                        continue;
                    }
                    if (nutzungsState.contains((Object)Nutzung.NUTZUNG_STATES.BUCHUNG_CREATED)) {
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)"neue Buchung . Nachricht an Zust\u00e4ndige");
                        continue;
                    }
                    throw new Exception("Kein Fall trifft auf Stati zu: " + Arrays.toString(nutzungsState.toArray()));
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Flurst\u00fcck besitzt keine Nutzungen.");
            }
        }
        catch (Exception ex) {
            throw new ErrorInNutzungProcessingException("Nutzungen konnten nicht verarbeitet werden", ex);
        }
    }

    private void createHistoryEdge(FlurstueckCustomBean oldFlurstueck, FlurstueckCustomBean newFlurstueck) {
        FlurstueckHistorieCustomBean historyEntry = FlurstueckHistorieCustomBean.createNew();
        historyEntry.setVorgaenger(oldFlurstueck);
        historyEntry.setNachfolger(newFlurstueck);
        this.createFlurstueckHistoryEntry(historyEntry);
    }

    public Collection<FlurstueckHistorieCustomBean> getAllHistoryEntries(FlurstueckSchluesselCustomBean schluessel) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Sammle Alle Knoten (Rekursiv) f\u00fcr: " + schluessel));
        }
        HashSet<FlurstueckHistorieCustomBean> allEdges = new HashSet<FlurstueckHistorieCustomBean>();
        try {
            Collection<FlurstueckHistorieCustomBean> childEdges = this.getHistoryPredecessors(schluessel);
            if (childEdges != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Es gibt Kanten zu diesem Knoten");
                }
                allEdges.addAll(childEdges);
                Iterator<FlurstueckHistorieCustomBean> it = childEdges.iterator();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Rufe Methode Rekursiv auf f\u00fcr alle Gefundenen Knoten");
                }
                while (it.hasNext()) {
                    childEdges = this.getAllHistoryEntries(it.next().getVorgaenger().getFlurstueckSchluessel());
                    if (childEdges == null) continue;
                    allEdges.addAll(childEdges);
                }
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Es gibt keine Kanten zu diesem Knoten");
                }
                return allEdges;
            }
            return allEdges;
        }
        catch (Exception ex) {
            LOG.error((Object)"Fehler beim sammeln aller Kanten", (Throwable)ex);
            return allEdges;
        }
    }

    public FlurstueckCustomBean joinFlurstuecke(ArrayList<FlurstueckSchluesselCustomBean> joinMembers, FlurstueckSchluesselCustomBean newFlurstueckSchluessel, String benutzerkonto) throws ActionNotSuccessfulException {
        for (FlurstueckSchluesselCustomBean key : joinMembers) {
            key.setLetzter_bearbeiter(this.getAccountName());
            key.setLetzte_bearbeitung(this.getCurrentDate());
        }
        newFlurstueckSchluessel.setLetzter_bearbeiter(this.getAccountName());
        newFlurstueckSchluessel.setLetzte_bearbeitung(this.getCurrentDate());
        ArrayList<CidsBean> locks = new ArrayList<CidsBean>();
        try {
            if (joinMembers != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Es sind joinMember vorhanden.");
                }
                for (FlurstueckSchluesselCustomBean currentKey : joinMembers) {
                    CidsBean tmpLock = this.isLocked(currentKey);
                    if (tmpLock == null) {
                        tmpLock = this.createFlurstueckSchluesselLock(currentKey);
                        if (tmpLock == null) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("Anlegen einer Sperre f\u00fcr das Flurst\u00fcck nicht m\u00f6glich " + currentKey.getKeyString() + "."));
                            }
                            this.releaseLocks(locks);
                            throw new ActionNotSuccessfulException("Anlegen einer Sperre f\u00fcr das Flurst\u00fcck " + currentKey.getKeyString() + " nicht m\u00f6glich.");
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Sperre f\u00fcr Flurst\u00fcck " + currentKey.getKeyString() + " Erfolgreich angelegt."));
                        }
                        locks.add(tmpLock);
                        continue;
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Es exisitert bereits eine Sperre f\u00fcr das Flurst\u00fcck " + currentKey.getKeyString() + " und wird von dem Benutzer " + (String)tmpLock.getProperty("user_string") + " gehalten."));
                    }
                    this.releaseLocks(locks);
                    throw new ActionNotSuccessfulException("Es exisitert bereits eine Sperre f\u00fcr das Flurst\u00fcck " + currentKey.getKeyString() + " und wird von dem Benutzer " + (String)tmpLock.getProperty("user_string") + " gehalten.");
                }
                Iterator<FlurstueckSchluesselCustomBean> it = joinMembers.iterator();
                FlurstueckCustomBean newFlurstueck = this.createFlurstueck(newFlurstueckSchluessel);
                if (newFlurstueck != null) {
                    while (it.hasNext()) {
                        FlurstueckCustomBean oldFlurstueck = this.retrieveFlurstueck(it.next());
                        this.setFlurstueckHistoric(oldFlurstueck.getFlurstueckSchluessel());
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"Flurst\u00fcck wurde Historisch gesetzt.");
                        }
                        if (!this.existHistoryEntry(oldFlurstueck)) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)"Es exitieren kein History Eintrag --> keine Kante zu einem anderen Flurst\u00fcck.");
                                LOG.debug((Object)"Erzeuge History Eintrag f\u00fcr alte Flurst\u00fccke.");
                            }
                            this.createHistoryEdge(oldFlurstueck, newFlurstueck);
                            if (!LOG.isDebugEnabled()) continue;
                            LOG.debug((Object)"Neuer History Eintrag f\u00fcr Flurst\u00fcck erzeugt.");
                            continue;
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Es sind bereits Historieneintr\u00e4ge f\u00fcr das Flurst\u00fcck " + oldFlurstueck.getFlurstueckSchluessel().getKeyString() + " vorhanden."));
                        }
                        this.releaseLocks(locks);
                        throw new ActionNotSuccessfulException("Es sind bereits Historieneintr\u00e4ge f\u00fcr das Flurst\u00fcck " + oldFlurstueck.getFlurstueckSchluessel().getKeyString() + " vorhanden.");
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Flurst\u00fccke Erfolgreich gejoined");
                    }
                    this.releaseLocks(locks);
                    return newFlurstueck;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Das Anlegen des neuen Flurst\u00fccks " + newFlurstueckSchluessel.getKeyString() + " schlug fehl."));
                }
                this.releaseLocks(locks);
                throw new ActionNotSuccessfulException("Das Anlegen des neuen Flurst\u00fccks " + newFlurstueckSchluessel.getKeyString() + " schlug fehl.");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Es wurden keine Flurst\u00fccke angeben f\u00fcr die Zusammenlegung.");
            }
            throw new ActionNotSuccessfulException("Es wurden keine Flurst\u00fccke angeben f\u00fcr die Zusammenlegung.");
        }
        catch (ActionNotSuccessfulException ex) {
            throw ex;
        }
        catch (Exception ex) {
            LOG.error((Object)"Unbekannter Fehler beim joinen von Flurst\u00fccken.", (Throwable)ex);
            this.releaseLocks(locks);
            throw new ActionNotSuccessfulException("Ein Unbekannter Ausnamefehler ist aufgetreten. Bitte wenden Sie sich an Ihren Systemadministrator.", ex);
        }
    }

    public void splitFlurstuecke(FlurstueckSchluesselCustomBean oldFlurstueckSchluessel, ArrayList<FlurstueckSchluesselCustomBean> splitMembers, String benutzerkonto) throws ActionNotSuccessfulException {
        for (FlurstueckSchluesselCustomBean key : splitMembers) {
            key.setLetzter_bearbeiter(this.getAccountName());
            key.setLetzte_bearbeitung(this.getCurrentDate());
        }
        oldFlurstueckSchluessel.setLetzter_bearbeiter(benutzerkonto);
        oldFlurstueckSchluessel.setLetzte_bearbeitung(this.getCurrentDate());
        CidsBean lock = null;
        try {
            ArrayList locks = new ArrayList();
            if (splitMembers != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Es sind Flurst\u00fccke zum splitten vorhanden");
                }
                if (this.isLocked(oldFlurstueckSchluessel) == null) {
                    lock = this.createFlurstueckSchluesselLock(oldFlurstueckSchluessel);
                    if (lock == null) {
                        throw new ActionNotSuccessfulException("Anlegen einer Sperre f\u00fcr das alte Flurst\u00fcck nicht m\u00f6glich");
                    }
                } else {
                    throw new ActionNotSuccessfulException("Es exisitert bereits eine Sperre f\u00fcr das alte Flurst\u00fcck, das gesplittet werden soll");
                }
                Iterator<FlurstueckSchluesselCustomBean> it = splitMembers.iterator();
                FlurstueckCustomBean oldFlurstueck = this.retrieveFlurstueck(oldFlurstueckSchluessel);
                this.setFlurstueckHistoric(oldFlurstueck.getFlurstueckSchluessel());
                if (!this.existHistoryEntry(oldFlurstueck)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Es exitieren kein History Eintrag --> keine Kante zu einem anderen Flurst\u00fcck");
                    }
                } else {
                    this.releaseLock(lock);
                    throw new ActionNotSuccessfulException("Spliten des Flurst\u00fccks nicht m\u00f6glich, es gibt schon einen Nachfolger");
                }
                while (it.hasNext()) {
                    FlurstueckCustomBean newFlurstueck = this.createFlurstueck(it.next());
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Neus Flurst\u00fcck aus Split erzeugt");
                    }
                    if (newFlurstueck != null) {
                        this.createHistoryEdge(oldFlurstueck, newFlurstueck);
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)"Neuer History Eintrag f\u00fcr Flurst\u00fcck erzeugt");
                        continue;
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Fehler beim anlegen eines Flurst\u00fccks");
                    }
                    this.releaseLock(lock);
                    return;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Splitten der Flurst\u00fccke erforgreich");
                }
                this.releaseLock(lock);
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"split der Flurst\u00fccke nicht erfolgreich");
            }
            this.releaseLock(lock);
        }
        catch (Exception ex) {
            LOG.error((Object)"Fehler beim splitten von Flurst\u00fccken", (Throwable)ex);
            if (ex instanceof ActionNotSuccessfulException) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Eine Aktion ging schief Exception wird weitergereicht");
                }
                this.releaseLock(lock);
                throw (ActionNotSuccessfulException)ex;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Unbekannte Excepiton");
            }
            this.releaseLock(lock);
            throw new ActionNotSuccessfulException("Ein Unbekannter Ausnamefehler ist aufgetreten. Bitte wenden Sie sich an Ihren Systemadministrator", ex);
        }
    }

    public void joinSplitFlurstuecke(ArrayList<FlurstueckSchluesselCustomBean> joinMembers, ArrayList<FlurstueckSchluesselCustomBean> splitMembers, String benutzerkonto) throws ActionNotSuccessfulException {
        for (FlurstueckSchluesselCustomBean key : joinMembers) {
            key.setLetzter_bearbeiter(benutzerkonto);
            key.setLetzte_bearbeitung(this.getCurrentDate());
        }
        for (FlurstueckSchluesselCustomBean key : splitMembers) {
            key.setLetzter_bearbeiter(benutzerkonto);
            key.setLetzte_bearbeitung(this.getCurrentDate());
        }
        try {
            FlurstueckSchluesselCustomBean dummySchluessel = FlurstueckSchluesselCustomBean.createNew();
            for (FlurstueckArtCustomBean current : this.getAllFlurstueckArten()) {
                if (!"pseudo".equals(current.getBezeichnung())) continue;
                dummySchluessel.setFlurstueckArt(current);
                break;
            }
            dummySchluessel = (FlurstueckSchluesselCustomBean)dummySchluessel.persist();
            this.joinFlurstuecke(joinMembers, dummySchluessel, benutzerkonto);
            this.splitFlurstuecke(dummySchluessel, splitMembers, benutzerkonto);
        }
        catch (Exception ex) {
            if (ex instanceof ActionNotSuccessfulException) {
                LOG.error((Object)"Eine ActionSchlug fehl", (Throwable)ex);
                throw (ActionNotSuccessfulException)ex;
            }
            LOG.error((Object)"Fehler beim joinSplit", (Throwable)ex);
            throw new ActionNotSuccessfulException("Ein Unbekannter Ausnamefehler ist aufgetreten. Bitte wenden Sie sich an Ihren Systemadministrator", ex);
        }
    }

    public boolean isInEditMode() {
        return !this.currentLocks.isEmpty();
    }

    public boolean validateWidgets() {
        for (Widget currentWidget : this.widgets) {
            if (currentWidget.getStatus() != 2) continue;
            this.currentValidationErrorMessage = currentWidget.getValidationMessage();
            if (this.currentValidationErrorMessage == null) {
                this.currentValidationErrorMessage = "Kein Fehlertext vorhanden";
            }
            return false;
        }
        return true;
    }

    public synchronized void reloadFlurstueck() {
        if (this.currentFlurstueck != null) {
            LOG.info((Object)"reloadFlurstueck");
            this.resetWidgets();
            this.loadFlurstueck(this.currentFlurstueck.getFlurstueckSchluessel());
        } else {
            LOG.info((Object)"can't reload flurstueck == null");
        }
    }

    public synchronized void reloadFlurstueckKeys() {
        LOG.info((Object)"updateFlurstueckKeys");
        this.requester.updateFlurstueckKeys();
    }

    public synchronized void loadFlurstueck(FlurstueckSchluesselCustomBean key) {
        if (this.isInEditMode()) {
            JOptionPane.showMessageDialog(LagisApp.getInstance(), "Das Flurst\u00fcck kann nur gewechselt werden wenn alle \u00c4nderungen gespeichert oder verworfen worden sind.", "Wechseln nicht m\u00f6glich", 2);
            return;
        }
        LOG.info((Object)"loadFlurstueck");
        this.resetWidgets();
        this.requester.requestFlurstueck(key);
    }

    public FlurstueckRequester getRequester() {
        return this.requester;
    }

    public void setRequester(FlurstueckRequester requester) {
        this.requester = requester;
    }

    public void saveCurrentFlurstueck() {
        try {
            this.messages = new Vector();
            if (this.currentFlurstueck != null) {
                for (Widget curWidget : this.widgets) {
                    if (!(curWidget instanceof FlurstueckSaver)) continue;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Daten von: " + curWidget.getWidgetName() + " werden gespeichert"));
                    }
                    ((FlurstueckSaver)((Object)curWidget)).updateFlurstueckForSaving(this.currentFlurstueck);
                }
                try {
                    FlurstueckCustomBean origFlurstueck = this.retrieveFlurstueck(this.currentFlurstueck.getFlurstueckSchluessel());
                    Collection<VerwaltungsbereichCustomBean> oldBereiche = origFlurstueck.getVerwaltungsbereiche();
                    Collection<VerwaltungsbereichCustomBean> newBereiche = this.currentFlurstueck.getVerwaltungsbereiche();
                    if ((oldBereiche == null || oldBereiche.isEmpty()) && (newBereiche == null || newBereiche.isEmpty())) {
                        LOG.info((Object)"Es existieren keine Verwaltungsbereiche --> keine Ver\u00e4nderung");
                    } else if (oldBereiche == null || oldBereiche.isEmpty()) {
                        LOG.info((Object)("Es wurden nur neue Verwaltungsbereiche angelegt: " + newBereiche.size()));
                        for (VerwaltungsbereichCustomBean currentBereich : newBereiche) {
                            try {
                                VerwaltendeDienststelleCustomBean currentDienstelle = currentBereich.getDienststelle();
                                if (currentDienstelle != null) {
                                    this.messages.add(Message.createNewMessage(3, 0, currentDienstelle));
                                    continue;
                                }
                                if (!LOG.isDebugEnabled()) continue;
                                LOG.debug((Object)"neuer Verwaltungsbereich angelegt ohne Dienstellenzuordnung");
                            }
                            catch (Exception ex) {
                                LOG.error((Object)"Fehler beim pr\u00fcfen eines neuen Verwaltungsbereichs", (Throwable)ex);
                                this.messages.add(Message.createNewMessage(1, 5, "Es wurden nur neue Flurst\u00fccke angelegt. Fehler beim Pr\u00fcfen eines Verwaltungsgebrauchs", ex, currentBereich));
                            }
                        }
                    } else if (newBereiche == null || newBereiche.isEmpty()) {
                        LOG.info((Object)("Es wurden alle alten Verwaltungsbereiche gel\u00f6scht: " + oldBereiche.size()));
                        for (VerwaltungsbereichCustomBean currentBereich : oldBereiche) {
                            try {
                                this.messages.add(Message.createNewMessage(3, 1, currentBereich.getDienststelle()));
                            }
                            catch (Exception ex) {
                                LOG.error((Object)"Fehler beim pr\u00fcfen eines alten Verwaltungsbereichs", (Throwable)ex);
                                this.messages.add(Message.createNewMessage(1, 5, "Es wurden alle Verwaltungsbereiche gel\u00f6scht. Fehler beim erzeugen der Benutzernachrichten", ex, currentBereich));
                            }
                        }
                    } else {
                        LOG.info((Object)"Es exitieren sowohl alte wie neue Verwaltungsbereiche -> abgleich");
                        Vector<Message> modDienststellen = new Vector<Message>();
                        Vector<Message> addedDienststellen = new Vector<Message>();
                        Vector<Message> deletedDienststellen = new Vector<Message>();
                        Vector<VerwaltungsbereichCustomBean> oldBereicheVector = new Vector<VerwaltungsbereichCustomBean>(oldBereiche);
                        Vector<VerwaltungsbereichCustomBean> newBereicheVector = new Vector<VerwaltungsbereichCustomBean>(newBereiche);
                        for (VerwaltungsbereichCustomBean currentBereich : newBereiche) {
                            try {
                                if (!(currentBereich.getId() != null && currentBereich.getId() != -1 || oldBereiche.contains(currentBereich))) {
                                    LOG.info((Object)("Es wurden ein neuer Verwaltungsbereich angelegt: " + currentBereich));
                                    VerwaltendeDienststelleCustomBean currentDienstelle = currentBereich.getDienststelle();
                                    if (currentDienstelle != null) {
                                        addedDienststellen.add(Message.createNewMessage(3, 0, currentDienstelle));
                                        continue;
                                    }
                                    if (!LOG.isDebugEnabled()) continue;
                                    LOG.debug((Object)"neuer Verwaltungsbereich angelegt ohne Dienstellenzuordnung");
                                    continue;
                                }
                                if (currentBereich.getId() != null && currentBereich.getId() != -1 && oldBereiche.contains(currentBereich)) {
                                    int index = oldBereicheVector.indexOf(currentBereich);
                                    LOG.info((Object)("Verwaltungsbereich war schon in Datenbank: " + currentBereich + " index in altem Datenbestand=" + index));
                                    VerwaltungsbereichCustomBean oldBereich = oldBereicheVector.get(index);
                                    VerwaltendeDienststelleCustomBean oldDienststelle = oldBereich.getDienststelle();
                                    VerwaltendeDienststelleCustomBean newDienststelle = currentBereich.getDienststelle();
                                    if (oldDienststelle != null && newDienststelle != null) {
                                        if (LOG.isDebugEnabled()) {
                                            LOG.debug((Object)("AlteDienstelle=" + oldDienststelle + " NeueDienststelle=" + newDienststelle));
                                        }
                                        if (oldDienststelle.equals(newDienststelle)) {
                                            if (LOG.isDebugEnabled()) {
                                                LOG.debug((Object)"Dienstelle des Verwaltungsbereich ist gleich geblieben");
                                            }
                                        } else {
                                            if (LOG.isDebugEnabled()) {
                                                LOG.debug((Object)"Dienstelle des Verwaltungsbereichs hat sich ge\u00e4ndert");
                                            }
                                            modDienststellen.add(Message.createNewMessage(3, 2, oldDienststelle, newDienststelle));
                                        }
                                    } else if (oldDienststelle == null) {
                                        if (LOG.isDebugEnabled()) {
                                            LOG.debug((Object)"Einem vorhandenen Verwaltungsbereich wurde eine Dienstelle zugeordnet");
                                        }
                                        addedDienststellen.add(Message.createNewMessage(3, 0, newDienststelle));
                                    } else {
                                        if (LOG.isDebugEnabled()) {
                                            LOG.debug((Object)"Eine vorhandene Dienstellenzuordnung wurde entfernt");
                                        }
                                        deletedDienststellen.add(Message.createNewMessage(3, 1, oldDienststelle));
                                    }
                                    oldBereicheVector.remove(currentBereich);
                                    continue;
                                }
                                if (currentBereich.getId() != null && currentBereich.getId() != -1) {
                                    LOG.error((Object)"Verwaltungsbereich hat eine ID, existiert aber nicht in altem Datenbestand --> equals funktioniert nicht");
                                    this.messages.add(Message.createNewMessage(1, 5, "Verwaltungsbereich hat eine ID, existiert aber nicht in altem Datenbestand", currentBereich));
                                    continue;
                                }
                                LOG.fatal((Object)("nichtbehandelter fall currentBereich: " + currentBereich));
                                this.messages.add(Message.createNewMessage(1, 5, "Ein bei der automatischen Generierung von Emails nicht behandelter Fall ist aufgetreten", currentBereich));
                            }
                            catch (Exception ex) {
                                LOG.error((Object)"Fehler beim abgeleich von alten und neuen Verwaltungsbereichen f\u00fcr die emailbenachrichtigung", (Throwable)ex);
                                this.messages.add(Message.createNewMessage(1, 5, "Es gab einen Fehler beim abgleichen alter und neuer Verwaltungsbereiche", ex, currentBereich));
                            }
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"gel\u00f6schte Verwaltungsbereiche erfassen");
                        }
                        for (VerwaltungsbereichCustomBean currentBereich : oldBereicheVector) {
                            try {
                                VerwaltendeDienststelleCustomBean oldDienststelle;
                                if (newBereiche.contains(currentBereich)) continue;
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)("Verwaltungsbereich existiert nicht mehr in neuem Datenbestand: " + currentBereich));
                                }
                                if ((oldDienststelle = currentBereich.getDienststelle()) == null) {
                                    if (!LOG.isDebugEnabled()) continue;
                                    LOG.debug((Object)"F\u00fcr Verwaltungsbereich wurde keine Dienstelle zugeordnet");
                                    continue;
                                }
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)"Verwaltungsbereich hatte eine Dienstelle");
                                }
                                deletedDienststellen.add(Message.createNewMessage(3, 1, oldDienststelle));
                            }
                            catch (Exception ex) {
                                this.messages.add(Message.createNewMessage(1, 5, "Es gab einen Fehler beim ermitteln, welche Verwaltungsbereiche gel\u00f6scht wurden", ex, currentBereich));
                            }
                        }
                        this.messages.addAll(addedDienststellen);
                        this.messages.addAll(modDienststellen);
                        this.messages.addAll(deletedDienststellen);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Nachrichten insgesamt: " + this.messages.size() + "davon sind neue Dienstellen=" + addedDienststellen.size() + " gel\u00f6schte=" + deletedDienststellen.size() + " modifizierte=" + modDienststellen.size()));
                        }
                    }
                }
                catch (Exception ex) {
                    LOG.fatal((Object)"Fehler bei der email benachrichtigung", (Throwable)ex);
                    this.messages.add(Message.createNewMessage(1, 7, "LagIS - Fehler beim erstellen der automatischen Emails", ex));
                }
                this.modifyFlurstueck(this.currentFlurstueck);
            }
            if (this.currentRebes != null) {
                for (RebeCustomBean rebe : this.currentRebes) {
                    rebe.persist();
                }
            }
            if (this.currentMipas != null) {
                for (MipaCustomBean mipa : this.currentMipas) {
                    mipa.persist();
                }
            }
        }
        catch (Exception ex) {
            this.showError("Fehler beim speichern", "Das Flurst\u00fcck konnte nicht gespeichert werden.", ex);
        }
    }

    public FlurstueckCustomBean getCurrentFlurstueck() {
        return this.currentFlurstueck;
    }

    public boolean isCurrentFlurstueckLockedByUser() {
        if (this.currentFlurstueck != null) {
            return this.currentFlurstueck.getFlurstueckSchluessel().isGesperrt();
        }
        return false;
    }

    public boolean isInWfsMode() {
        return this.isInWfsMode;
    }

    public boolean isIsInWfsMode() {
        return this.isInWfsMode;
    }

    public void setIsInWfsMode(boolean isInWfsMode) {
        this.isInWfsMode = isInWfsMode;
    }

    public void setTitleBarComponentpainter(Color color) {
        this.getRootWindow().getRootWindowProperties().getViewProperties().getViewTitleBarProperties().getNormalProperties().getShapedPanelProperties().setComponentPainter((ComponentPainter)new GradientComponentPainter(color, new Color(236, 233, 216), color, new Color(236, 233, 216)));
    }

    public void setTitleBarComponentpainter(Color left, Color right) {
        this.getRootWindow().getRootWindowProperties().getViewProperties().getViewTitleBarProperties().getNormalProperties().getShapedPanelProperties().setComponentPainter((ComponentPainter)new GradientComponentPainter(left, right, left, right));
    }

    public Refreshable getRefreshableByClass(Class<?> refreshClass) {
        for (Refreshable refreshable : this.widgets) {
            if (!refreshable.getClass().equals(refreshClass)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"ein Refreshable gefunden");
            }
            return refreshable;
        }
        return null;
    }

    public void refreshWidgets() {
        for (Refreshable refreshable : this.widgets) {
            refreshable.refresh(null);
        }
    }

    public RootWindow getRootWindow() {
        return this.rootWindow;
    }

    public void setRootWindow(RootWindow rootWindow) {
        this.rootWindow = rootWindow;
    }

    @Override
    public boolean isFlurstueckChangeInProgress() {
        return this.flustueckChangeInProgress;
    }

    public void addWfsFlurstueckGeometryChangeListener(LagisBrokerPropertyChangeListener listener) {
        this.wfsFlurstueckChangeListeners.add(listener);
    }

    @Override
    public synchronized void fireFlurstueckChanged(FlurstueckCustomBean newFlurstueck) {
        this.getMappingComponent().getFeatureCollection().unselectAll();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"FlurstueckChangeEvent");
        }
        LagisBroker.warnIfThreadIsNotEDT();
        this.resetWidgets();
        this.getMappingComponent().getFeatureCollection().removeAllFeatures();
        if (newFlurstueck != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"neues Flurst\u00fcck != null");
            }
            this.observedFlurstueckChangedListeners.clear();
            for (Widget widget : this.widgets) {
                if (!(widget instanceof FlurstueckChangeListener)) continue;
                this.observedFlurstueckChangedListeners.add((FlurstueckChangeListener)((Object)widget));
            }
            this.flustueckChangeInProgress = true;
            this.currentFlurstueck = newFlurstueck;
            this.setCurrentFlurstueckSchluessel(newFlurstueck.getFlurstueckSchluessel(), false);
            this.setWidgetsEditable(false);
            for (Widget curWidget : this.widgets) {
                if (!(curWidget instanceof FlurstueckChangeListener)) continue;
                ((FlurstueckChangeListener)((Object)curWidget)).flurstueckChanged(newFlurstueck);
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"neues Flurst\u00fcck == null");
            }
            this.observedFlurstueckChangedListeners.clear();
            this.setWidgetsEditable(false);
            this.currentFlurstueck = newFlurstueck;
            this.setCurrentFlurstueckSchluessel(null, true);
            this.flustueckChangeInProgress = true;
        }
    }

    public void setIsUnkownFlurstueck(boolean isUnkown) {
        if (this.isUnkownFlurstueck()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Flurst\u00fcckSchl\u00fcssel ist unbekannt: " + isUnkown));
            }
            LOG.info((Object)"setze currentFlurst\u00fcck=null");
            LagisApp.getInstance().setFlurstueckUnkown();
        }
        this.isUnkown = isUnkown;
    }

    public void setCurrentFlurstueckSchluessel(FlurstueckSchluesselCustomBean flurstueckSchluessel, boolean isUnkown) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"setCurrentFlurstueckSchluessel");
        }
        if (this.currentFlurstueck != null && !isUnkown) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"CurrentFlurstueckSchluessel ist ein bekanntes Flurst\u00fcck");
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"CurrentFlurstueckSchluessel ist ein unbekanntes Flurst\u00fcck");
        }
        this.setIsUnkownFlurstueck(isUnkown);
        this.currentFlurstueckSchluessel = flurstueckSchluessel;
    }

    public FlurstueckSchluesselCustomBean getCurrentFlurstueckSchluessel() {
        return this.currentFlurstueckSchluessel;
    }

    public boolean isUnkownFlurstueck() {
        return this.isUnkown;
    }

    @Override
    public void flurstueckChangeFinished(FlurstueckChangeListener fcListener) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("FlurstueckChangeListener hat update beendet: " + fcListener));
        }
        this.observedFlurstueckChangedListeners.remove(fcListener);
        if (this.observedFlurstueckChangedListeners.isEmpty() && (this.flustueckChangeInProgress || this.isUnkown)) {
            if (this.isUnkown && LOG.isDebugEnabled()) {
                LOG.debug((Object)"Flurstueck is unkown");
            }
            this.flustueckChangeInProgress = false;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Alle FlurstueckChangeListener sind fertig --> zoom");
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LagisBroker.this.mappingComponent.zoomToFeatureCollection();
                }
            });
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Anzahl restlicher Listener: " + this.observedFlurstueckChangedListeners.size()));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Anzahl restlicher Listener: " + this.observedFlurstueckChangedListeners));
                LOG.debug((Object)("flurstueckChange in progress: " + this.flustueckChangeInProgress));
                LOG.debug((Object)("isUnkown " + this.isUnkown));
            }
        }
    }

    public static Date getDateWithoutTime(Date date) {
        CALENDAR.setTime(date);
        CALENDAR.set(10, 0);
        CALENDAR.set(12, 0);
        CALENDAR.set(13, 0);
        CALENDAR.set(14, 0);
        CALENDAR.set(9, 0);
        return CALENDAR.getTime();
    }

    public String getAccountName() {
        if (this.account == null) {
            LOG.fatal((Object)("Benutzername unvollst\u00e4ndig: " + this.account));
        }
        return this.account;
    }

    public void setAccountName(String aAccount) {
        this.account = aAccount;
    }

    public boolean isFullReadOnlyMode() {
        return this.isFullReadOnlyMode;
    }

    public void setFullReadOnlyMode(boolean isFullReadOnlyMode) {
        this.isFullReadOnlyMode = isFullReadOnlyMode;
    }

    public boolean isCoreReadOnlyMode() {
        return this.isCoreReadOnlyMode;
    }

    public void setCoreReadOnlyMode(boolean isCoreReadOnlyMode) {
        this.isCoreReadOnlyMode = isCoreReadOnlyMode;
    }

    public Element getConfiguration() {
        return null;
    }

    public void masterConfigure(Element parent) {
        try {
            Element email = parent.getChild("emailConfiguration");
            this.developerMailaddresses = new Vector();
            this.nkfMailaddresses = new Vector();
            this.maintenanceMailAddresses = new Vector();
            this.nkfRecipients = new StringBuffer();
            this.developerRecipients = new StringBuffer();
            this.maintenanceRecipients = new StringBuffer();
            try {
                this.emailConfig = new EmailConfig();
                this.emailConfig.setUsername(email.getAttributeValue("username"));
                this.emailConfig.setPassword(email.getAttributeValue("password"));
                this.emailConfig.setSenderAddress(email.getAttributeValue("senderAddress"));
                this.emailConfig.setSmtpServer(email.getAttributeValue("smtpHost"));
                for (Element nkfReveiver : email.getChild("nkfMailAddresses").getChildren()) {
                    this.nkfMailaddresses.add(nkfReveiver.getText());
                    this.nkfRecipients.append(nkfReveiver.getText() + ",");
                }
                for (Element developerReveiver : email.getChild("developerMailaddresses").getChildren()) {
                    this.developerMailaddresses.add(developerReveiver.getText());
                    this.developerRecipients.append(developerReveiver.getText() + ",");
                }
                for (Element maintenanceReveiver : email.getChild("maintenanceMailaddresses").getChildren()) {
                    this.maintenanceMailAddresses.add(maintenanceReveiver.getText());
                    this.maintenanceRecipients.append(maintenanceReveiver.getText() + ",");
                }
                this.developerRecipients.deleteCharAt(this.developerRecipients.length() - 1);
                this.nkfRecipients.deleteCharAt(this.nkfRecipients.length() - 1);
                this.maintenanceRecipients.deleteCharAt(this.maintenanceRecipients.length() - 1);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Emails werden von: " + this.emailConfig + " verschickt"));
                    LOG.debug((Object)("Empf\u00e4nger vorhanden: nkf=" + this.nkfMailaddresses.size() + " admin=" + this.developerMailaddresses.size() + " maintenance=" + this.maintenanceMailAddresses.size()));
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Empf\u00e4nger vorhanden: nkf=" + this.nkfRecipients.toString() + " admin=" + this.developerRecipients.toString() + " maintenance=" + this.developerRecipients.toString()));
                }
                if (this.nkfMailaddresses.size() == 0 || this.developerMailaddresses.size() == 0 || this.maintenanceMailAddresses.size() == 0) {
                    throw new Exception("Eine oder mehrere Emailadressen sind nicht konfiguriert");
                }
            }
            catch (Exception ex) {
                LOG.fatal((Object)"Fehler beim konfigurieren der Emaileinstellungen, es k\u00f6nnen keine Emails versand werden.", (Throwable)ex);
                this.emailConfig = null;
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Fehler beim konfigurieren des Lagis Brokers: ", (Throwable)ex);
        }
    }

    public void configure(Element parent) {
    }

    public List<RebeCustomBean> getCurrentRebes() {
        return this.currentRebes;
    }

    public List<MipaCustomBean> getCurrentMipas() {
        return this.currentMipas;
    }

    public void setCurrentWFSGeometry(Geometry geom) {
        Geometry oldWFSGeometry = geom;
        this.currentWFSGeometry = geom;
        for (LagisBrokerPropertyChangeListener listener : this.wfsFlurstueckChangeListeners) {
            try {
                listener.propertyChange(new PropertyChangeEvent(this, "currentWFSGeometry", oldWFSGeometry, this.currentWFSGeometry));
            }
            catch (Exception ex) {
                LOG.error((Object)"Exception in PropertyChange propagation", (Throwable)ex);
            }
        }
        new SwingWorker<List, Void>(){

            @Override
            protected List doInBackground() throws Exception {
                if (LagisBroker.this.currentWFSGeometry != null) {
                    return LagisBroker.this.getRechteUndBelastungen(LagisBroker.this.currentWFSGeometry);
                }
                return null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void done() {
                List oldRebes = LagisBroker.this.currentRebes;
                try {
                    LagisBroker.this.currentRebes = (List)this.get();
                }
                catch (Exception ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                    LagisBroker.this.currentRebes = null;
                }
                finally {
                    for (LagisBrokerPropertyChangeListener listener : LagisBroker.this.wfsFlurstueckChangeListeners) {
                        try {
                            listener.propertyChange(new PropertyChangeEvent(this, "currentRebes", oldRebes, LagisBroker.this.currentRebes));
                        }
                        catch (Exception ex) {
                            LOG.error((Object)"Exception in PropertyChange propagation", (Throwable)ex);
                        }
                    }
                }
            }
        }.execute();
        new SwingWorker<List, Void>(){

            @Override
            protected List doInBackground() throws Exception {
                if (LagisBroker.this.currentWFSGeometry != null) {
                    return LagisBroker.this.getMiPas(LagisBroker.this.currentWFSGeometry);
                }
                return null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void done() {
                List oldMipas = LagisBroker.this.currentMipas;
                try {
                    LagisBroker.this.currentMipas = (List)this.get();
                }
                catch (Exception ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                    LagisBroker.this.currentMipas = null;
                }
                finally {
                    for (LagisBrokerPropertyChangeListener listener : LagisBroker.this.wfsFlurstueckChangeListeners) {
                        try {
                            listener.propertyChange(new PropertyChangeEvent(this, "currentMipas", oldMipas, LagisBroker.this.currentMipas));
                        }
                        catch (Exception ex) {
                            LOG.error((Object)"Exception in PropertyChange propagation", (Throwable)ex);
                        }
                    }
                }
            }
        }.execute();
    }

    public Geometry getCurrentWFSGeometry() {
        return this.currentWFSGeometry;
    }

    public String getCurrentValidationErrorMessage() {
        return this.currentValidationErrorMessage;
    }

    public StatusBar getStatusBar() {
        return this.statusBar;
    }

    public void setStatusBar(StatusBar statusBar) {
        this.statusBar = statusBar;
    }

    public GemarkungCustomBean getGemarkungForKey(Integer key) {
        GemarkungCustomBean resolvedGemarkung = null;
        if (this.gemarkungsHashMap != null) {
            resolvedGemarkung = this.gemarkungsHashMap.get(key);
        } else {
            this.gemarkungsHashMap = this.getGemarkungsHashMap();
            if (this.gemarkungsHashMap != null) {
                resolvedGemarkung = this.gemarkungsHashMap.get(key);
            }
        }
        return resolvedGemarkung;
    }

    public static void warnIfThreadIsNotEDT() {
        if (!EventQueue.isDispatchThread()) {
            LOG.fatal((Object)"current Thread is not EDT, but should be --> look", (Throwable)new CurrentStackTrace());
        }
    }

    public static void warnIfThreadIsEDT() {
        if (EventQueue.isDispatchThread()) {
            LOG.fatal((Object)"current Thread is EDT, but should not --> look", (Throwable)new CurrentStackTrace());
        }
    }

    public void execute(SwingWorker workerThread) {
        try {
            this.execService.submit(workerThread);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"SwingWorker an Threadpool \u00fcbermittelt");
            }
        }
        catch (Exception ex) {
            LOG.fatal((Object)"Fehler beim starten eines Swingworkers", (Throwable)ex);
        }
    }

    public void setVerdisCrossoverPort(int port) {
        this.verdisCrossoverPort = port;
    }

    public int getVerdisCrossoverPort() {
        return this.verdisCrossoverPort;
    }

    public void setKassenzeichenBuffer(double kassenzeichenBuffer) {
        this.kassenzeichenBuffer = kassenzeichenBuffer;
    }

    public double getKassenzeichenBuffer() {
        return this.kassenzeichenBuffer;
    }

    public void setKassenzeichenBuffer100(double kassenzeichenBuffer100) {
        this.kassenzeichenBuffer100 = kassenzeichenBuffer100;
    }

    public double getKassenzeichenBuffer100() {
        return this.kassenzeichenBuffer100;
    }

    public void setRebeBuffer(double rebeBuffer) {
        this.rebeBuffer = rebeBuffer;
    }

    public double getRebeBuffer() {
        return this.rebeBuffer;
    }

    public void setMipaBuffer(double mipaBuffer) {
        this.mipaBuffer = mipaBuffer;
    }

    public double getMipaBuffer() {
        return this.mipaBuffer;
    }

    public boolean isLoggedIn() {
        return this.loggedIn;
    }

    public void setLoggedIn(boolean loggedIn) {
        this.loggedIn = loggedIn;
    }

    public String getConnectionClass() {
        return this.connectionClass;
    }

    public void setConnectionClass(String connectionClass) {
        this.connectionClass = connectionClass;
    }

    public String getCallserverUrl() {
        return this.callserverUrl;
    }

    public void setCallserverUrl(String callserverUrl) {
        this.callserverUrl = callserverUrl;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public boolean isSkipSecurityCheckFlurstueckAssistent() {
        return this.skipSecurityCheckFlurstueckAssistent;
    }

    public void setSkipSecurityCheckFlurstueckAssistent(boolean skipSecurityCheckFlurstueckAssistent) {
        this.skipSecurityCheckFlurstueckAssistent = skipSecurityCheckFlurstueckAssistent;
    }

    public boolean checkFlurstueckWizardUserWantsToFinish() {
        return this.isSkipSecurityCheckFlurstueckAssistent() || JOptionPane.showConfirmDialog(LagisApp.getInstance(), "<html>M\u00f6chten Sie die Aktion wirklich abschlie\u00dfen ?", "Sicherheitsabfrage", 2) == 0;
    }

    public void setTotd(String totd) {
        this.totd = totd;
        this.refreshAppTitle();
    }

    public void setTitle(String title) {
        this.title = title;
        this.refreshAppTitle();
    }

    private void refreshAppTitle() {
        if (SwingUtilities.isEventDispatchThread()) {
            if (this.totd == null || this.totd.trim().isEmpty()) {
                LagisApp.getInstance().setTitle(this.title);
            } else {
                LagisApp.getInstance().setTitle(this.title + " - " + this.totd);
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LagisBroker.this.refreshAppTitle();
                }
            });
        }
    }

    public boolean checkPermissionBaulasten() {
        MetaClass mc = null;
        try {
            mc = CidsBean.getMetaClassFromTableName((String)"WUNDA_BLAU", (String)"alb_baulastblatt");
        }
        catch (Exception ex) {
            LOG.info((Object)"exception while getting metaclass alb_baulastblatt", (Throwable)ex);
        }
        return mc != null;
    }

    public boolean checkPermissionRisse() {
        MetaClass mc = null;
        try {
            mc = CidsBean.getMetaClassFromTableName((String)"WUNDA_BLAU", (String)"vermessung_riss");
        }
        catch (Exception ex) {
            LOG.info((Object)"exception while getting metaclass vermessung_riss", (Throwable)ex);
        }
        return mc != null;
    }

    public static enum HistoryType {
        SUCCESSOR,
        PREDECESSOR,
        BOTH;

    }

    public static enum HistorySibblingLevel {
        NONE,
        SIBBLING_ONLY,
        FULL,
        CUSTOM;

    }

    public static enum HistoryLevel {
        DIRECT_RELATIONS,
        All,
        CUSTOM;

    }
}

