/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.broker;

import de.cismet.cids.custom.beans.lagis.FlurstueckSchluesselCustomBean;
import de.cismet.cids.custom.beans.lagis.GemarkungCustomBean;
import de.cismet.lagis.broker.LagisBroker;
import de.cismet.lagis.gui.main.LagisApp;
import de.cismet.remote.AbstractRESTRemoteControlMethod;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.apache.log4j.Logger;

@Path(value="/loadFlurstueck")
public class LoadFlurstueckRemoteMethod
extends AbstractRESTRemoteControlMethod {
    private static final Logger LOG = Logger.getLogger(LoadFlurstueckRemoteMethod.class);
    @Context
    private UriInfo context;

    public LoadFlurstueckRemoteMethod() {
        super(-1, "/loadFlurstueck");
    }

    @GET
    @Produces(value={"text/html"})
    public String loadFlurstueck(@QueryParam(value="gemarkung") String gemarkung, @QueryParam(value="flur") int flur, @QueryParam(value="zaehler") int zaehler, @QueryParam(value="nenner") int nenner) {
        try {
            String host = this.context.getBaseUri().getHost();
            if (!host.equals("localhost") && !host.equals("127.0.0.1")) {
                LOG.info((Object)("Keine Request von remote rechnern m\u00f6glich: " + host));
                return "<html>Es k\u00f6nnen nur Requests vom lokalen Rechner abgesetzt werden. Es kann nicht zum gew\u00fcnschten Flurst\u00fcck gewechselt werden</html>";
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Fehler beim bestimmen des Hosts Request nicht m\u00f6glich", (Throwable)ex);
            return "<html>Der Host konnte nicht bestimmt werden. Es kann nicht zum gew\u00fcnschten Flurst\u00fcck gewechselt werden</html>";
        }
        if (LagisBroker.getInstance().isLoggedIn()) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Crossover: Rest Method load flurstueck called with params: " + gemarkung + " " + flur + " " + zaehler + "/" + nenner));
                }
                FlurstueckSchluesselCustomBean key = FlurstueckSchluesselCustomBean.createNew();
                GemarkungCustomBean gem = GemarkungCustomBean.createNew();
                gem.setBezeichnung(gemarkung);
                gem = LagisBroker.getInstance().completeGemarkung(gem);
                if (gem == null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Change of Flurstueck not possible! No such Gemarkung: " + key));
                    }
                    return "<html>Change of Flurstueck not possible! No such Gemarkung: " + key + "</html>";
                }
                key.setGemarkung(gem);
                key.setFlur(flur);
                key.setFlurstueckZaehler(zaehler);
                key.setFlurstueckNenner(nenner);
                if (key != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("found a key on server: " + key));
                    }
                } else {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Change of Flurstueck not possible! No such key: " + key));
                    }
                    return "<html>Change of Flurstueck not possible! No such key: " + key + "</html>";
                }
                LagisBroker.getInstance().loadFlurstueck(key);
                LagisApp.getInstance().toFront();
            }
            catch (Exception ex) {
                LOG.error((Object)"Failure during loadFlurstueck: ", (Throwable)ex);
                return "<html>Fehler beim laden des Flrust\u00fccks: " + ex.getMessage() + "</html>";
            }
            return "<html>Gehe zu Flurstueck: </html>";
        }
        String notLoggedIn = "Flurst\u00fcck kann nicht geladen werden. Benutzer ist noch nicht eingeloggt.";
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Flurst\u00fcck kann nicht geladen werden. Benutzer ist noch nicht eingeloggt.");
        }
        return "<html>Flurst\u00fcck kann nicht geladen werden. Benutzer ist noch nicht eingeloggt.</html>";
    }
}

