/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.editor;

import de.cismet.lagis.models.documents.FlaecheDocumentModel;
import de.cismet.lagis.validation.Validatable;
import de.cismet.lagis.validation.Validator;
import javax.swing.DefaultCellEditor;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class FlaecheEditor
extends DefaultCellEditor {
    JTextField txtFlaeche;
    private final transient Logger log = Logger.getLogger(this.getClass());
    private Integer minimum;
    private Integer maximum;
    private boolean DEBUG = false;
    private Validator validator;

    public FlaecheEditor() {
        super(new JTextField());
        this.delegate = new DefaultCellEditor.EditorDelegate(){

            @Override
            public void setValue(Object value) {
                if (value instanceof Integer) {
                    FlaecheEditor.this.txtFlaeche.setText(value.toString());
                } else {
                    FlaecheEditor.this.txtFlaeche.setText(value != null ? value.toString() : "0");
                }
            }

            @Override
            public Object getCellEditorValue() {
                return FlaecheEditor.this.txtFlaeche.getText();
            }
        };
        this.txtFlaeche = (JTextField)this.getComponent();
        this.txtFlaeche.setDocument(new FlaecheDocumentModel());
        this.validator = new Validator(this.txtFlaeche);
        this.validator.reSetValidator((Validatable)((Object)this.txtFlaeche.getDocument()));
        this.txtFlaeche.setHorizontalAlignment(0);
    }

    @Override
    public Object getCellEditorValue() {
        String t = "";
        try {
            JTextField txtFlaeche = (JTextField)this.getComponent();
            t = txtFlaeche.getText();
            if (this.validator.getValidationState() == 0) {
                return Integer.parseInt(t);
            }
            return t;
        }
        catch (NumberFormatException exc) {
            this.log.error((Object)"Error in getCellEditorValue()", (Throwable)exc);
            return t;
        }
    }

    public int getValidationState() {
        return this.validator.getValidationState();
    }

    public String getText() {
        return this.txtFlaeche.getText();
    }
}

