/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.gui.checkbox;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class IconCheckBox
extends JPanel {
    private final JCheckBox checkBox = new JCheckBox();
    private final JLabel iconLabel = new JLabel();
    private final JLabel textLabel = new JLabel();

    public IconCheckBox() {
        super.setLayout(new FlowLayout(0));
        super.add(this.checkBox);
        super.add(this.iconLabel);
        super.add(this.textLabel);
    }

    public void setIcon(Icon icon) {
        if (icon == null) {
            throw new NullPointerException();
        }
        this.iconLabel.setIcon(icon);
    }

    public Icon getIcon() {
        if (this.iconLabel == null) {
            return null;
        }
        return this.iconLabel.getIcon();
    }

    public void setText(String text) {
        this.textLabel.setText(text);
    }

    public String getText() {
        if (this.textLabel == null) {
            return null;
        }
        return this.textLabel.getText();
    }

    public void setSelected(boolean selected) {
        this.checkBox.setSelected(selected);
    }

    public boolean isSelected() {
        return this.checkBox.isSelected();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.checkBox.setEnabled(enabled);
        this.iconLabel.setEnabled(enabled);
        this.textLabel.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    @Override
    public boolean isEnabled() {
        return this.checkBox.isEnabled();
    }

    public void addActionListener(ActionListener listener) {
        this.checkBox.addActionListener(listener);
    }

    public static void main(String[] args) {
        final IconCheckBox box = new IconCheckBox();
        ImageIcon icon = new ImageIcon(IconCheckBox.class.getResource("/de/cismet/lagis/ressource/icons/titlebar/flurstueck16.png"));
        box.setIcon(icon);
        box.setText("TEST");
        box.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JOptionPane.showMessageDialog(box, "Hi");
            }
        });
        JFrame frame = new JFrame();
        frame.add(box);
        frame.setSize(100, 100);
        frame.setVisible(true);
    }
}

