/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.gui.checkbox;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class JCheckBoxList
extends JList {
    protected static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

    public JCheckBoxList() {
        this.setCellRenderer(new CheckBoxCellRenderer());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int index = JCheckBoxList.this.locationToIndex(e.getPoint());
                Rectangle test = null;
                if (index != -1 && (test = JCheckBoxList.this.getCellBounds(index, index)) != null && test.contains(e.getPoint()) && JCheckBoxList.this.isEnabled()) {
                    JCheckBox checkbox;
                    checkbox.setSelected(!(checkbox = (JCheckBox)JCheckBoxList.this.getModel().getElementAt(index)).isSelected());
                    JCheckBoxList.this.repaint();
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int index;
                if (e.getKeyCode() == 32 && (index = JCheckBoxList.this.getSelectedIndex()) != -1 && JCheckBoxList.this.isEnabled()) {
                    JCheckBox checkbox;
                    checkbox.setSelected(!(checkbox = (JCheckBox)JCheckBoxList.this.getModel().getElementAt(index)).isSelected());
                    JCheckBoxList.this.repaint();
                }
            }
        });
        this.setSelectionMode(0);
    }

    protected class CheckBoxCellRenderer
    implements ListCellRenderer {
        protected CheckBoxCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JCheckBox checkbox = (JCheckBox)value;
            checkbox.setEnabled(JCheckBoxList.this.isEnabled());
            checkbox.setFont(JCheckBoxList.this.getFont());
            return checkbox;
        }
    }
}

